
#
#    ========== licence begin LGPL
#    Copyright (C) 2002 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#
do "$ENV{'TOOL'}\\bin\\remuser_mach$ENV{'TOOLEXT'}";

if ( $ARGV[0] ) {
    my $Host = getRemuserhost ( $ARGV[0]);
    if (defined $Host)
    {
        print "\nremuser host in $ENV{RELVER}:\n\n";
        printf ("%10s -> %s\n", $ARGV[0],$Host);
    } else {
        print "\nno remuser host known for '$ARGV[0]'\n";
    }
} else {
    print "\nremuser hosts in $ENV{RELVER}:\n\n";
    foreach my $osvar ( keys %REMUSER_HOST ) {
        printf ("%10s -> %s\n", $osvar,$REMUSER_HOST{$osvar});
    }
}

sub getRemuserhost {
	my $Platform=shift;
	my $Release;
	my $Host=undef;

	if ( defined $ENV{IGME_VERSION} ) {
		$Release = substr( $ENV{IGME_VERSION}, 0, 3 );
		if ( defined $REMUSER_HOST{"${Platform}_${Release}"} ) {
			$Host = $REMUSER_HOST{"${Platform}_${Release}"};
		}
	}
	else {
		if ( defined($ENV{RELVER})
		  && defined($ENV{CORRECTION_LEVEL}) ) {
			$Release = "$ENV{RELVER}";
			$Release =~ s/R(\d)(\d+)/$1.$2/;
			if ( defined $REMUSER_HOST{"${Platform}_${Release}"} ) {
				$Host = $REMUSER_HOST{"${Platform}_${Release}"};
			}
		}

	}
	unless (defined $Host)
	{
		$Host = $REMUSER_HOST{${Platform}};
	}
	if (defined $Host)
	{
		print "Using ${Platform} : $Host".
			(($REMUSER_HOSTMODE{$Host} =~ /web/i) ? " (webmake)" : "") . "\n";
	}
	return $Host;
}
