#!/usr/bin/perl
# pcmktest
#
# @(#)pccar
#
# Generate car archive for the given intrerfacetest
#
# Burkhard Diesing
#
#
#    ========== licence begin LGPL
#    Copyright (C) 2002 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#

package pccar;
use Env;
use Getopt::Std;
sub _system;

$Trace=1 if ($ENV{PCTOOL_TRACE});
$USAGE ="USAGE: pccar -[ca] <archivename> <wrkdir> <listfile>\n";
if (!getopts ('cah') || $opt_h || ($opt_a && $opt_c)) {
   print $USAGE;
   exit 2;
}

if (@ARGV < 2 ) {
  print $USAGE;
  exit 2;
}

my ($ARCHIVE, $WRKDIR) = @ARGV;
print "$ARCHIVE, $WRKDIR\n" if ($Trace);
if (defined $ENV{BIT64}) {
    $_ARCHIVE="$ENV{OWN}/sys/wrk/fast/obj/${MACH}_${OSSPEC}_64.$ARCHIVE.sar";
}
else {
    $_ARCHIVE="$ENV{OWN}/sys/wrk/fast/obj/${MACH}_${OSSPEC}_32.$ARCHIVE.sar";
}
$LISTFILE="$ENV{OWN}/sys/wrk/fast/obj/$ARCHIVE.lst";

$WRKDIR="$ENV{OWN}/$WRKDIR";

if (! -d $WRKDIR ) {
    print "ERROR: Workingdirectory $WRKDIR doesn't exist.";
    exit -1;
}

if (! -f $LISTFILE ) {
    print "ERROR: Listfile $LISTFILE doesn't exist.";
    exit -1;
}

if ($opt_a) {
    if (! -f $_ARCHIVE ) {
        print "ERROR: Archive $_ARCHIVE doesn't exist.";
        exit -1;
    }
    $CMD_CAR = "SAPCAR -avf ";
}
if ($opt_c) {
    $CMD_CAR = "SAPCAR -cvf ";
}

$rc = 0;
open(FILE_IN, "<$LISTFILE") || die "Can't open $LISTFILE (input): $!";
open(FILE_OUT, ">$TMP/$ARCHIVE.lst") || die "Can't open $TMP/$ARCHIVE.lst (output): $!";
 LINE:
while(<FILE_IN>) {
    if (m/^\#.*/) {
        next LINE;
    }
    if (!m/.*\|.*/) {
       $target = "";
       ($source) = m/(.*)/;
    }
    else {
       ($source,$target) = m/(.*)\|(.*)/;
    }
    if ( $target eq "" ) {
        $target = $source;
    }
    if ( $source ne "" && $target ne "" ) {
       if ( $source eq "" || ! -r "$WRKDIR/$source") {
          print "ERROR: Can't find $WRKDIR/$source for $_ARCHIVE.\n";
          $rc = -1;
       }
       else {
          print FILE_OUT "$source | $target\n";
      }
    }
}
close FILE_IN;
close FILE_OUT;
if ($rc == 0) {
    $rc = _system ("$CMD_CAR $_ARCHIVE -C $WRKDIR -T $TMP/$ARCHIVE.lst");
}
unlink "$TMP/$ARCHIVE.lst";

exit $rc;

sub _system
{
    print "$_[0]\n" if ($Trace);
    return system($_[0]);
}
