#!/usr/bin/perl
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

use Env;
use Getopt::Std;

$Usage = "usage: gendoxy [-h] [-o output_directory] [-c config] (file|dir) [ (file|dir) ... ]\n";


die "" if !getopts('ho:c:');
if (  @ARGV == 0 && !defined($opt_h))
{
	die $Usage;
}

if (defined($opt_o))
{
    $ENV{OUTPUT_DIRECTORY} = $opt_o;
    $ENV{GENERATE_HTML} = "YES";
}
else
{
    $ENV{GENERATE_HTML} = "NO";
}

if (@ARGV == 1)
{
    $ENV{FILENAME} = "@ARGV[0]";
}
else
{
    $ENV{FILENAME} = "@ARGV[0,-1]";
}

if (defined($opt_c))
{
    $CONFIGFILE = "$ENV{OWN}\\sys\\config\\$opt_c.doxygen";
}
else
{
    $CONFIGFILE = "$ENV{OWN}\\sys\\config\\gendoxy.doxygen";
}

die "ERROR: configfile $CONFIGFILE not found" unless -f $CONFIGFILE;

$CMD="doxygen $CONFIGFILE";
system ("$CMD");
