package com.sap.sapdb.DBMTest.scheduler;

/*
    ========== licence begin  GPL
    Copyright (c) 2002-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*/

import java.sql.SQLException;

import com.sap.sapdb.DBMTest.util.DBMUtility;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestProtocol;

public class DeactivateJob extends SchedulerTestCase {

    private static final String JOBSTATUS_INACTIVE = "inactive";
    static private final int TESTJOB_TIME_DELTA = 30*60; //30 minutes, we're not interested in execution
    
    /**
     * @throws SQLException
     * @throws TestDatabaseException
     */
    public DeactivateJob() throws SQLException, TestDatabaseException {
        super();
    }

    /* (non-Javadoc)
     * @see java.lang.Runnable#run()
     */
    public void runSchedulerTest() {
        try {
            // schedule a job
            scheduleJob(TESTJOB_TIME_DELTA);
            //saveSchedulerPid(); is done inside scheduleJob
            
            // deactivate it
            String cmdDeactivate = CMD_deactivate_job + " 0";
            boolean isExpectedReply = m_DBM.execCmd(
                    cmdDeactivate,
                    DBMUtility.OK_OK);
            if( !isExpectedReply ) {
                throw new SchedulerException(
                    cmdDeactivate,
                    m_DBM.getAnswer());
            }

            // check if it's still in the list and deactivated
            isExpectedReply = m_DBM.execCmd(
                    CMD_list,
                    DBMUtility.OK_OK);
            String cmdAnswer = m_DBM.getAnswer();
                    
            if( !isExpectedReply ) {
                throw new SchedulerException(
                    CMD_list,
                    cmdAnswer);
            }
            else {
                if( cmdAnswer.indexOf(JOBSTATUS_INACTIVE) < 0 )
                throw new SchedulerException(
                    "Expected an inactive job, but received: " +
                    cmdAnswer);
            }
        }
        catch(SchedulerException scdEx) {
            addSchedulerTestMessage(
                getTestId(),
                TestProtocol.ERROR,
                "Scheduling error occurred...",
                scdEx);
        }
        finally {
            postTestCleanup();
        }
    }
}
