/*

 
  
    ========== licence begin  GPL
 Copyright (c) 2002-2004 SAP AG

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ========== licence end




 */
package com.sap.sapdb.guitest;

// standard package import
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.*;
import java.util.regex.Pattern;
import com.sap.sapdb.testframe.driver.*;
import com.sap.sapdb.testframe.testcase.*;

/**
 * <b>WinRunner test </b>
 * <p>
 * 
 * This tests starts winrunner with options
 * took from the WinRunner.par file.
 * 
 */
public class WinRunner extends TestCase
{
    /**
     * Call the superclass constructor
     */
    public WinRunner() throws SQLException, TestDatabaseException
    {
        super();
    }

    /**
     * Sets the timeout value in milliseconds. After the timeout is reached, the
     * test will be aborted by the test driver.
     * 
     * @return The default return value is 0, which means there is no timeout
     *         value set. Test will never be aborted by the test driver.
     */
    public static long getTimeout()
    {
        return 1000*60*30;
    }
    
    /**
     * returns the renamed WinRunner report file as string
     */
    public String getLogFile()
    {
        // read out the par file
        String report = getParameterString("ReportPath", "Initial");
        String newReportFilename = getParameterString("newReportFilename", "Initial");
        // check if the par file could be read
        if (report.equals("Initial"))
        {
            return null;
        }
        if (newReportFilename.equals("Initial"))
        {
            addMessage("WinRunner Test",'W',"Par file seems to be corrupt, no 'newReportFilename' found.");
        }

        
        // get fileobject for the old WinRunnerReportFile
        File oldWinRunnerReportFile = new File (report);
        
        // get the path
        File reportFilePath = oldWinRunnerReportFile.getParentFile();
       
        // set the new filename
        String reportnew = reportFilePath.toString()+ "\\" + newReportFilename;
        
        // get fileobject for the new WinRunnerReportFile        
        File newWinRunnerReportFile = new File(reportnew);
        
        // delete a existing renamed report file 
        if (newWinRunnerReportFile.exists())
        {
            newWinRunnerReportFile.delete();
        }
        
        // check if old report file exists
        if (oldWinRunnerReportFile.exists())
        {	
            // rename the report file
            boolean rename = oldWinRunnerReportFile.renameTo(newWinRunnerReportFile);
            if (rename == true)
            {
                // return the new report file name if renameto was successfull
                return reportnew;
            }
            else
            {
                // return the old report file name if renameto was not successfull
                return report;
            }
        }
        else
        {
            // return null if no report file can be found 
            return null;
        }
    }

    /**
     * psKill() kills programs that shouldn't run before a test starts
     * 
     * @throws IOException
     */
    private void psKill()
    {
        String tool = getParameterString("tool", "Initial");
        String psKillPath = getParameterString("psKillPath", "Initial");
        
        if ((psKillPath.equals("Initial")) || (tool.equals("Initial")))
        {          
            addMessage("WinRunner Test: psKill", 'W', "The psKillPath couldn't be found in the par file");
        }
        
        // find out which tool is tested
	    try
	    {    
	        // the wrun.exe should be destroyed by java but not the WinRunner RunEngine crvw.exe
	        Runtime.getRuntime().exec(psKillPath + "pskill.exe crvw.exe");
	        Runtime.getRuntime().exec(psKillPath + "pskill.exe wrun.exe");
	 
	        if (tool.equals("DBMGUI"))
	        {
	            Runtime.getRuntime().exec(psKillPath + "pskill.exe DBMGui3.exe");
		        Runtime.getRuntime().exec(psKillPath + "pskill.exe DBMWba3.exe");
		        Runtime.getRuntime().exec(psKillPath + "pskill.exe DBMWre3.exe");
		        Runtime.getRuntime().exec(psKillPath + "pskill.exe DBMWin3.exe");
		        Runtime.getRuntime().exec(psKillPath + "pskill.exe DBMWco3.exe");
		        Runtime.getRuntime().exec(psKillPath + "pskill.exe DBMWmn3.exe");
	        }
	        else
	            if (tool.equals("WEBDBM"))
	            {
	                Runtime.getRuntime().exec(psKillPath + "pskill.exe IEXPLORE.EXE");
	            }
	            else
	                if (tool.equals("WEBSQL"))
	                {
	                    Runtime.getRuntime().exec(psKillPath + "pskill.exe IEXPLORE.EXE");
	                }
	                else
	                    addMessage("WinRunner Test: psKill", 'W', "Couldn't find out whitch tool was testet");
	    }
	    catch (IOException e2)
	    {
	        addMessage("WinRunner Test: psKill", 'W', "psKill call(s) failed.");
	    }
    }
    
    /**
     * run() contains the test implementation
     * 
     * @throws IOException
     */
    public void run()
    {	
        // read out the par file
        String wrunArgs = getParameterString("WrunArgs", "Initial");
        String psKillPath = getParameterString("psKillPath", "Initial");
        String report = getParameterString("ReportPath", "Initial");
        String newReportFilename = getParameterString("newReportFilename", "Initial");
        
        // check if the par file could be read
        if ((wrunArgs.equals("Initial")) || (psKillPath.equals("Initial")) || (report.equals("Initial")) || (newReportFilename.equals("Initial")))
        {
            addMessage("WinRunner Test",'E', "Par file could not be read correctly.");
            return;
        }
        
        addMessage("WinRunner Test",'I',newReportFilename);
        
        Process winRunner = null;

        try
        {
        // kill all programs that shouldn't run
            psKill();

            Thread.sleep(3000);

            File deleteReportFile = new File(report);
            if (deleteReportFile.exists())
            {
                deleteReportFile.delete();
            }
            // start WinRunner         
            winRunner = Runtime.getRuntime().exec(wrunArgs);
            Thread.sleep(3000);
            // wait for WinRunner to exit
            winRunner.waitFor();        
            boolean failure = true;
            RandomAccessFile winRunnerReportFile = null;
            try
            {
                winRunnerReportFile = new RandomAccessFile(report, "r");
                String line = null;
                // check if a failure entry can be found -> failure
                while ((line = winRunnerReportFile.readLine()) != null)
                {
                    if (Pattern.matches("^Test Result:[ \t]*fail", line))
                    {
                        failure = true;
                        break;
                    }
                    else
                    {
                        failure = false;
                    }
                }
                // check if a OK entry can be found, if not -> failure
                if (failure == false)
                {
                    // set the file pointer to the beginning of the file
                    winRunnerReportFile.seek(0);
                    while ((line = winRunnerReportFile.readLine()) != null)
                    {
                        if (Pattern.matches("^Test Result:[ \t]*OK", line))
                        {
                            failure = false;
                            break;
                        }
                        else
                        {
                            failure = true;
                        }
                    }
                }               
                winRunnerReportFile.close();
            }
            catch (FileNotFoundException wrunFileNotFoundExeption)
            {               
                addMessage("WinRunner Test: Report File not Found", 'E', "The test seems to be failed." + wrunFileNotFoundExeption.getMessage());
                System.out.println("Exeption Message: " + wrunFileNotFoundExeption.getMessage());
                wrunFileNotFoundExeption.printStackTrace();
            }

            if (failure == true)
	        {
	            addMessage("WinRunner Test failed",'E', "The report file may contain details.");
	        }
	    }
        catch (InterruptedException wrunInterruptException)
        {   
            addMessage("WinRunner Timeout occurred ", 'E', "The test seems to be failed.");
            winRunner.destroy();
            psKill();
        }
        catch (IOException e)
        {
            e.printStackTrace();
        }
    } // run
}