/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.Server;
import com.sap.sdb.msgServer.agents.JmsThread;
import com.sap.sdb.msgServer.util.SendNotification;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.jms.JMSException;

public class SendingNotificationQueue {
    private boolean myVerbose = false;
    private LinkedList myMsgToBuild = new LinkedList();
    private LinkedList myMsgToSend = new LinkedList();
    private static final String MSG_TO_BUILD = "message to build";
    private static final String MSG_TO_SEND = "notification to send";

    public void setVerbose(boolean verbose) {
        this.myVerbose = verbose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendNotification getNotificationForBuilding() throws InterruptedException {
        LinkedList linkedList = this.myMsgToBuild;
        synchronized (linkedList) {
            while (this.myMsgToBuild.size() <= 0) {
                JmsThread.performWait(this.myMsgToBuild, 0L, MSG_TO_BUILD);
            }
            SendNotification notification = (SendNotification)this.myMsgToBuild.removeFirst();
            notification.setIsBuildMessage();
            return notification;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllNotificationsForConsumer(long consumerID) throws JMSException {
        LinkedList linkedList = this.myMsgToBuild;
        synchronized (linkedList) {
            LinkedList linkedList2 = this.myMsgToSend;
            synchronized (linkedList2) {
                for (int queue = 0; queue < 2; ++queue) {
                    LinkedList currQueue = queue == 0 ? this.myMsgToBuild : this.myMsgToSend;
                    ListIterator iter = currQueue.listIterator();
                    while (iter.hasNext()) {
                        SendNotification notification = (SendNotification)iter.next();
                        if (notification.getConsumerID() != consumerID) continue;
                        iter.remove();
                        if (!this.myVerbose) continue;
                        Server.log("Removed SendNotification messageID <" + notification.getMessageID() + ">, consumerID <" + notification.getConsumerID() + ">");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendNotification getFirstMsgReadyToSend() throws InterruptedException {
        LinkedList linkedList = this.myMsgToSend;
        synchronized (linkedList) {
            while (this.myMsgToSend.size() <= 0) {
                JmsThread.performWait(this.myMsgToSend, 0L, MSG_TO_SEND);
            }
            SendNotification notification = (SendNotification)this.myMsgToSend.removeFirst();
            notification.setIsSending();
            return notification;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessagesToSend() {
        LinkedList linkedList = this.myMsgToSend;
        synchronized (linkedList) {
            return this.myMsgToSend.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessagesToBuild() {
        LinkedList linkedList = this.myMsgToBuild;
        synchronized (linkedList) {
            return this.myMsgToBuild.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageToSend(SendNotification notification) {
        LinkedList linkedList = this.myMsgToSend;
        synchronized (linkedList) {
            notification.setIsInSendQueue();
            this.myMsgToSend.addLast(notification);
            this.myMsgToSend.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSendNotifications(SendNotification[] notifications, int count) {
        LinkedList linkedList = this.myMsgToBuild;
        synchronized (linkedList) {
            for (int i = 0; i < count; ++i) {
                this.myMsgToBuild.addLast(notifications[i]);
                this.myMsgToBuild.notify();
                if (this.myVerbose) {
                    Server.log("Add SendNotification messageID <" + notifications[i].getMessageID() + ">, consumerID <" + notifications[i].getConsumerID() + ">");
                }
                notifications[i] = null;
            }
        }
    }
}

