/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import java.io.IOException;

public class SendOrderKey {
    private long myMessageID;
    private long myConsumerID;
    private boolean myIsQueueMessage;

    public SendOrderKey(long messageID, long consumerID, boolean isQueueMessage) {
        this.myMessageID = messageID;
        this.myConsumerID = consumerID;
        this.myIsQueueMessage = isQueueMessage;
    }

    public long getMessageID() {
        return this.myMessageID;
    }

    public long getConsumerID() {
        return this.myConsumerID;
    }

    public boolean isQueueMessage() {
        return this.myIsQueueMessage;
    }

    public boolean equals(Object obj) {
        SendOrderKey other = (SendOrderKey)obj;
        return this.myMessageID == other.myMessageID && this.myConsumerID == other.myConsumerID && this.myIsQueueMessage == other.myIsQueueMessage;
    }

    public int hashCode() {
        return new Long(this.myMessageID).hashCode();
    }

    static SendOrderKey deserialize(ReceiveStream in) throws IOException {
        SendOrderKey key = new SendOrderKey(0L, 0L, false);
        key.myMessageID = in.readLong();
        key.myConsumerID = in.readLong();
        key.myIsQueueMessage = in.readBoolean();
        return key;
    }

    static int getSerializationLength() {
        return 17;
    }

    void serialize(SendStream out) throws IOException {
        out.writeLong(this.myMessageID);
        out.writeLong(this.myConsumerID);
        out.writeBoolean(this.myIsQueueMessage);
    }
}

