/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.util.MessageNotification;
import com.sap.sdb.msgServer.util.SendOrderKey;
import com.sap.sdb.msgServer.util.StreamString;

public class SendNotification {
    private long myMessageID;
    private long myConsumerID;
    private long myDestination;
    private long myTransSequence;
    private long myMsgSequence;
    private int myDeliveryMode;
    private int myPriority;
    private int myMessageState;
    private boolean myWasAlreadyDelivered;
    private boolean myIsQueueSendNotification;
    private MessageNotification myMessage;
    private StreamString myReceiverClientAddress;
    private StreamString myServerChannel;
    private SendOrderKey myKey;
    private static final int IN_BUILD_QUEUE = 0;
    private static final int USED_BY_MESSAGE_BUILDER = 1;
    private static final int READY_TO_SEND = 2;
    private static final int IN_SEND_QUEUE = 3;
    private static final int USED_BY_SOCKET_WRITER = 4;

    public SendNotification(long messageID, long consumerID, long destination, int modeDelivery, int priority, long transSequence, long msgSequence, boolean wasAlreadyDelivered, boolean isQueueSendNotification) {
        this.init(messageID, consumerID, destination, modeDelivery, priority, transSequence, msgSequence, wasAlreadyDelivered, isQueueSendNotification);
    }

    public void init(long messageID, long consumerID, long destination, int modeDelivery, int priority, long transSequence, long msgSequence, boolean wasAlreadyDelivered, boolean isQueueSendNotification) {
        this.myMessageID = messageID;
        this.myConsumerID = consumerID;
        this.myDestination = destination;
        this.myTransSequence = transSequence;
        this.myMsgSequence = msgSequence;
        this.myDeliveryMode = modeDelivery;
        this.myPriority = priority;
        this.myMessageState = 0;
        this.myWasAlreadyDelivered = wasAlreadyDelivered;
        this.myIsQueueSendNotification = isQueueSendNotification;
        this.myMessage = null;
        this.myReceiverClientAddress = null;
        this.myServerChannel = null;
        this.myKey = null;
    }

    public void clear() {
        this.myMessageID = 0L;
        this.myConsumerID = 0L;
        this.myDestination = 0L;
        this.myMessage = null;
    }

    public long getConsumerID() {
        return this.myConsumerID;
    }

    public void setConsumerID(long consumerID) {
        this.myConsumerID = consumerID;
    }

    public long getDestinationID() {
        return this.myDestination;
    }

    public int getDeliveryMode() {
        return this.myDeliveryMode;
    }

    public boolean getIsQueueSendNotification() {
        return this.myIsQueueSendNotification;
    }

    public SendOrderKey getKey() {
        return this.myKey;
    }

    public MessageNotification getMessage() {
        return this.myMessage;
    }

    public long getMessageID() {
        return this.myMessageID;
    }

    public long getMsgSequence() {
        return this.myMsgSequence;
    }

    public int getPriority() {
        return this.myPriority;
    }

    public long getTransSequence() {
        return this.myTransSequence;
    }

    public boolean getWasAlreadyDelivered() {
        return this.myWasAlreadyDelivered;
    }

    public boolean isBuildMessage() {
        return this.myMessageState == 1;
    }

    public boolean isInSendQueue() {
        return this.myMessageState == 3;
    }

    public boolean isReadyToSend() {
        return this.myMessageState == 2;
    }

    public boolean isSending() {
        return this.myMessageState == 4;
    }

    public void setReceiverClientAddress(StreamString receiverClientAddress) {
        this.myReceiverClientAddress = receiverClientAddress;
        this.myServerChannel = this.getServerChannelFromClientAdress(receiverClientAddress);
    }

    public StreamString getReceiverClientAddress() {
        return this.myReceiverClientAddress;
    }

    public StreamString getServerChannel() {
        return this.myServerChannel;
    }

    private StreamString getServerChannelFromClientAdress(StreamString receiverClientAddress) {
        if (receiverClientAddress == null) {
            return null;
        }
        String channel = this.myReceiverClientAddress.getString();
        channel = channel.substring(0, channel.indexOf("/"));
        return new StreamString(channel);
    }

    public void setMessage(MessageNotification message) {
        this.myMessage = message;
    }

    public void setIsBuildMessage() {
        this.myMessageState = 1;
    }

    public void setIsInSendQueue() {
        this.myMessageState = 3;
    }

    public void setIsReadyToSend() {
        this.myMessageState = 2;
    }

    public void setIsSending() {
        this.myMessageState = 4;
    }
}

