/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.util.SendReceiveStreamConstants;
import com.sap.sdb.msgServer.util.StreamString;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import java.util.Hashtable;
import java.util.Vector;

public class ReceiveStream
extends DataInputStream
implements SendReceiveStreamConstants {
    public ReceiveStream(InputStream in) throws IOException {
        super(in);
    }

    public ReceiveStream(InputStream in, int bufSize) throws IOException {
        super(new BufferedInputStream(in, bufSize));
    }

    public boolean isNullObject() throws IOException {
        return this.readByte() == 0;
    }

    public byte[] readByteArray() throws IOException {
        int length = this.readInt();
        if (length == -1) {
            return null;
        }
        byte[] byteArray = new byte[length];
        this.readFully(byteArray, 0, length);
        return byteArray;
    }

    public Vector readVector() throws IOException {
        int elementCount = this.readInt();
        Vector<Object> vectab = elementCount > 0 ? new Vector<Object>(elementCount) : null;
        for (int i = 0; i < elementCount; ++i) {
            Object data = this.readSpecialObject();
            vectab.add(i, data);
        }
        return vectab;
    }

    public Hashtable readHashtable() throws IOException {
        int elementCount = this.readInt();
        Hashtable<Object, Object> hashtab = elementCount > 0 ? new Hashtable<Object, Object>(elementCount) : null;
        for (int i = 0; i < elementCount; ++i) {
            Object key = this.readSpecialObject();
            Object data = this.readSpecialObject();
            if (key == null) continue;
            hashtab.put(key, data);
        }
        return hashtab;
    }

    public Integer readInteger() throws IOException {
        byte intType = this.readByte();
        if (intType == 0) {
            return null;
        }
        if (intType != 7) {
            throw new IOException("invalid integer format");
        }
        return new Integer(this.readInt());
    }

    public Object readSerializableObject() throws IOException {
        byte objectType = this.readByte();
        if (objectType == 0) {
            return null;
        }
        if (objectType != 1) {
            throw new IOException("invalid object format");
        }
        try {
            byte[] byteArray = this.readByteArray();
            ByteArrayInputStream byteStream = new ByteArrayInputStream(byteArray);
            ObjectInputStream objStream = new ObjectInputStream(byteStream);
            Object obj = objStream.readObject();
            objStream.close();
            return obj;
        }
        catch (ClassNotFoundException ex) {
            throw new IOException(ex.toString());
        }
    }

    public Object readSpecialObject() throws IOException {
        byte objectType = this.readByte();
        switch (objectType) {
            case 0: {
                return null;
            }
            case 2: {
                return new Boolean(this.readBoolean());
            }
            case 3: {
                return new Byte(this.readByte());
            }
            case 5: {
                return new Double(this.readDouble());
            }
            case 6: {
                return new Float(this.readFloat());
            }
            case 7: {
                return new Integer(this.readInt());
            }
            case 8: {
                return new Long(this.readLong());
            }
            case 9: {
                return new Short(this.readShort());
            }
            case 4: {
                return new Character(this.readChar());
            }
            case 11: {
                return this.readByteArray();
            }
            case 10: {
                return this.readUTF();
            }
        }
        throw new StreamCorruptedException("unknown object: " + objectType);
    }

    public StreamString readStreamString() throws IOException {
        byte stringType = this.readByte();
        switch (stringType) {
            case 0: {
                return null;
            }
            case 10: {
                return new StreamString(this.readUTF());
            }
            case 12: {
                return new StreamString(this.readUTFByteArray());
            }
        }
        throw new IOException("invalid StreamString format");
    }

    public String readString() throws IOException {
        byte stringType = this.readByte();
        switch (stringType) {
            case 0: {
                return null;
            }
            case 10: 
            case 12: {
                return this.readUTF();
            }
        }
        throw new IOException("invalid String format");
    }

    private byte[] readUTFByteArray() throws IOException {
        int length = this.readUnsignedShort();
        byte[] byteArray = new byte[2 + length];
        this.readFully(byteArray, 2, length);
        byteArray[0] = (byte)(length >>> 8 & 0xFF);
        byteArray[1] = (byte)(length >>> 0 & 0xFF);
        return byteArray;
    }
}

