/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.util;

import com.sap.sdb.msgServer.util.Notification;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import com.sap.sdb.msgServer.util.StreamString;
import java.io.IOException;

public class BrowserNotification
extends Notification {
    private StreamString _destName;
    private long _lastMessageID;
    private long _id;
    public static final int QUEUE_BROWSER_NOTIFICATION = 0;
    public static final int TOPIC_BROWSER_NOTIFICATION = 1;

    BrowserNotification() {
        this._destName = null;
        this._lastMessageID = 0L;
        this._id = 0L;
    }

    public BrowserNotification(String destName, long lastMessageID, long id, int type) {
        super(type, "rec");
        this._destName = StreamString.create(destName);
        this._lastMessageID = lastMessageID;
        this._id = id;
    }

    public String getDestName() {
        return StreamString.getString(this._destName);
    }

    public long getLastMessageID() {
        return this._lastMessageID;
    }

    public long getID() {
        return this._id;
    }

    public String toString() {
        return "QueueBrowserNotification: " + super.toString();
    }

    void readFromStream(ReceiveStream in) throws IOException {
        super.deserialize(in);
        this._destName = in.readStreamString();
        this._lastMessageID = in.readLong();
        this._id = in.readLong();
    }

    void writeToStream(SendStream out) throws IOException {
        super.serialize(out, 15, SendStream.getStreamStringLength(this._destName) + 16);
        out.writeStreamString(this._destName);
        out.writeLong(this._lastMessageID);
        out.writeLong(this._id);
    }
}

