/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.msgselector.parsing;

import com.sap.sdb.msgServer.msgselector.parsing.AbstractOperator;
import com.sap.sdb.msgServer.msgselector.parsing.Token;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.And;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.Attribute;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.Between;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.BooleanFalseLiteral;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.BooleanTrueLiteral;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.Div;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.Equal;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.In;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.IsNotNull;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.IsNull;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.Less;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.LessEqual;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.Like;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.LikeEscape;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.Minus;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.More;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.MoreEqual;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.Mult;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.Not;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.NotBetween;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.NotEqual;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.NotIn;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.NotLike;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.NotLikeEscape;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.NullLiteral;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.Or;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.Plus;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.UnaryMinus;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.UnaryPlus;
import java.util.Hashtable;

public class OperatorRepository {
    private static OperatorRepository s_instance = null;
    private Hashtable m_hashOperators = new Hashtable();

    public static OperatorRepository getInstance() {
        if (s_instance == null) {
            s_instance = new OperatorRepository();
        }
        return s_instance;
    }

    private OperatorRepository() {
        this.addBuiltinOperators();
    }

    private void addBuiltinOperators() {
        this.addOperator(new BooleanFalseLiteral());
        this.addOperator(new BooleanTrueLiteral());
        this.addOperator(new And());
        this.addOperator(new Or());
        this.addOperator(new Equal());
        this.addOperator(new Not());
        this.addOperator(new NullLiteral());
        this.addOperator(new UnaryPlus());
        this.addOperator(new UnaryMinus());
        this.addOperator(new Plus());
        this.addOperator(new Minus());
        this.addOperator(new Mult());
        this.addOperator(new Div());
        this.addOperator(new Less());
        this.addOperator(new LessEqual());
        this.addOperator(new More());
        this.addOperator(new MoreEqual());
        this.addOperator(new NotEqual());
        this.addOperator(new IsNotNull());
        this.addOperator(new IsNull());
        this.addOperator(new Like());
        this.addOperator(new NotLike());
        this.addOperator(new LikeEscape());
        this.addOperator(new NotLikeEscape());
        this.addOperator(new In());
        this.addOperator(new NotIn());
        this.addOperator(new Between());
        this.addOperator(new NotBetween());
    }

    private void addOperator(AbstractOperator op) {
        String opWord = op.getOperatorInfo().getNormalizedWord();
        if (this.m_hashOperators.containsKey(opWord)) {
            throw new IllegalArgumentException("Operator '" + opWord + "' is already defined");
        }
        this.m_hashOperators.put(opWord, op);
    }

    public static AbstractOperator getOperator(Token t) {
        return OperatorRepository.getOperator(t.getWord());
    }

    public static AbstractOperator getOperator(String opWord) {
        AbstractOperator op = null;
        if (OperatorRepository.getInstance().m_hashOperators.containsKey(opWord)) {
            op = (AbstractOperator)OperatorRepository.getInstance().m_hashOperators.get(opWord);
            return op;
        }
        if (OperatorRepository.getInstance().m_hashOperators.containsKey(opWord.toUpperCase()) && !(op = (AbstractOperator)OperatorRepository.getInstance().m_hashOperators.get(opWord.toUpperCase())).getOperatorInfo().isCaseSensitive()) {
            return op;
        }
        return new Attribute(opWord);
    }
}

