/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.msgselector.parsing;

import com.sap.sdb.msgServer.msgselector.parsing.AbstractOperator;
import com.sap.sdb.msgServer.msgselector.parsing.AbstractTreeNode;
import com.sap.sdb.msgServer.msgselector.parsing.LanguageDefinition;
import com.sap.sdb.msgServer.msgselector.parsing.OperatorInfo;
import com.sap.sdb.msgServer.msgselector.parsing.OperatorRepository;
import com.sap.sdb.msgServer.msgselector.parsing.Token;
import com.sap.sdb.msgServer.msgselector.parsing.TokenException;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.Between;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.DoubleLiteral;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.GeneralBetweenOperatorTreeNode;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.GeneralInOperatorTreeNode;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.GeneralLikeEscapeOperatorTreeNode;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.In;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.LikeEscape;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.LongLiteral;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.NotBetween;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.NotIn;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.NotLikeEscape;
import com.sap.sdb.msgServer.msgselector.parsing.builtinoperators.StringLiteral;
import java.util.Stack;
import java.util.Vector;

public class ExpressionTreeBuilder
implements LanguageDefinition {
    private ExpressionTreeBuilder() {
    }

    public static AbstractTreeNode buildExpressionTree(Vector vecTokens) throws ExpressionTreeBuildingException {
        ExpressionTreeBuilder.checkBracing(vecTokens);
        return ExpressionTreeBuilder.buildSubTree(vecTokens);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AbstractTreeNode buildSubTree(Vector vecTokens) {
        int len = vecTokens.size();
        if (len > 1) {
            Token esctoken;
            int level = 0;
            int minBinding = -1;
            int minBindingIndex = -1;
            int minBindingSpan = 0;
            AbstractOperator opMinBinding = null;
            boolean reachedBottomLevel = false;
            boolean lookBehindIsROperator = true;
            Vector in_operator_arglist = null;
            Vector between_operator_op2 = null;
            block15: for (int i = 0; i < len; ++i) {
                int span = 0;
                Token t = (Token)vecTokens.elementAt(i);
                reachedBottomLevel = reachedBottomLevel || level == 0 && i > 0;
                switch (t.getType()) {
                    case 2049: {
                        --level;
                        continue block15;
                    }
                    case 2050: {
                        if (++level != 0) continue block15;
                        lookBehindIsROperator = false;
                        continue block15;
                    }
                    default: {
                        if (level == 0) {
                            if (t.isWord()) {
                                AbstractOperator op;
                                try {
                                    Token tla;
                                    String opWord = t.getWord();
                                    if ((opWord.equals("+") || opWord.equals("-")) && lookBehindIsROperator) {
                                        op = OperatorRepository.getOperator(opWord + "unary");
                                    } else if (opWord.equalsIgnoreCase("is")) {
                                        if (i + 1 >= len) throw new ExpressionTreeBuildingException(t, "Incomplete 'IS (NOT) NULL' operator.");
                                        tla = (Token)vecTokens.elementAt(i + 1);
                                        if (tla.isWord() && tla.getWord().equalsIgnoreCase("null")) {
                                            op = OperatorRepository.getOperator("*isnull");
                                            span = 1;
                                        } else {
                                            if (!tla.isWord()) throw new ExpressionTreeBuildingException(t, "Incomplete 'IS (NOT) NULL' operator.");
                                            if (!tla.getWord().equalsIgnoreCase("not")) throw new ExpressionTreeBuildingException(t, "Incomplete 'IS (NOT) NULL' operator.");
                                            if (i + 2 >= len) throw new ExpressionTreeBuildingException(t, "Incomplete 'IS NOT NULL' operator.");
                                            Token tla2 = (Token)vecTokens.elementAt(i + 2);
                                            if (!tla2.isWord()) throw new ExpressionTreeBuildingException(t, "Incomplete 'IS NOT NULL' operator.");
                                            if (!tla2.getWord().equalsIgnoreCase("null")) throw new ExpressionTreeBuildingException(t, "Incomplete 'IS NOT NULL' operator.");
                                            op = OperatorRepository.getOperator("*isnotnull");
                                            span = 2;
                                        }
                                    } else if (opWord.equalsIgnoreCase("not") && i + 1 < len) {
                                        tla = (Token)vecTokens.elementAt(i + 1);
                                        if (tla.isWord() && tla.getWord().equalsIgnoreCase("like")) {
                                            if (i + 3 < len && ((Token)vecTokens.elementAt(i + 3)).getWord().equalsIgnoreCase("escape")) {
                                                op = OperatorRepository.getOperator("*notlikeescape");
                                                span = 3;
                                            } else {
                                                op = OperatorRepository.getOperator("*notlike");
                                                span = 1;
                                            }
                                        } else if (tla.isWord() && tla.getWord().equalsIgnoreCase("in")) {
                                            in_operator_arglist = new Vector();
                                            span = 1 + ExpressionTreeBuilder.processInOperator(i + 1, len, vecTokens, t, in_operator_arglist);
                                            op = OperatorRepository.getOperator("*notin");
                                        } else if (tla.isWord() && tla.getWord().equalsIgnoreCase("between")) {
                                            between_operator_op2 = new Vector();
                                            span = 1 + ExpressionTreeBuilder.processBetweenOperator(i + 1, len, vecTokens, t, between_operator_op2);
                                            op = OperatorRepository.getOperator("*notbetween");
                                        } else {
                                            op = OperatorRepository.getOperator(opWord);
                                        }
                                    } else if (opWord.equalsIgnoreCase("like") && i + 2 < len && ((Token)vecTokens.elementAt(i + 2)).getWord().equalsIgnoreCase("escape")) {
                                        op = OperatorRepository.getOperator("*likeescape");
                                        span = 2;
                                    } else if (opWord.equalsIgnoreCase("in")) {
                                        in_operator_arglist = new Vector();
                                        span = ExpressionTreeBuilder.processInOperator(i, len, vecTokens, t, in_operator_arglist);
                                        op = OperatorRepository.getOperator("in");
                                    } else if (opWord.equalsIgnoreCase("between")) {
                                        between_operator_op2 = new Vector();
                                        span = ExpressionTreeBuilder.processBetweenOperator(i, len, vecTokens, t, between_operator_op2);
                                        op = OperatorRepository.getOperator("between");
                                    } else {
                                        if (opWord.equalsIgnoreCase("escape")) {
                                            throw new ExpressionTreeBuildingException(t, "'ESCAPE' keyword without 'LIKE' operator.");
                                        }
                                        op = OperatorRepository.getOperator(opWord);
                                    }
                                    lookBehindIsROperator = op.getOperatorInfo().getRightArgumentCount() > 0;
                                }
                                catch (IllegalArgumentException ex) {
                                    throw new ExpressionTreeBuildingException(t, ex.getMessage());
                                }
                                if (op.getOperatorInfo().getBindingForce() >= minBinding && (opMinBinding == null || op.getOperatorInfo().getLeftArgumentCount() > 0)) {
                                    minBinding = op.getOperatorInfo().getBindingForce();
                                    opMinBinding = op;
                                    minBindingIndex = i;
                                    minBindingSpan = span;
                                }
                            } else {
                                lookBehindIsROperator = false;
                            }
                        }
                        reachedBottomLevel = reachedBottomLevel || level == 0 && (i += span) > 0;
                    }
                }
            }
            if (!reachedBottomLevel) {
                return ExpressionTreeBuilder.buildSubTree(new Vector(vecTokens.subList(1, vecTokens.size() - 1)));
            }
            if (opMinBinding == null) throw new ExpressionTreeBuildingException((Token)vecTokens.elementAt(0), "Illegal expression: no operator on top level");
            AbstractTreeNode t = opMinBinding.getTreeNodeInstance((Token)vecTokens.elementAt(minBindingIndex));
            if (opMinBinding instanceof In || opMinBinding instanceof NotIn) {
                ((GeneralInOperatorTreeNode)t).setInList(in_operator_arglist);
            }
            if (opMinBinding instanceof Between || opMinBinding instanceof NotBetween) {
                AbstractTreeNode Op2 = ExpressionTreeBuilder.buildExpressionTree(between_operator_op2);
                ((GeneralBetweenOperatorTreeNode)t).setOp2(Op2);
            }
            if (opMinBinding instanceof LikeEscape) {
                Token patterntoken = (Token)vecTokens.elementAt(minBindingIndex + 1);
                if (patterntoken.getType() != 8194) throw new ExpressionTreeBuildingException(patterntoken, "'LIKE ESCAPE' pattern not a string literal.");
                if (minBindingIndex + 3 < len) {
                    esctoken = (Token)vecTokens.elementAt(minBindingIndex + 3);
                    if (esctoken.getType() != 8194) throw new ExpressionTreeBuildingException(patterntoken, "'LIKE ESCAPE' escape operand not a string literal of length 1.");
                    if (esctoken.getWord().length() != 1) throw new ExpressionTreeBuildingException(patterntoken, "'LIKE ESCAPE' escape operand not a string literal of length 1.");
                    ((GeneralLikeEscapeOperatorTreeNode)t).setPattern(new StringLiteral(patterntoken));
                }
            }
            if (opMinBinding instanceof NotLikeEscape) {
                Token patterntoken = (Token)vecTokens.elementAt(minBindingIndex + 2);
                if (patterntoken.getType() != 8194) throw new ExpressionTreeBuildingException(patterntoken, "'NOT LIKE ESCAPE' pattern not a string literal.");
                if (minBindingIndex + 4 < len) {
                    esctoken = (Token)vecTokens.elementAt(minBindingIndex + 4);
                    if (esctoken.getType() != 8194) throw new ExpressionTreeBuildingException(patterntoken, "'NOT LIKE ESCAPE' escape operand not a string literal of length 1.");
                    if (esctoken.getWord().length() != 1) throw new ExpressionTreeBuildingException(patterntoken, "'NOT LIKE ESCAPE' escape operand not a string literal of length 1.");
                    ((GeneralLikeEscapeOperatorTreeNode)t).setPattern(new StringLiteral(patterntoken));
                }
            }
            Vector leftPart = new Vector(vecTokens.subList(0, minBindingIndex));
            int leftArgCount = opMinBinding.getOperatorInfo().getLeftArgumentCount();
            if (leftArgCount > 0) {
                try {
                    t.addChildren(ExpressionTreeBuilder.getArguments(leftPart, leftArgCount));
                }
                catch (IllegalArgumentException iex) {
                    throw new ExpressionTreeBuildingException(t.getToken(), "Missing left argument(s).");
                }
            } else if (leftPart.size() > 0) {
                throw new ExpressionTreeBuildingException(t.getToken(), "Extra tokens. Expecting no left arguments");
            }
            Vector rightPart = new Vector(vecTokens.subList(minBindingIndex + 1 + minBindingSpan, vecTokens.size()));
            int rightArgCount = opMinBinding.getOperatorInfo().getRightArgumentCount();
            if (rightArgCount > 0) {
                try {
                    t.addChildren(ExpressionTreeBuilder.getArguments(rightPart, rightArgCount));
                    return t;
                }
                catch (IllegalArgumentException iex) {
                    throw new ExpressionTreeBuildingException(t.getToken(), "Missing right argument(s).");
                }
            } else {
                if (rightPart.size() <= 0) return t;
                throw new ExpressionTreeBuildingException(t.getToken(), "Extra tokens. Expecting no right arguments");
            }
        }
        if (len != 1) throw new ExpressionTreeBuildingException("Empty token set!");
        Token t = (Token)vecTokens.elementAt(0);
        switch (t.getType()) {
            case 8195: {
                return new DoubleLiteral(t);
            }
            case 8197: {
                return new LongLiteral(t);
            }
            case 8194: {
                return new StringLiteral(t);
            }
        }
        if (!t.isWord()) throw new ExpressionTreeBuildingException(t, "Unexpected token");
        if (t.getWord().equalsIgnoreCase("is")) {
            throw new ExpressionTreeBuildingException(t, "Incomplete 'IS (NOT) NULL' operator.");
        }
        if (t.getWord().equalsIgnoreCase("escape")) {
            throw new ExpressionTreeBuildingException(t, "'ESCAPE' keyword without like operator.");
        }
        AbstractOperator op = OperatorRepository.getOperator(t);
        OperatorInfo opInfo = op.getOperatorInfo();
        if (opInfo.getLeftArgumentCount() != 0) throw new ExpressionTreeBuildingException(t, "Expecting operator with no arguments");
        if (opInfo.getRightArgumentCount() != 0) throw new ExpressionTreeBuildingException(t, "Expecting operator with no arguments");
        return op.getTreeNodeInstance(t);
    }

    private static int processInOperator(int i, int len, Vector vecTokens, Token t, Vector in_operator_arglist) {
        if (i + 1 < len && ((Token)vecTokens.elementAt(i + 1)).getType() == 2049) {
            Token t2;
            int j;
            boolean comma = false;
            for (j = i + 2; j < len && (t2 = (Token)vecTokens.elementAt(j)).getType() != 2050; ++j) {
                if (comma) {
                    if (t2.getType() != 2051) {
                        throw new ExpressionTreeBuildingException(t2, "Comma expected in operand list for 'IN' operator.");
                    }
                } else {
                    if (t2.getType() != 8194) {
                        throw new ExpressionTreeBuildingException((Token)vecTokens.elementAt(j), "'IN' operator : string literal expected.");
                    }
                    in_operator_arglist.add(t2.getWord());
                }
                comma = !comma;
            }
            if (j >= len) {
                throw new ExpressionTreeBuildingException(t, "Incomplete operand list for 'IN' operator : missing ')' .");
            }
            if (!comma && j != i + 2) {
                throw new ExpressionTreeBuildingException(t, "'IN' operator : trailing comma in operand list.");
            }
            return j - i;
        }
        throw new ExpressionTreeBuildingException(t, "Incomplete 'IN' operator : operand list missing.");
    }

    private static int processBetweenOperator(int i, int len, Vector vecTokens, Token t, Vector between_operator_op2) {
        int j;
        Token tla = null;
        for (j = i + 1; j < len && !(tla = (Token)vecTokens.elementAt(j)).getWord().equalsIgnoreCase("and"); ++j) {
            between_operator_op2.add(tla);
        }
        if (j >= len) {
            throw new ExpressionTreeBuildingException(t, "missing keyword 'AND' for 'BETWEEN' operator.");
        }
        return j - i;
    }

    private static Vector getArguments(Vector v, int n) {
        Vector<AbstractTreeNode> r = new Vector<AbstractTreeNode>();
        if (n > 0) {
            int level = 0;
            boolean reachedBottomLevel = false;
            int argStart = 0;
            boolean inArg = true;
            block5: for (int i = 0; i < v.size(); ++i) {
                Token t = (Token)v.elementAt(i);
                switch (t.getType()) {
                    case 2049: {
                        --level;
                        continue block5;
                    }
                    case 2050: {
                        ++level;
                        continue block5;
                    }
                    case 2051: {
                        if (level != 0) continue block5;
                        reachedBottomLevel = true;
                        if (inArg) {
                            if (r.size() + 1 < n) {
                                r.add(ExpressionTreeBuilder.buildSubTree(new Vector(v.subList(argStart, i))));
                                inArg = false;
                                continue block5;
                            }
                            throw new ExpressionTreeBuildingException(t, "Illegal comma, expecting no further than " + n + " arguments, got " + r.size());
                        }
                        throw new ExpressionTreeBuildingException(t, "Expecting argument");
                    }
                    default: {
                        if (level != 0) continue block5;
                        reachedBottomLevel = true;
                        if (inArg) continue block5;
                        inArg = true;
                        argStart = i;
                    }
                }
            }
            if (reachedBottomLevel) {
                if (inArg) {
                    r.add(ExpressionTreeBuilder.buildSubTree(new Vector(v.subList(argStart, v.size()))));
                }
            } else {
                return ExpressionTreeBuilder.getArguments(new Vector(v.subList(1, v.size() - 1)), n);
            }
            if (r.size() != n) {
                throw new ExpressionTreeBuildingException("Expecting " + n + " arguments, got " + r.size());
            }
        }
        return r;
    }

    private static void checkBracing(Vector vecTokens) throws ExpressionTreeBuildingException {
        Stack<Token> stack = new Stack<Token>();
        for (int i = 0; i < vecTokens.size(); ++i) {
            Token t = (Token)vecTokens.elementAt(i);
            if (t.getType() == 2049) {
                stack.push(t);
                continue;
            }
            if (t.getType() != 2050) continue;
            if (stack.size() > 0) {
                stack.pop();
                continue;
            }
            throw new ExpressionTreeBuildingException(t, "Additional closing bracket");
        }
        if (stack.size() > 0) {
            throw new ExpressionTreeBuildingException((Token)stack.pop(), "This bracket remains unclosed");
        }
    }

    public static class ExpressionTreeBuildingException
    extends TokenException {
        public ExpressionTreeBuildingException(String msg) {
            super(msg, 0);
        }

        public ExpressionTreeBuildingException(Token t, String msg) {
            super(msg, t.getPositionOfToken());
        }
    }
}

