/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.client;

import com.sap.sdb.msgServer.client.MessageImpl;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;

public class BytesMessageImpl
extends MessageImpl
implements BytesMessage {
    private transient ByteArrayOutputStream myWriteByteStream = null;
    private transient DataOutputStream myWriteStream = null;
    private transient DataInputStream myReadStream = null;
    private byte[] myData = null;

    public BytesMessageImpl() {
        super(1);
    }

    public BytesMessageImpl(long messageID, boolean isQueueMessage) {
        super(messageID, isQueueMessage, 1);
        this.setWriteOnly();
        this.createNewWriteStream();
    }

    public void clearBody() throws JMSException {
        this.setWriteOnly();
        try {
            if (this.myReadStream != null) {
                this.myReadStream.close();
            }
            if (this.myWriteStream != null) {
                this.myWriteStream.close();
            }
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
        this.myData = null;
        this.myReadStream = null;
        this.myWriteByteStream = null;
        this.myWriteStream = null;
        this.createNewWriteStream();
    }

    public boolean readBoolean() throws JMSException {
        this.checkForRead();
        boolean data = false;
        try {
            data = this.myReadStream.readBoolean();
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
        return data;
    }

    public int readBytes(byte[] value) throws JMSException {
        this.checkForRead();
        return this.readBytes(value, value.length);
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        this.checkForRead();
        if (length < 0 || length > value.length) {
            throw new JMSException("Must be greater 0 and less than or equal to value.length");
        }
        try {
            int bytesLeft = this.myReadStream.available();
            if (bytesLeft == 0) {
                return -1;
            }
            if (value.length <= bytesLeft) {
                this.myReadStream.readFully(value, 0, length);
                return length;
            }
            this.myReadStream.readFully(value, 0, Math.min(length, bytesLeft));
            return Math.min(length, bytesLeft);
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
    }

    public byte readByte() throws JMSException {
        this.checkForRead();
        byte data = 0;
        try {
            data = this.myReadStream.readByte();
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
        return data;
    }

    public char readChar() throws JMSException {
        this.checkForRead();
        char data = '\u0000';
        try {
            data = this.myReadStream.readChar();
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
        return data;
    }

    public float readFloat() throws JMSException {
        this.checkForRead();
        float data = 0.0f;
        try {
            data = this.myReadStream.readFloat();
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
        return data;
    }

    public double readDouble() throws JMSException {
        this.checkForRead();
        double data = 0.0;
        try {
            data = this.myReadStream.readDouble();
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
        return data;
    }

    public int readInt() throws JMSException {
        this.checkForRead();
        int data = 0;
        try {
            data = this.myReadStream.readInt();
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
        return data;
    }

    public long readLong() throws JMSException {
        this.checkForRead();
        long data = 0L;
        try {
            data = this.myReadStream.readLong();
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
        return data;
    }

    public short readShort() throws JMSException {
        this.checkForRead();
        short data = 0;
        try {
            data = this.myReadStream.readShort();
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
        return data;
    }

    public String readUTF() throws JMSException {
        this.checkForRead();
        String data = "";
        try {
            data = this.myReadStream.readUTF();
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
        return data;
    }

    public int readUnsignedByte() throws JMSException {
        this.checkForRead();
        int data = 0;
        try {
            data = this.myReadStream.readUnsignedByte();
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
        return data;
    }

    public int readUnsignedShort() throws JMSException {
        this.checkForRead();
        short data = 0;
        try {
            data = this.myReadStream.readShort();
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
        return data;
    }

    public void reset() throws JMSException {
        this.setReadOnly();
        try {
            if (this.myReadStream != null) {
                this.myReadStream.reset();
                return;
            }
            if (this.myWriteStream != null) {
                this.myData = this.myWriteByteStream.toByteArray();
                this.myWriteStream.close();
                this.myWriteByteStream = null;
                this.myWriteStream = null;
            }
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
        if (this.myData == null) {
            this.myData = new byte[0];
        }
        ByteArrayInputStream readByteStream = new ByteArrayInputStream(this.myData);
        this.myReadStream = new DataInputStream(readByteStream);
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.checkForWrite();
        try {
            this.myWriteStream.writeBoolean(value);
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.checkForWrite();
        try {
            this.myWriteStream.writeByte(value);
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.checkForWrite();
        try {
            this.myWriteStream.write(value);
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.checkForWrite();
        if (value.length < offset + length) {
            throw new JMSException("byte[] buffer: offset or length invalid");
        }
        try {
            this.myWriteStream.write(value, offset, length);
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
    }

    public void writeChar(char value) throws JMSException {
        this.checkForWrite();
        try {
            this.myWriteStream.writeChar(value);
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
    }

    public void writeDouble(double value) throws JMSException {
        this.checkForWrite();
        try {
            this.myWriteStream.writeDouble(value);
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
    }

    public void writeFloat(float value) throws JMSException {
        this.checkForWrite();
        try {
            this.myWriteStream.writeFloat(value);
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
    }

    public void writeInt(int value) throws JMSException {
        this.checkForWrite();
        try {
            this.myWriteStream.writeInt(value);
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
    }

    public void writeLong(long value) throws JMSException {
        this.checkForWrite();
        try {
            this.myWriteStream.writeLong(value);
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
    }

    public void writeObject(Object value) throws JMSException {
        this.checkForWrite();
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else if (value instanceof String) {
            this.writeUTF((String)value);
        } else {
            if (value == null) {
                throw new JMSException("Can't write null value");
            }
            throw new MessageFormatException("Can't write " + value.getClass().getName() + " object");
        }
    }

    public void writeShort(short value) throws JMSException {
        this.checkForWrite();
        try {
            this.myWriteStream.writeShort(value);
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
    }

    public void writeUTF(String value) throws JMSException {
        this.checkForWrite();
        try {
            this.myWriteStream.writeUTF(value);
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
    }

    private void createNewWriteStream() {
        this.myWriteByteStream = new ByteArrayOutputStream();
        this.myWriteStream = new DataOutputStream(this.myWriteByteStream);
    }

    public void prepareForClient() throws JMSException {
        super.prepareForClient();
        this.reset();
    }

    void readMessageContentsFromStream(ReceiveStream in) throws IOException {
        this.myData = in.readByteArray();
    }

    void writeMessageContentsToStream(SendStream out) throws IOException {
        this.myData = this.myWriteByteStream.toByteArray();
        out.writeByteArray(this.myData);
    }

    public long getBodyLength() throws JMSException {
        if (this.myData != null) {
            return this.myData.length;
        }
        if (this.myWriteByteStream != null) {
            return this.myWriteByteStream.size();
        }
        return 0L;
    }
}

