/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.agents;

import com.sap.sdb.msgServer.Server;
import com.sap.sdb.msgServer.agents.ReceivingException;
import com.sap.sdb.msgServer.service.JmsService;
import com.sap.sdb.msgServer.service.ServiceException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;

public abstract class JmsThread
extends Thread {
    private static int mThreadCount = 0;
    private JmsService mService;
    private boolean mStopFlag = false;
    private long mWaitCount = 0L;
    private String mAction = null;
    private String mSQLAction = "";
    private long mNotificationCount = 0L;
    static final String LINE_SEP = System.getProperty("line.separator");
    private static HashMap s_temporaryThreadList = new HashMap();

    public JmsThread(JmsService service, String name) throws ServiceException {
        super(service.getThreadGroup(), name + "-" + mThreadCount++);
        if (service == null) {
            throw new ServiceException("???", "JmsThread constructor failed due to null service parameter");
        }
        if (name == null) {
            throw new ServiceException(service, "JmsThread constructor failed due to null name parameter");
        }
        this.mService = service;
    }

    public JmsThread(String name) {
        super(name);
        this.mService = null;
    }

    public JmsThread(ThreadGroup group, String name) {
        super(group, name);
        this.mService = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JmsThread[] getTemporaryThreads() {
        HashMap hashMap = s_temporaryThreadList;
        synchronized (hashMap) {
            JmsThread[] list = new JmsThread[s_temporaryThreadList.size()];
            int i = 0;
            Iterator iter = s_temporaryThreadList.keySet().iterator();
            while (iter.hasNext()) {
                list[i] = (JmsThread)iter.next();
                ++i;
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerThisThread() {
        HashMap hashMap = s_temporaryThreadList;
        synchronized (hashMap) {
            s_temporaryThreadList.put(this, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterThisThread() {
        HashMap hashMap = s_temporaryThreadList;
        synchronized (hashMap) {
            s_temporaryThreadList.remove(this);
        }
    }

    public void log(String message) {
        Server.log(this.getName() + ": " + message);
    }

    public void logException(Exception ex) {
        JmsService.logException(ex);
    }

    public JmsService getJmsService() {
        return this.mService;
    }

    public void run() {
        this.log("Starting thread <" + this.getName() + ">.");
        while (!this.mStopFlag) {
            try {
                this.doWork();
            }
            catch (InterruptedException ex) {
                this.log("Thread interrupted");
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == -1 || ex.getErrorCode() == -813 || ex.getErrorCode() == -709 || ex.getErrorCode() == -708 || ex.getErrorCode() == -807) {
                    this.log("Emergency shutdown: due to database problem: " + ex.getMessage());
                    this.logException(ex);
                    this.mService.getServer().shutdown();
                    continue;
                }
                this.log("Unexpected database error in " + this.getName() + ": " + ex.getMessage());
                this.logException(ex);
            }
            catch (ReceivingException ex) {
                if (!JmsService.getVerboseSendReceive()) continue;
                this.log("Receiving error: " + ex.getMessage());
                this.logException(ex);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log("Unexpected exception in JMS Thread: " + ex.getMessage());
                this.logException(ex);
                Thread.yield();
            }
            catch (Error er) {
                this.log("Unexpected error: " + er);
                Thread.yield();
            }
        }
        this.log("Stopping thread <" + this.getName() + ">.");
        try {
            this.finishWork();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log("Unexpected exception when finishing JMS Thread: " + ex.getMessage());
        }
    }

    public void pleaseStop() {
        this.mStopFlag = true;
        this.interrupt();
    }

    public void doWork() throws Exception {
    }

    public void finishWork() throws Exception {
    }

    public String getAction() {
        return this.mAction == null ? "running" + this.mSQLAction : this.mAction + this.mSQLAction;
    }

    public long getWaitCount() {
        return this.mWaitCount;
    }

    public long getNotificationCount() {
        return this.mNotificationCount;
    }

    void increaseNotificationCount() {
        this.mNotificationCount = this.mNotificationCount < Long.MAX_VALUE ? ++this.mNotificationCount : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performSleep(long seconds) throws InterruptedException {
        this.mAction = "sleeping " + seconds + " seconds";
        if (JmsService.getVerboseWait()) {
            this.writeSemaphoreMsg(this.mAction);
        }
        try {
            Thread.sleep(seconds * 1000L);
            Object var4_2 = null;
            this.mAction = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.mAction = null;
            if (JmsService.getVerboseWait()) {
                this.writeSemaphoreMsg("continue");
            }
            throw throwable;
        }
        if (JmsService.getVerboseWait()) {
            this.writeSemaphoreMsg("continue");
        }
    }

    public static void performWait(Object obj, long timeout, String objName) throws InterruptedException {
        Thread ownThread = Thread.currentThread();
        if (ownThread instanceof JmsThread) {
            ((JmsThread)ownThread).waitSemaphore(obj, timeout, objName);
        } else {
            obj.wait(timeout);
        }
    }

    public void resetAction() {
        this.mAction = null;
    }

    public void resetSQLAction() {
        this.mSQLAction = "";
    }

    public static JmsThread setAction(String action) {
        Thread ownThread = Thread.currentThread();
        if (ownThread instanceof JmsThread) {
            JmsThread ownJmsThread = (JmsThread)ownThread;
            ownJmsThread.mAction = action;
            return ownJmsThread;
        }
        return null;
    }

    public void setOwnAction(String action) {
        this.mAction = action;
    }

    public static void setSQLAction(String action) {
        Thread ownThread = Thread.currentThread();
        if (ownThread instanceof JmsThread) {
            ((JmsThread)ownThread).mSQLAction = "; " + action;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitSemaphore(Object obj, long timeout, String objName) throws InterruptedException {
        if (JmsService.getVerboseWait()) {
            this.writeSemaphoreMsg("waiting for " + objName);
        }
        this.mAction = "waiting for " + objName;
        this.mWaitCount = this.mWaitCount < Long.MAX_VALUE ? ++this.mWaitCount : 0L;
        try {
            obj.wait(timeout);
            Object var6_4 = null;
            this.mAction = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.mAction = null;
            if (JmsService.getVerboseWait()) {
                this.writeSemaphoreMsg("continue " + objName);
            }
            throw throwable;
        }
        if (JmsService.getVerboseWait()) {
            this.writeSemaphoreMsg("continue " + objName);
        }
    }

    private void writeSemaphoreMsg(String msg) {
        Server.log("~~~" + this.getName() + " " + msg);
    }
}

