/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.agents;

import com.sap.sdb.msgServer.Resources;
import com.sap.sdb.msgServer.agents.AdminException;
import com.sap.sdb.msgServer.agents.Agent;
import com.sap.sdb.msgServer.agents.DestinationAlreadyExistsException;
import com.sap.sdb.msgServer.agents.FreeLists;
import com.sap.sdb.msgServer.client.DestinationImpl;
import com.sap.sdb.msgServer.client.QueueImpl;
import com.sap.sdb.msgServer.client.TopicImpl;
import com.sap.sdb.msgServer.database.ConsumerList;
import com.sap.sdb.msgServer.database.DBConnectionPool;
import com.sap.sdb.msgServer.database.DestinationList;
import com.sap.sdb.msgServer.database.SendOrderTable;
import com.sap.sdb.msgServer.database.UserConnection;
import com.sap.sdb.msgServer.jndi.JndiService;
import com.sap.sdb.msgServer.msgselector.MsgSelector;
import com.sap.sdb.msgServer.service.JmsService;
import com.sap.sdb.msgServer.service.ServiceException;
import com.sap.sdb.msgServer.util.ActivateAdminNotification;
import com.sap.sdb.msgServer.util.BrowserRegNotification;
import com.sap.sdb.msgServer.util.ConsumerEntity;
import com.sap.sdb.msgServer.util.DeactivateAdminNotification;
import com.sap.sdb.msgServer.util.DestinationAdminNotification;
import com.sap.sdb.msgServer.util.DestinationAuth;
import com.sap.sdb.msgServer.util.DestinationEntity;
import com.sap.sdb.msgServer.util.ErrorNotification;
import com.sap.sdb.msgServer.util.IDNotification;
import com.sap.sdb.msgServer.util.ListDestAdminNotification;
import com.sap.sdb.msgServer.util.MessageConsumerInfo;
import com.sap.sdb.msgServer.util.Notification;
import com.sap.sdb.msgServer.util.NotificationQueue;
import com.sap.sdb.msgServer.util.RequestServerTimeAdminNotification;
import com.sap.sdb.msgServer.util.ResetAdminNotification;
import com.sap.sdb.msgServer.util.ServerTimeNotification;
import com.sap.sdb.msgServer.util.StreamString;
import com.sap.sdb.msgServer.util.VectorNotification;
import java.sql.SQLException;
import java.util.Vector;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.naming.NamingException;

public class AdminAgent
extends Agent {
    JmsService mService;

    public AdminAgent(JmsService service, NotificationQueue notQueue) throws ServiceException {
        super(service, Resources.getString("AdminAgent.AdminAgent"), notQueue);
        this.mService = service;
    }

    public Notification doCommand(Notification notification) {
        this.increaseNotificationCount();
        try {
            if (notification instanceof DestinationAdminNotification) {
                DestinationAdminNotification da_notif = (DestinationAdminNotification)notification;
                if (da_notif.getType() == 0) {
                    this.create(da_notif);
                    return FreeLists.getOkNotification();
                }
                if (da_notif.getType() == 1) {
                    this.drop(da_notif.getIsQueue(), da_notif.getDestinationName());
                    return FreeLists.getOkNotification();
                }
                if (da_notif.getType() == 2) {
                    return this.getSendorderCount(da_notif.getDestinationName(), da_notif.getIsQueue());
                }
            }
            if (notification instanceof ListDestAdminNotification) {
                ListDestAdminNotification list_notif = (ListDestAdminNotification)notification;
                if (list_notif.getType() == 0) {
                    Vector dests = this.listDestinations(list_notif.getIsQueue(), list_notif.getDestinationName());
                    return new VectorNotification(dests);
                }
                if (list_notif.getType() == 1) {
                    Vector subs = this.listSubscriptions(list_notif.getIsQueue(), list_notif.getDestinationName());
                    return new VectorNotification(subs);
                }
            }
            if (notification instanceof RequestServerTimeAdminNotification) {
                return new ServerTimeNotification(JmsService.getTimeStamp());
            }
            if (notification instanceof DeactivateAdminNotification) {
                DeactivateAdminNotification deactNotif = (DeactivateAdminNotification)notification;
                if (deactNotif.getType() == 1) {
                    this.unsubscribe(deactNotif.getConsumerID());
                }
                if (deactNotif.getType() == 0) {
                    this.unregister(deactNotif.getConsumerID(), deactNotif.getReceiverClientAddress(), deactNotif.getRemove());
                }
                if (deactNotif.getType() == 2) {
                    this.setIgnoreBySendOrderPolling(deactNotif.getReceiverClientAddress().getString(), JmsService.getTimeStamp());
                }
                if (deactNotif.getType() == 3) {
                    this.setIgnoreBySendOrderPolling(deactNotif.getReceiverClientAddress().getString(), -1L);
                }
                return FreeLists.getOkNotification();
            }
            if (notification instanceof ResetAdminNotification) {
                ResetAdminNotification resetNotif = (ResetAdminNotification)notification;
                this.resetSendOrder(resetNotif.getMessageID(), resetNotif.getConsumerID(), resetNotif.getIsQueue(), resetNotif.getIsDurable());
                return FreeLists.getOkNotification();
            }
            if (notification instanceof ActivateAdminNotification) {
                ActivateAdminNotification activateNotif = (ActivateAdminNotification)notification;
                this.checkAuthorization(activateNotif.getDestinationName(), activateNotif.getIsQueue(), activateNotif.getClientID(), true);
                long consumerID = this.register(activateNotif.getDestinationName(), activateNotif.getSubscriptionName(), activateNotif.getClientID(), activateNotif.getSessionQueueID(), activateNotif.getSessionListenerID(), activateNotif.getIsQueue(), activateNotif.getIsDurable(), activateNotif.getConsumerID(), activateNotif.getMessageSelector(), activateNotif.getIsActive(), activateNotif.getNoLocal());
                return new IDNotification(consumerID);
            }
            if (notification instanceof BrowserRegNotification) {
                BrowserRegNotification bowserNot = (BrowserRegNotification)notification;
                boolean register = bowserNot.getRegister();
                long id = bowserNot.getID();
                if (register) {
                    String msgSelector = bowserNot.getMsgSelector();
                    MsgSelector selector = msgSelector != null ? new MsgSelector(msgSelector) : null;
                    this.getJmsService().addBrowserSelector(new Long(id), selector);
                } else {
                    this.getJmsService().removeBrowserSelector(new Long(id));
                }
                return FreeLists.getOkNotification();
            }
        }
        catch (AdminException ex) {
            return new ErrorNotification(ex);
        }
        catch (NamingException ex) {
            return new ErrorNotification(ex);
        }
        catch (InvalidSelectorException ex) {
            return new ErrorNotification((Exception)((Object)ex));
        }
        return new ErrorNotification(Resources.getString("AdminAgent.No_command_was_executed"));
    }

    private void setIgnoreBySendOrderPolling(String receiverClientAddress, long startTime) {
        ConsumerList.setIgnoreBySendOrderPolling(receiverClientAddress, startTime);
    }

    private void create(DestinationAdminNotification dest_ad) throws NamingException, AdminException {
        boolean isQueue = dest_ad.getIsQueue();
        boolean isTempDest = dest_ad.getIsTempDest();
        String name = dest_ad.getDestinationName();
        UserConnection dbConnection = null;
        try {
            dbConnection = DBConnectionPool.useConnection();
            DestinationEntity dest = DestinationList.reinit(dbConnection, name, isQueue);
            if (dest != null) {
                throw new DestinationAlreadyExistsException(name);
            }
            dest = new DestinationEntity();
            dest.setName(name);
            dest.setQueue(isQueue);
            Vector auth = dest_ad.getAuthentication();
            for (int i = 0; i < auth.size(); ++i) {
                dest.setDestinationAuth((DestinationAuth)auth.get(i));
            }
            DestinationList.persist(dbConnection, dest);
            String jndiName = "jms." + (isQueue ? "queue." : "topic.") + name;
            DestinationImpl object = isQueue ? new QueueImpl(name) : new TopicImpl(name);
            JndiService.rebind(jndiName, object);
            dbConnection.commit();
        }
        catch (JMSException ex) {
            this.logException((Exception)((Object)ex));
            throw new AdminException(ex.toString());
        }
        catch (SQLException ex) {
            this.logException(ex);
            throw new AdminException(ex.toString());
        }
        finally {
            DBConnectionPool.returnConnection(dbConnection);
        }
    }

    private void drop(boolean isQueue, String name) throws NamingException, AdminException {
        UserConnection dbConnection = null;
        try {
            dbConnection = DBConnectionPool.useConnection();
            long consumerID = -1L;
            long destID = DestinationList.getDestinationID(name, isQueue);
            if (destID > 0L) {
                int i;
                Vector consumers = ConsumerList.getConsumersForDestination(dbConnection, destID);
                for (i = 0; i < consumers.size(); ++i) {
                    consumerID = ((ConsumerEntity)consumers.get(i)).getID();
                    MessageConsumerInfo aConsumer = ConsumerList.getActiveConsumer(consumerID);
                    if (aConsumer == null) continue;
                    throw new AdminException("Subscriber with ID <" + consumerID + "> still active, close session or subscriber first");
                }
                DestinationList.deleteByName(dbConnection, name, isQueue);
                for (i = 0; i < consumers.size(); ++i) {
                    this.unsubscribe(((ConsumerEntity)consumers.get(i)).getID());
                }
                String jndiName = "jms." + (isQueue ? "queue." : "topic.") + name;
                JndiService.unbind(jndiName);
                if (JmsService.getVerboseException()) {
                    this.log("drop destination <" + name + ">, deleted " + consumers.size() + " consumers");
                }
            }
            dbConnection.commit();
        }
        catch (SQLException ex) {
            this.logException(ex);
            throw new AdminException(ex.toString());
        }
        catch (JMSException ex) {
            this.logException((Exception)((Object)ex));
            throw new AdminException(ex.toString());
        }
        finally {
            DBConnectionPool.returnConnection(dbConnection);
        }
    }

    private Vector listDestinations(boolean isQueue, String name) {
        return DestinationList.listDestinations(isQueue, name);
    }

    private Vector listSubscriptions(boolean isQueue, String name) throws AdminException {
        Vector<String> subs = new Vector<String>();
        long dest = DestinationList.getDestinationID(name, isQueue);
        UserConnection dbConnection = null;
        try {
            dbConnection = DBConnectionPool.useConnection();
            Vector consumers = ConsumerList.getConsumersForDestination(dbConnection, dest);
            for (int i = 0; i < consumers.size(); ++i) {
                String temp = Resources.getString("AdminAgent.Consumer") + ((ConsumerEntity)consumers.get(i)).getID() + "," + Resources.getString("AdminAgent.Subscription") + ((ConsumerEntity)consumers.get(i)).getSubscription() + "," + Resources.getString("AdminAgent.State") + ((ConsumerEntity)consumers.get(i)).getStateAsString();
                subs.add(temp);
            }
            dbConnection.commit();
            Vector<String> vector = subs;
            return vector;
        }
        catch (SQLException ex) {
            this.logException(ex);
            throw new AdminException(ex.toString());
        }
        finally {
            DBConnectionPool.returnConnection(dbConnection);
        }
    }

    private long register(String name, String subscription, StreamString clientID, String sessionQueueID, Integer sessionListenerID, boolean isQueue, boolean isDurable, long consumerID, String msgSelector, boolean isActive, boolean noLocal) throws AdminException {
        if (JmsService.getVerboseAdmin()) {
            this.log("AdminAgent.register : \nname=" + name + "\n" + "subscription=" + subscription + "\n" + "clientID=" + clientID + "\n" + "sessionQueueID=" + sessionQueueID + "\n" + "sessionListenerID=" + sessionListenerID + "\n" + "isQueue=" + isQueue + "\n" + "isDurable=" + isDurable + "\n" + "consumerID=" + consumerID + "\n" + "msgSelector=" + msgSelector + "\n" + "isActive=" + isActive + "\n" + "noLocal=" + noLocal + "\n");
        }
        UserConnection dbConnection = null;
        try {
            dbConnection = DBConnectionPool.useConnection();
            long newConsumerID = ConsumerList.register(dbConnection, name, subscription, clientID, sessionQueueID, sessionListenerID, isQueue, isDurable, consumerID, msgSelector, isActive, noLocal);
            dbConnection.commit();
            long l = newConsumerID;
            return l;
        }
        catch (SQLException ex) {
            this.logException(ex);
            throw new AdminException(ex.toString());
        }
        catch (InvalidSelectorException ex) {
            this.logException((Exception)((Object)ex));
            throw new AdminException(ex.toString());
        }
        catch (JMSException ex) {
            this.logException((Exception)((Object)ex));
            throw new AdminException(ex.toString());
        }
        finally {
            DBConnectionPool.returnConnection(dbConnection);
        }
    }

    private void unregister(long consumerID, StreamString clientID, boolean remove) throws AdminException {
        UserConnection dbConnection = null;
        if (JmsService.getVerboseAdmin()) {
            this.log("->AdminAgent.unregister : \nconsumerID=" + consumerID + "\n" + "remove=" + remove + "\n");
        }
        try {
            dbConnection = DBConnectionPool.useConnection();
            ConsumerList.unregisterAndCommit(dbConnection, this.getJmsService().getSendingQueue(), consumerID, clientID, remove);
        }
        catch (SQLException ex) {
            throw new AdminException(ex.toString());
        }
        catch (JMSException ex) {
            throw new AdminException(ex.toString());
        }
        finally {
            DBConnectionPool.returnConnection(dbConnection);
        }
        if (JmsService.getVerboseAdmin()) {
            this.log("<-AdminAgent.unregistered : \nconsumerID=" + consumerID + "\n" + "remove=" + remove + "\n");
        }
    }

    private void unsubscribe(long consumerID) throws AdminException {
        UserConnection dbConnection = null;
        if (JmsService.getVerboseAdmin()) {
            this.log("->AdminAgent.unsubscribe : \nconsumerID=" + consumerID + "\n");
        }
        try {
            dbConnection = DBConnectionPool.useConnection();
            ConsumerList.unsubscribe(dbConnection, this.getJmsService().getSendingQueue(), consumerID);
            dbConnection.commit();
        }
        catch (SQLException ex) {
            throw new AdminException(ex.toString());
        }
        catch (JMSException ex) {
            throw new AdminException(ex.toString());
        }
        finally {
            DBConnectionPool.returnConnection(dbConnection);
        }
        if (JmsService.getVerboseAdmin()) {
            this.log("<-AdminAgent.unsubscribed : \nconsumerID=" + consumerID + "\n");
        }
    }

    public VectorNotification getSendorderCount(String name, boolean isQueue) throws AdminException {
        String s1 = Resources.getString("AdminAgent.Persistent_to_be_delivered");
        String s2 = Resources.getString("AdminAgent.Persistent_to_be_redelivered");
        String s3 = Resources.getString("AdminAgent.Persistent_async_processed_by_server");
        String s4 = Resources.getString("AdminAgent.Persistent_sync_processed_by_server");
        String s5 = Resources.getString("AdminAgent.Persistent_async_delivered_by_server");
        String s6 = Resources.getString("AdminAgent.Persistent_sync_delivered_by_server");
        String s7 = Resources.getString("AdminAgent.Transient_to_be_delivered");
        String s8 = Resources.getString("AdminAgent.Transient_to_be_redelivered");
        String s9 = Resources.getString("AdminAgent.Transient_async_processed_by_server");
        String s10 = Resources.getString("AdminAgent.Transient_sync_processed_by_server");
        String s11 = Resources.getString("AdminAgent.Transient_async_delivered_by_server");
        String s12 = Resources.getString("AdminAgent.Transient_sync_delivered_by_server");
        Vector<String> tmpVector = new Vector<String>();
        tmpVector.add(0, s1 + "0");
        tmpVector.add(1, s2 + "0");
        tmpVector.add(2, s3 + "0");
        tmpVector.add(3, s4 + "0");
        tmpVector.add(4, s5 + "0");
        tmpVector.add(5, s6 + "0");
        if (DBConnectionPool.existsTransientConnection()) {
            tmpVector.add(6, s7 + "0");
            tmpVector.add(7, s8 + "0");
            tmpVector.add(8, s9 + "0");
            tmpVector.add(9, s10 + "0");
            tmpVector.add(10, s11 + "0");
            tmpVector.add(11, s12 + "0");
        }
        VectorNotification not = new VectorNotification(tmpVector);
        UserConnection dbConnection = null;
        if (JmsService.getVerboseAdmin()) {
            this.log("->AdminAgent.getSendorderCount : \ndestination=" + name + ",isQueue:" + String.valueOf(isQueue) + "\n");
        }
        try {
            long temp = 0L;
            long destID = 0L;
            dbConnection = DBConnectionPool.useConnection();
            destID = DestinationList.getDestinationID(name, isQueue);
            if (DBConnectionPool.existsPersistentConnection()) {
                temp = SendOrderTable.selectCountSendOrdersForDest(dbConnection, destID, 0, false, 2);
                tmpVector.set(0, s1 + String.valueOf(temp));
                temp = SendOrderTable.selectCountSendOrdersForDest(dbConnection, destID, 0, true, 2);
                tmpVector.set(1, s2 + String.valueOf(temp));
                temp = SendOrderTable.selectCountSendOrdersForDest(dbConnection, destID, 1, false, 2);
                tmpVector.set(2, s3 + String.valueOf(temp));
                temp = SendOrderTable.selectCountSendOrdersForDest(dbConnection, destID, 2, false, 2);
                tmpVector.set(3, s4 + String.valueOf(temp));
                temp = SendOrderTable.selectCountSendOrdersForDest(dbConnection, destID, 1, true, 2);
                tmpVector.set(4, s5 + String.valueOf(temp));
                temp = SendOrderTable.selectCountSendOrdersForDest(dbConnection, destID, 2, true, 2);
                tmpVector.set(5, s6 + String.valueOf(temp));
            }
            if (DBConnectionPool.existsTransientConnection()) {
                temp = SendOrderTable.selectCountSendOrdersForDest(dbConnection, destID, 0, false, 1);
                tmpVector.set(6, s7 + String.valueOf(temp));
                temp = SendOrderTable.selectCountSendOrdersForDest(dbConnection, destID, 0, true, 1);
                tmpVector.set(7, s8 + String.valueOf(temp));
                temp = SendOrderTable.selectCountSendOrdersForDest(dbConnection, destID, 1, false, 1);
                tmpVector.set(8, s9 + String.valueOf(temp));
                temp = SendOrderTable.selectCountSendOrdersForDest(dbConnection, destID, 2, false, 1);
                tmpVector.set(9, s10 + String.valueOf(temp));
                temp = SendOrderTable.selectCountSendOrdersForDest(dbConnection, destID, 1, true, 1);
                tmpVector.set(10, s11 + String.valueOf(temp));
                temp = SendOrderTable.selectCountSendOrdersForDest(dbConnection, destID, 2, true, 1);
                tmpVector.set(11, s12 + String.valueOf(temp));
            }
            dbConnection.commit();
        }
        catch (SQLException ex) {
            try {
                throw new AdminException(ex.toString());
            }
            catch (Throwable throwable) {
                DBConnectionPool.returnConnection(dbConnection);
                throw throwable;
            }
        }
        DBConnectionPool.returnConnection(dbConnection);
        if (JmsService.getVerboseAdmin()) {
            this.log("<-AdminAgent.getSendorderCount : \ndestination=" + name + ",isQueue:" + String.valueOf(isQueue) + "\n");
        }
        return not;
    }

    private void resetSendOrder(long messageID, long consumerID, boolean isQueue, boolean isDurable) throws AdminException {
        UserConnection dbConnection = null;
        try {
            dbConnection = DBConnectionPool.useConnection();
            if (isQueue) {
                int rowCount = SendOrderTable.resetQueueOrder(dbConnection, 2, messageID, consumerID);
                if ((rowCount += SendOrderTable.resetQueueOrder(dbConnection, 1, messageID, consumerID)) != 1 && JmsService.getVerboseException()) {
                    this.log(Resources.getString("AdminAgent.Could_not_reset_Sendorder_messsage") + messageID + ">, consumer <" + consumerID + ">");
                }
            } else if (isDurable) {
                int rowCount = SendOrderTable.resetTopicOrder(dbConnection, 2, messageID, consumerID);
                if ((rowCount += SendOrderTable.resetTopicOrder(dbConnection, 1, messageID, consumerID)) != 1) {
                    throw new AdminException(Resources.getString("AdminAgent.Could_not_reset_Sendorder") + messageID);
                }
            } else {
                int rowCount = SendOrderTable.deleteTopicOrder(dbConnection, 2, messageID, consumerID);
                if ((rowCount += SendOrderTable.deleteTopicOrder(dbConnection, 1, messageID, consumerID)) != 1) {
                    throw new AdminException(Resources.getString("AdminAgent.Could_not_reset_Sendorder") + messageID);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException ex) {
            this.logException(ex);
            throw new AdminException(ex.toString());
        }
        finally {
            DBConnectionPool.returnConnection(dbConnection);
        }
    }
}

