/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.dataAccess;

import com.sap.sdb.minDB.dataAccess.ConnectionImpl;
import com.sap.sdb.minDB.dataAccess.TableRow;
import com.sap.sdb.minDB.dataAccess.Transaction;

class TransList {
    private long m_newTransId = 1L;
    private Transaction[] m_transList = new Transaction[100];
    private int[] m_freeList = new int[100];
    private int m_firstFree = 0;
    private static final int LIST_SIZE = 100;
    static final int NIL_TRANS_LIST_INDEX = -1;
    private static TransList s_instance = new TransList();

    static void closeTrans(int transListIndex) {
        if (transListIndex == -1) {
            return;
        }
        s_instance.removeTrans(transListIndex);
    }

    static long getTransactionID(ConnectionImpl connection) {
        return s_instance.createGetTransID(connection);
    }

    static boolean isLockCollision(ConnectionImpl connection, TableRow row) {
        connection.resetCollision();
        int lockedIndex = row.getTransListIndex();
        if (lockedIndex == -1) {
            return false;
        }
        int ownIndex = connection.getTransListIndex();
        if (ownIndex == lockedIndex) {
            return false;
        }
        Transaction lockedTrans = s_instance.getTrans(lockedIndex, row.getTransactionID());
        if (lockedTrans == null) {
            return false;
        }
        connection.setCollision(lockedTrans, row);
        return true;
    }

    static boolean lockTableRow(ConnectionImpl connection, TableRow row) {
        connection.resetCollision();
        return s_instance.setLock(connection, row);
    }

    private TransList() {
        for (int i = 0; i < 99; ++i) {
            this.m_freeList[i] = i + 1;
        }
        this.m_freeList[99] = -1;
    }

    private synchronized long createGetTransID(ConnectionImpl connection) {
        int ownIndex = connection.getTransListIndex();
        if (ownIndex < 0) {
            ownIndex = this.newTrans(connection);
        }
        return this.m_transList[ownIndex].getID();
    }

    private synchronized Transaction getTrans(int index, long transID) {
        Transaction trans = this.m_transList[index];
        return trans != null && trans.matches(transID) ? trans : null;
    }

    private synchronized int newTrans(ConnectionImpl connection) {
        ++this.m_newTransId;
        if (this.m_firstFree < 0) {
            int[] newFreeList = new int[this.m_freeList.length + 100];
            Transaction[] newTransList = new Transaction[newFreeList.length];
            System.arraycopy(this.m_transList, 0, newTransList, 0, this.m_transList.length);
            System.arraycopy(this.m_freeList, 0, newFreeList, 0, this.m_freeList.length);
            this.m_firstFree = this.m_freeList.length;
            for (int i = this.m_freeList.length; i < newFreeList.length - 1; ++i) {
                newFreeList[i] = i + 1;
            }
            newFreeList[newFreeList.length - 1] = -1;
            this.m_transList = newTransList;
            this.m_freeList = newFreeList;
        }
        int index = this.m_firstFree;
        this.m_firstFree = this.m_freeList[index];
        this.m_freeList[index] = -1;
        this.m_transList[index] = new Transaction(this.m_newTransId, connection.getUsername());
        connection.setTransListIndex(index);
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTrans(int index) {
        Transaction trans;
        TransList transList = this;
        synchronized (transList) {
            trans = this.m_transList[index];
            this.m_transList[index] = null;
            this.m_freeList[index] = this.m_firstFree;
            this.m_firstFree = index;
        }
        trans.setEndOfTrans();
    }

    private boolean setLock(ConnectionImpl connection, TableRow row) {
        int ownIndex = connection.getTransListIndex();
        int lockedIndex = row.getTransListIndex();
        if (ownIndex == -1) {
            ownIndex = this.newTrans(connection);
        }
        if (lockedIndex == -1) {
            lockedIndex = ownIndex;
            row.setTransListIndex(ownIndex);
        }
        if (ownIndex == lockedIndex) {
            row.setTransactionID(this.m_transList[ownIndex].getID());
            return true;
        }
        Transaction lockedTrans = this.getTrans(lockedIndex, row.getTransactionID());
        if (lockedTrans != null) {
            connection.setCollision(lockedTrans, row);
            return false;
        }
        row.setTransListIndex(ownIndex);
        row.setTransactionID(this.m_transList[ownIndex].getID());
        return true;
    }
}

