/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.dataAccess;

import com.sap.sdb.minDB.common.DatabaseInputStream;
import com.sap.sdb.minDB.common.DatabaseOutputStream;
import com.sap.sdb.minDB.dataAccess.AnyKey;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseKey;
import java.io.IOException;

public class MultiCharKey
extends AnyKey {
    private int m_initializedCols = 0;
    private String[] m_keyCols;

    MultiCharKey() {
        this.m_keyCols = null;
    }

    public MultiCharKey(int maxKeyCol) {
        this.m_keyCols = new String[maxKeyCol + 1];
    }

    public MultiCharKey(String firstKeyValue, String secondKeyValue) {
        this(2);
        this.m_keyCols[1] = firstKeyValue;
        this.m_keyCols[2] = secondKeyValue;
        this.m_initializedCols = 2;
    }

    public void addCol(int colNo, String keyValue) {
        if (colNo < this.m_keyCols.length) {
            this.m_keyCols[colNo] = keyValue;
        } else {
            super.addCol(colNo, keyValue);
        }
        if (this.m_initializedCols < colNo) {
            this.m_initializedCols = colNo;
        }
    }

    public int compareTo(Object o) {
        MultiCharKey other = (MultiCharKey)o;
        for (int colNo = 1; colNo < this.m_keyCols.length; ++colNo) {
            if (colNo > this.m_initializedCols) {
                return this.m_initializedCols == other.m_initializedCols ? 0 : -1;
            }
            if (colNo > other.m_initializedCols) {
                return 1;
            }
            int compareResult = this.m_keyCols[colNo].compareTo(other.m_keyCols[colNo]);
            if (compareResult == 0) continue;
            return compareResult;
        }
        return 0;
    }

    public boolean isGreaterStopKey(DatabaseKey stopKey) {
        MultiCharKey other = (MultiCharKey)stopKey;
        for (int colNo = 1; colNo < this.m_keyCols.length; ++colNo) {
            if (colNo > this.m_initializedCols || colNo > other.m_initializedCols) {
                return false;
            }
            int compareResult = this.m_keyCols[colNo].compareTo(other.m_keyCols[colNo]);
            if (compareResult == 0) continue;
            return compareResult > 0;
        }
        return false;
    }

    void readFromStream(DatabaseInputStream inStream) throws IOException {
        this.m_initializedCols = inStream.readInt();
        this.m_keyCols = inStream.readStringArray();
    }

    public String toString() {
        if (this.m_initializedCols == 0) {
            return "<empty>";
        }
        StringBuffer str = new StringBuffer(128);
        for (int colNo = 1; colNo <= this.m_initializedCols; ++colNo) {
            str.append("'");
            str.append(this.m_keyCols[colNo]);
            str.append("'");
            if (colNo >= this.m_initializedCols) continue;
            str.append(" ");
        }
        return str.toString();
    }

    void writeToStream(DatabaseOutputStream outStream) throws IOException {
        outStream.writeByte(4);
        outStream.writeInt(this.m_initializedCols);
        outStream.writeStringArray(this.m_keyCols);
    }
}

