/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.dataAccess;

import com.sap.sdb.minDB.common.AnyConnectionImpl;
import com.sap.sdb.minDB.common.AnyDriverImpl;
import com.sap.sdb.minDB.dataAccess.Logentry;
import com.sap.sdb.minDB.dataAccess.LogentryList;
import com.sap.sdb.minDB.dataAccess.SavepointImpl;
import com.sap.sdb.minDB.dataAccess.TableRow;
import com.sap.sdb.minDB.dataAccess.TransList;
import com.sap.sdb.minDB.dataAccess.Transaction;
import com.sap.sdb.minDB.dataAccessInterface.ConnectionHandle;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseLogentry;
import com.sap.sdb.minDB.util.Console;
import com.sap.sdb.minDB.util.ErrorMsg;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.HashMap;

public class ConnectionImpl
extends AnyConnectionImpl
implements ConnectionHandle {
    private boolean m_autoCommit = true;
    private boolean m_connectionClosed = false;
    private boolean m_isWaiting = false;
    private boolean m_verboseLock = false;
    private int m_isolationLevel = 0;
    private int m_timeout = 180000;
    private int m_transListIndex = -1;
    private int m_savepointID = 0;
    private long m_waitCount = 0L;
    private Transaction m_collisionWait = null;
    private TableRow m_collisionRow = null;
    private HashMap m_savepointMap = null;
    private LogentryList m_beforeImageLog = new LogentryList();

    public void close() throws SQLException {
        if (this.m_connectionClosed) {
            return;
        }
        this.rollback();
        this.m_connectionClosed = true;
        this.m_collisionRow = null;
        this.m_collisionWait = null;
        super.close();
    }

    public void commit() {
        if (this.m_connectionClosed) {
            return;
        }
        this.m_savepointMap = null;
        this.m_beforeImageLog.collectGarbageAndClear();
        if (this.m_transListIndex != -1) {
            TransList.closeTrans(this.m_transListIndex);
            this.m_transListIndex = -1;
        }
    }

    public boolean getAutoCommit() {
        return this.m_autoCommit;
    }

    public int getTransactionIsolation() {
        return this.m_isolationLevel;
    }

    public boolean isClosed() {
        return this.m_connectionClosed;
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkConnection();
        this.checkSavepoint(savepoint);
        this.m_savepointMap.remove(savepoint);
    }

    public void rollback() throws SQLException {
        this.checkConnection();
        this.m_savepointMap = null;
        this.m_beforeImageLog.rollbackAndClear();
        if (this.m_transListIndex != -1) {
            TransList.closeTrans(this.m_transListIndex);
            this.m_transListIndex = -1;
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkConnection();
        this.checkSavepoint(savepoint);
        this.m_beforeImageLog.partialRollback((DatabaseLogentry)((Object)savepoint));
    }

    public void setAutoCommit(boolean autoCommit) {
        this.m_autoCommit = autoCommit;
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.setSavepoint(null);
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkConnection();
        if (this.m_savepointMap == null) {
            this.m_savepointMap = new HashMap();
        }
        this.m_savepointID = this.m_savepointID < Integer.MAX_VALUE ? ++this.m_savepointID : 1;
        SavepointImpl savepoint = new SavepointImpl(this.m_savepointID, name);
        this.m_savepointMap.put(savepoint, null);
        this.addLogentry(savepoint);
        return savepoint;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.m_isolationLevel = level;
    }

    public ConnectionImpl(AnyDriverImpl driver, String url, String username) {
        super(driver, url, username);
    }

    void addLogentry(Logentry entry) {
        this.m_beforeImageLog.addLogentry(entry);
    }

    private void checkConnection() throws SQLException {
        if (this.m_connectionClosed) {
            throw ErrorMsg.newSQLException("Connection is closed", -3008);
        }
    }

    private void checkSavepoint(Savepoint savepoint) throws SQLException {
        if (this.m_savepointMap == null || !this.m_savepointMap.containsKey(savepoint)) {
            throw ErrorMsg.newSQLException("Savepoint not found", -4001);
        }
    }

    public long getTransactionID() {
        return TransList.getTransactionID(this);
    }

    public int getTransListIndex() {
        return this.m_transListIndex;
    }

    public synchronized String getWaitMessage() {
        String waitCalls;
        String threadName = Thread.currentThread().getName() + ": ";
        String string = this.m_waitCount <= 0L ? null : (waitCalls = this.m_waitCount == 1L ? this.m_waitCount + " wait call" : this.m_waitCount + " wait calls");
        if (!this.m_isWaiting) {
            return waitCalls == null ? null : threadName + waitCalls;
        }
        String waitMsg = "waiting for transID " + this.m_collisionWait.getID() + " (" + this.m_collisionWait.getThreadName() + ", " + this.m_collisionWait.getUsername() + "), row (" + ((Object)this.m_collisionRow.getKey()).toString() + ")";
        return waitCalls == null ? threadName + waitMsg : threadName + waitCalls + "; " + waitMsg;
    }

    public boolean isCollided() {
        return this.m_collisionWait != null;
    }

    public void partialRollback(DatabaseLogentry firstEntry) {
        this.m_beforeImageLog.partialRollback(firstEntry);
    }

    public synchronized void resetCollision() {
        this.m_collisionWait = null;
        this.m_collisionRow = null;
        this.m_isWaiting = false;
    }

    void setCollision(Transaction waitObj, TableRow collisionRow) {
        this.m_collisionWait = waitObj;
        this.m_collisionRow = collisionRow;
    }

    public void setTimeout(int timeoutSec) {
        this.m_timeout = timeoutSec > 0 ? 1000 * timeoutSec : 0;
    }

    void setTransListIndex(int index) {
        this.m_transListIndex = index;
    }

    public void setVerboseLock() {
        this.m_verboseLock = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitIfCollided() throws SQLException {
        if (this.m_collisionWait == null) {
            return;
        }
        if (this.m_timeout == 0) {
            throw ErrorMsg.newSQLException("Lock collision", 400);
        }
        long collisionTransID = this.m_collisionRow.getTransactionID();
        try {
            Transaction transaction = this.m_collisionWait;
            synchronized (transaction) {
                block14: {
                    if (this.m_collisionWait.matches(collisionTransID)) break block14;
                    return;
                }
                this.m_isWaiting = true;
                this.m_waitCount = this.m_waitCount < Long.MAX_VALUE ? ++this.m_waitCount : 0L;
                if (this.m_verboseLock) {
                    Console.println(this.getWaitMessage());
                }
                try {
                    this.m_collisionWait.wait(this.m_timeout);
                }
                catch (InterruptedException ex) {
                    throw ErrorMsg.newSQLException(ex, 500);
                }
                if (this.m_collisionWait.matches(collisionTransID)) {
                    throw ErrorMsg.newSQLException("Lock request timeout", 500);
                }
            }
        }
        finally {
            this.resetCollision();
        }
    }
}

