/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.common;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class DatabaseOutputStream
extends DataOutputStream {
    private static final int NULL_LENGTH = -1;
    private static final int NULL_OBJECT = 0;
    private static final int STRING_OBJECT = 1;
    private static final int ANY_OBJECT = 2;

    public DatabaseOutputStream(OutputStream outStream) throws IOException {
        super(outStream);
    }

    private void serializeObject(Object obj) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream objStream = new ObjectOutputStream(byteStream);
        objStream.writeObject(obj);
        objStream.flush();
        this.writeInt(byteStream.size());
        byteStream.writeTo(this);
        objStream.close();
    }

    public void writeBooleanArray(boolean[] boolArray) throws IOException {
        if (boolArray == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(boolArray.length);
        for (int i = 0; i < boolArray.length; ++i) {
            this.writeBoolean(boolArray[i]);
        }
    }

    public void writeByteArray(byte[] byteArray) throws IOException {
        if (byteArray == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(byteArray.length);
        this.write(byteArray, 0, byteArray.length);
    }

    public void writeIntArray(int[] intArray) throws IOException {
        if (intArray == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(intArray.length);
        for (int i = 0; i < intArray.length; ++i) {
            this.writeInt(intArray[i]);
        }
    }

    public void writeLongArray(long[] longArray) throws IOException {
        if (longArray == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(longArray.length);
        for (int i = 0; i < longArray.length; ++i) {
            this.writeLong(longArray[i]);
        }
    }

    public void writeObj(Object obj) throws IOException {
        if (obj == null) {
            this.writeByte(0);
            return;
        }
        if (obj instanceof String) {
            this.writeByte(1);
            this.writeUTF((String)obj);
            return;
        }
        this.writeByte(2);
        this.serializeObject(obj);
    }

    public void writeObjArray(Object[] objArray) throws IOException {
        if (objArray == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(objArray.length);
        for (int i = 0; i < objArray.length; ++i) {
            this.writeObj(objArray[i]);
        }
    }

    public void writeString(String text) throws IOException {
        this.writeBoolean(text != null);
        if (text != null) {
            this.writeUTF(text);
        }
    }

    public void writeStringArray(String[] stringArray) throws IOException {
        if (stringArray == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.writeString(stringArray[i]);
        }
    }
}

