/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.common;

import com.sap.sdb.minDB.util.ErrorMsg;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

public abstract class ConnectionDummy
implements Connection {
    public void clearWarnings() throws SQLException {
        throw ErrorMsg.notSupported("Connection.clearWarnings");
    }

    public abstract void close() throws SQLException;

    public abstract void commit() throws SQLException;

    public abstract Statement createStatement() throws SQLException;

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkResultSetType(resultSetType);
        this.checkResultSetConcurrency(resultSetConcurrency);
        return this.createStatement();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkResultSetType(resultSetType);
        this.checkResultSetConcurrency(resultSetConcurrency);
        this.checkResultSetHoldability(resultSetHoldability);
        return this.createStatement();
    }

    public abstract boolean getAutoCommit() throws SQLException;

    public String getCatalog() throws SQLException {
        return null;
    }

    public int getHoldability() {
        return 1;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        throw ErrorMsg.notSupported("Connection.getMetaData");
    }

    public abstract int getTransactionIsolation() throws SQLException;

    public Map getTypeMap() throws SQLException {
        throw ErrorMsg.notSupported("Connection.getTypeMap");
    }

    public SQLWarning getWarnings() throws SQLException {
        throw ErrorMsg.notSupported("Connection.getWarnings");
    }

    public abstract boolean isClosed() throws SQLException;

    public abstract boolean isReadOnly() throws SQLException;

    public String nativeSQL(String sql) throws SQLException {
        throw ErrorMsg.notSupported("Connection.nativeSQL");
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        throw ErrorMsg.notSupported("Connection.prepareCall");
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw ErrorMsg.notSupported("Connection.prepareCall");
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw ErrorMsg.notSupported("Connection.prepareCall");
    }

    public abstract PreparedStatement prepareStatement(String var1) throws SQLException;

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw ErrorMsg.notSupported("Connection.prepareStatement(String, int)");
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkResultSetType(resultSetType);
        this.checkResultSetConcurrency(resultSetConcurrency);
        return this.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkResultSetType(resultSetType);
        this.checkResultSetConcurrency(resultSetConcurrency);
        this.checkResultSetHoldability(resultSetHoldability);
        return this.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw ErrorMsg.notSupported("Connection.prepareStatement(String, int[])");
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw ErrorMsg.notSupported("Connection.prepareStatement(String, String[])");
    }

    public abstract void releaseSavepoint(Savepoint var1) throws SQLException;

    public abstract void rollback() throws SQLException;

    public abstract void rollback(Savepoint var1) throws SQLException;

    public abstract void setAutoCommit(boolean var1) throws SQLException;

    public void setCatalog(String catalog) throws SQLException {
        throw ErrorMsg.notSupported("Connection.setCatalog");
    }

    public void setHoldability(int holdability) throws SQLException {
        this.checkResultSetHoldability(holdability);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        throw ErrorMsg.notSupported("Connection.setReadOnly");
    }

    public abstract Savepoint setSavepoint() throws SQLException;

    public abstract Savepoint setSavepoint(String var1) throws SQLException;

    public abstract void setTransactionIsolation(int var1) throws SQLException;

    public void setTypeMap(Map map) throws SQLException {
        throw ErrorMsg.notSupported("Connection.setTypeMap");
    }

    private void checkResultSetType(int resultSetType) throws SQLException {
        if (resultSetType == 1004) {
            throw ErrorMsg.notSupported("ResultSet.TYPE_SCROLL_INSENSITIVE");
        }
    }

    private void checkResultSetConcurrency(int resultSetConcurrency) throws SQLException {
        if (resultSetConcurrency == 1008) {
            throw ErrorMsg.notSupported("ResultSet.CONCUR_UPDATABLE");
        }
    }

    private void checkResultSetHoldability(int resultSetHoldability) throws SQLException {
        if (resultSetHoldability == 2) {
            throw ErrorMsg.notSupported("ResultSet.CLOSE_CURSORS_AT_COMMIT");
        }
    }
}

