/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.unlocktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestUnlock002
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestUnlock002.createWebDAVSchema();
        TestUnlock002.addGlobalMessage((String)("prepare test " + TestUnlock002.getTestClassId()), (char)'I', (String)"lock a collection and unlock it afterwards");
        host = new String(TestUnlock002.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestUnlock002.getPort();
        baseUrl = TestUnlock002.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestUnlock002.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestUnlock002.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestUnlock002.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestUnlock002.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestUnlock002.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestUnlock002.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestUnlock002");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource.exists()) {
            locktoken = TestUnlock002.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            TestUnlock002.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if (!TestUnlock002.doMkCol(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        TestUnlock002.doLock(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        try {
            locktoken = TestUnlock002.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            resource.UNLOCK(null, locktoken);
            if (resource.getStatus().getStatusCode() != 204) {
                TestUnlock002.addGlobalMessage((String)"4. UNLOCK the collection /TestUnlock002", (char)'E', (String)("WebDAV says: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestUnlock002.addGlobalMessage((String)"4. UNLOCK the collection /TestUnlock002", (char)'I', (String)"Test failed due to some WebDAV feature.");
                return;
            }
            TestUnlock002.addGlobalMessage((String)"4. UNLOCK the collection /TestUnlock002", (char)'I', (String)("Test was successful! Status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
        }
        catch (WDVTestJ_WdvException exc) {
            TestUnlock002.addGlobalMessage((String)"4. UNLOCK the collection /TestUnlock002", (char)'E', (String)("WebDAV says: " + exc.getStatusCode() + " " + exc.getLocalizedMessage()));
            TestUnlock002.addGlobalMessage((String)"4. UNLOCK the collection /TestUnlock002", (char)'I', (String)"Test failed due to some WebDAV feature.");
            return;
        }
        catch (Exception exc) {
            TestUnlock002.addGlobalMessage((String)"4. UNLOCK the collection /TestUnlock002", (char)'E', (String)("Java exception: " + exc.getLocalizedMessage()));
            TestUnlock002.addGlobalMessage((String)"4. UNLOCK the collection /TestUnlock002", (char)'I', (String)"Test failed due to some Java feature.");
            return;
        }
        try {
            if (resource.exists()) {
                TestUnlock002.addGlobalMessage((String)"5. verify that the resource is unlocked by deleting it without using a locktoken", (char)'I', (String)"Deleting...");
                TestUnlock002.doDelete(resource, null, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            }
        }
        catch (NullPointerException e) {
            this.handleExceptions(e);
        }
    }

    public static void cleanUp() throws TestCaseException {
        if (resource.exists()) {
            locktoken = TestUnlock002.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            TestUnlock002.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

