/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.puttests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TestPut013
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;
    static Node property_node = null;

    public static void prepare() throws TestCaseException {
        TestPut013.createWebDAVSchema();
        TestPut013.addGlobalMessage((String)("prepare test " + TestPut013.getTestClassId()), (char)'I', (String)"put a file and try to use this file as parent resource for another file");
        host = new String(TestPut013.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPut013.getPort();
        baseUrl = TestPut013.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestPut013.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestPut013.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPut013.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPut013.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPut013.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPut013.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on WDV_PORT " + WDV_PORT);
        }
        urlStr = new String("/TestPut013.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut013.addGlobalMessage((String)"1. DELETE the resource /TestPut013.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
            return;
        }
        TestPut013.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        contentType = "text/plain";
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentLength = content.length();
        if (!TestPut013.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        urlStr = new String("/TestPut013.txt/sub.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut013.addGlobalMessage((String)"3. PUT /TestPut013.txt/sub.txt", (char)'E', (String)"Preparation failed due to some Java feature.");
            return;
        }
        try {
            resource.PUT(content, contentType, locktoken);
            if (resource.getStatus().getStatusCode() != 403) {
                TestPut013.addGlobalMessage((String)"3. PUT /TestPut013.txt/sub.txt", (char)'E', (String)("WebDAV says: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestPut013.addGlobalMessage((String)"PUT failed due to some WebDAV feature", (char)'I', (String)"Expected result: 403 Forbidden");
                return;
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 403) {
                TestPut013.addGlobalMessage((String)"3. PUT /TestPut013.txt/sub.txt", (char)'I', (String)"Test was successful!");
            }
            TestPut013.addGlobalMessage((String)"3. PUT /TestPut013.txt/sub.txt", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestPut013.addGlobalMessage((String)"PUT failed due to some WebDAV feature", (char)'I', (String)"Expected result: 403 Forbidden");
            return;
        }
        catch (Exception exc) {
            TestPut013.addGlobalMessage((String)"3. PUT /TestPut013.txt/sub.txt", (char)'E', (String)("  Java exception: " + exc));
            exc.printStackTrace();
            TestPut013.addGlobalMessage((String)"PUT failed due to some Java feature", (char)'I', (String)("Skipping test " + TestPut013.getTestClassId()));
            return;
        }
    }

    public static void cleanUp() throws TestCaseException {
        TestPut013.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestPut013.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut013.addGlobalMessage((String)"4. Delete /TestPut013.txt and /TestPut013.txt/sub.txt at baseUrl", (char)'E', (String)"CleanUp failed due to some Java feature.");
            return;
        }
        TestPut013.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

