/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.puttests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestPut005
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestPut005.createWebDAVSchema();
        TestPut005.addGlobalMessage((String)("prepare test " + TestPut005.getTestClassId()), (char)'I', (String)"put on a existing resource with new resource of content length 0");
        host = new String(TestPut005.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPut005.getPort();
        baseUrl = TestPut005.getParameterString((String)"baseUrl", (String)"/webdav");
        start_server = TestPut005.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPut005.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPut005.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPut005.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPut005.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on WDV_PORT " + WDV_PORT);
        }
        urlStr = "/TestPut005.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPut005.addGlobalMessage((String)"1. DELETE the resource /TestPut005.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestPut005.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        try {
            content = "";
            contentType = "text/plain";
            contentLength = 0L;
            resource.PUT(content, contentType, locktoken);
            if (resource.getStatus().getStatusCode() != 201) {
                TestPut005.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("recieved HTTP/1.1 Status Code " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + " Expected result: 201 Created"));
                return;
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestPut005.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + " Expected result: 201 Created"));
            TestPut005.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature");
            return;
        }
        catch (Exception exc) {
            TestPut005.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("  Java exception: " + exc));
            TestPut005.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some Java feature");
            return;
        }
        try {
            content = "Auf der Mauer, auf der Lauer sitzt 'ne kleine Wanze...";
            contentType = "text/plain";
            contentLength = content.length();
            resource.PUT(content, contentType, locktoken);
            if (resource.getStatus().getStatusCode() != 200 && resource.getStatus().getStatusCode() != 204) {
                TestPut005.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("recieved HTTP/1.1 Status Code " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + " Expected results: 200 OK or 204 No Content"));
                return;
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestPut005.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + " Expected result: 201 Created"));
            TestPut005.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature");
            return;
        }
        catch (Exception exc) {
            TestPut005.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("  Java exception: " + exc));
            TestPut005.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some Java feature");
            return;
        }
        TestPut005.compareContent(resource, content, contentType, contentLength, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public static void cleanUp() throws TestCaseException {
        TestPut005.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

