/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.proppatchtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class TestProppatch004
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource_a = null;
    static WDVTestJ_WebDAVCore resource_b = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument_a = null;
    static Document xmlDocument_b = null;
    static Node getlastmodified_node_a = null;
    static Node getlastmodified_node_b = null;

    public static void prepare() throws TestCaseException {
        TestProppatch004.createWebDAVSchema();
        TestProppatch004.addGlobalMessage((String)("prepare test " + TestProppatch004.getTestClassId()), (char)'I', (String)"remove the live property 'getlastmodified' (use of two different empty tags)");
        host = new String(TestProppatch004.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestProppatch004.getPort();
        baseUrl = TestProppatch004.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestProppatch004.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestProppatch004.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestProppatch004.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestProppatch004.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestProppatch004.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestProppatch004.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestProppatch004a.txt");
        resource_a = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource_a == null) {
            TestProppatch004.addGlobalMessage((String)"1. DELETE the resource /TestProppatch004a.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch004.doDelete(resource_a, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestProppatch004.doPut(resource_a, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestProppatch004b.txt");
        resource_b = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource_b == null) {
            TestProppatch004.addGlobalMessage((String)"1. DELETE the resource /TestProppatch004b.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch004.doDelete(resource_b, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        TestProppatch004.doPut(resource_b, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        String body_a = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        body_a = String.valueOf(body_a) + "\n<D:propertyupdate xmlns:D=\"DAV:\"";
        body_a = String.valueOf(body_a) + "\nxmlns:Z=\"DAV:\">";
        body_a = String.valueOf(body_a) + "\n<D:remove>";
        body_a = String.valueOf(body_a) + "\n<D:prop>";
        body_a = String.valueOf(body_a) + "\n<Z:getlastmodified/>";
        body_a = String.valueOf(body_a) + "\n</D:prop>";
        body_a = String.valueOf(body_a) + "\n</D:remove>";
        body_a = String.valueOf(body_a) + "\n</D:propertyupdate>";
        String body_b = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        body_b = String.valueOf(body_b) + "\n<D:propertyupdate xmlns:D=\"DAV:\"";
        body_b = String.valueOf(body_b) + "\nxmlns:Z=\"DAV:\">";
        body_b = String.valueOf(body_b) + "\n<D:remove>";
        body_b = String.valueOf(body_b) + "\n<D:prop>";
        body_b = String.valueOf(body_b) + "\n<Z:getlastmodified></Z:getlastmodified>";
        body_b = String.valueOf(body_b) + "\n</D:prop>";
        body_b = String.valueOf(body_b) + "\n</D:remove>";
        body_b = String.valueOf(body_b) + "\n</D:propertyupdate>";
        try {
            TestProppatch004.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'getlastmodified'", (char)'I', (String)"empty tag: '<Z:getlastmodified/>'");
            xmlDocument_a = resource_a.PROPPATCH(body_a, null);
        }
        catch (WDVTestJ_WdvException exc) {
            TestProppatch004.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'getlastmodified'", (char)'E', (String)("status: " + resource_a.getStatus().getStatusCode() + " " + resource_a.getStatus().getStatusMessage()));
            TestProppatch004.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'getlastmodified'", (char)'I', (String)"test failed due to some WebDAV feature");
            TestProppatch004.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'getlastmodified'", (char)'I', (String)"expected result: 207 Multi-Status");
        }
        catch (SAXParseException exc) {
            TestProppatch004.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'getlastmodified'", (char)'E', (String)("parser says: " + exc.getMessage()));
            TestProppatch004.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'getlastmodified'", (char)'I', (String)("request body: " + body_a));
        }
        catch (Exception exc) {
            TestProppatch004.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'getlastmodified'", (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestProppatch004.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'getlastmodified'", (char)'I', (String)"Test failed due to some Java feature");
        }
        TestProppatch004.addGlobalMessage((String)"check if the property status of 'getlastmodified' is \"HTTP/1.1 409\"", (char)'I', (String)"empty tag: '<Z:getlastmodified/>'");
        if (resource_a.getStatus().getStatusCode() == 207) {
            try {
                NodeList nl_a = xmlDocument_a.getElementsByTagName("D:propstat");
                getlastmodified_node_a = nl_a.item(0);
            }
            catch (NullPointerException exc) {
                TestProppatch004.addGlobalMessage((String)"check if the property status of 'getlastmodified' is \"HTTP/1.1 409\"", (char)'E', (String)"the 'getlastmodified'-element for the resource_a could not be retrieved");
            }
            if (xmlDocument_a.getElementsByTagName("D:status").item(0).getFirstChild().getNodeValue().startsWith("HTTP/1.1 409")) {
                TestProppatch004.addGlobalMessage((String)"check if the property status of 'getlastmodified' is \"HTTP/1.1 409\"", (char)'I', (String)"test succeeded!");
            } else {
                TestProppatch004.addGlobalMessage((String)"check if the property status of 'getlastmodified' is \"HTTP/1.1 409\"", (char)'E', (String)"test failed due to some WebDAV features");
            }
        } else {
            TestProppatch004.addGlobalMessage((String)"Status '207 Multi-Session' expected", (char)'E', (String)("actual status: " + resource_a.getStatus().getStatusCode() + " " + resource_a.getStatus().getStatusMessage()));
        }
        try {
            TestProppatch004.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'getlastmodified'", (char)'I', (String)"empty tag: '<Z:getlastmodified></Z:getlastmodified>'");
            xmlDocument_b = resource_b.PROPPATCH(body_b, null);
        }
        catch (WDVTestJ_WdvException exc) {
            TestProppatch004.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'getlastmodified'", (char)'E', (String)("status: " + resource_b.getStatus().getStatusCode() + " " + resource_b.getStatus().getStatusMessage()));
            TestProppatch004.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'getlastmodified'", (char)'I', (String)"test failed due to some WebDAV feature");
            TestProppatch004.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'getlastmodified'", (char)'I', (String)"expected result: 207 Multi-Status");
        }
        catch (SAXParseException exc) {
            TestProppatch004.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'getlastmodified'", (char)'E', (String)("parser says: " + exc.getMessage()));
            TestProppatch004.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'getlastmodified'", (char)'I', (String)("request body: " + body_b));
        }
        catch (Exception exc) {
            TestProppatch004.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'getlastmodified'", (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestProppatch004.addGlobalMessage((String)"PROPPATCH (remove) the read-only live prop 'getlastmodified'", (char)'I', (String)"Test failed due to some Java feature");
        }
        TestProppatch004.addGlobalMessage((String)"check if the property status of 'getlastmodified' is \"HTTP/1.1 409\"", (char)'I', (String)"empty tag: '<Z:getlastmodified></Z:getlastmodified>'");
        if (resource_b.getStatus().getStatusCode() == 207) {
            try {
                NodeList nl_b = xmlDocument_b.getElementsByTagName("getlastmodified");
                getlastmodified_node_b = nl_b.item(0);
            }
            catch (NullPointerException exc) {
                TestProppatch004.addGlobalMessage((String)"check if the property status of 'getlastmodified' is \"HTTP/1.1 409\"", (char)'E', (String)"the 'getlastmodified'-element for the resource_b could not be retrieved");
            }
            if (xmlDocument_b.getElementsByTagName("D:status").item(0).getFirstChild().getNodeValue().startsWith("HTTP/1.1 409")) {
                TestProppatch004.addGlobalMessage((String)"check if the property status of 'getlastmodified' is \"HTTP/1.1 409\"", (char)'I', (String)"test succeeded!");
            } else {
                TestProppatch004.addGlobalMessage((String)"check if the property status of 'getlastmodified' is \"HTTP/1.1 409\"", (char)'E', (String)"test failed due to some WebDAV features");
            }
        } else {
            TestProppatch004.addGlobalMessage((String)"Status '207 Multi-Session' expected", (char)'E', (String)("actual status: " + resource_b.getStatus().getStatusCode() + " " + resource_b.getStatus().getStatusMessage()));
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestProppatch004a.txt");
        resource_b = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource_b == null) {
            TestProppatch004.addGlobalMessage((String)"6. clean up and DELETE the resource /TestProppatch004a.txt at baseUrl ", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch004.doDelete(resource_b, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestProppatch004b.txt");
        resource_b = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource_b == null) {
            TestProppatch004.addGlobalMessage((String)"7. clean up and DELETE the resource /TestProppatch004b.txt at baseUrl ", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestProppatch004.doDelete(resource_b, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

