/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.propfindtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestPropfind010
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static Document xmlDocument = null;
    static Node resourcetype_node = null;
    static String resourcetype_Str = null;
    static String resourcetype_StrR = null;

    public static void prepare() throws TestCaseException {
        TestPropfind010.createWebDAVSchema();
        TestPropfind010.addGlobalMessage((String)("prepare test " + TestPropfind010.getTestClassId()), (char)'I', (String)"create a resource and check whether the property 'resourcetype' supplied by PROPFIND is correct or not");
        host = new String(TestPropfind010.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestPropfind010.getPort();
        baseUrl = TestPropfind010.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestPropfind010.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestPropfind010.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestPropfind010.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestPropfind010.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestPropfind010.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestPropfind010.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestPropfind010.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPropfind010.addGlobalMessage((String)"1. DELETE the resource /TestPropfind010.txt at baseUrl", (char)'E', (String)"Preparation failed due to some Java feature.");
        }
        TestPropfind010.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestPropfind010.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        String body = new String("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        body = String.valueOf(body) + "<D:propfind xmlns:D=\"DAV:\">";
        body = String.valueOf(body) + "<D:prop>";
        body = String.valueOf(body) + "<D:resourcetype/>";
        body = String.valueOf(body) + "</D:prop>";
        body = String.valueOf(body) + "</D:propfind>";
        try {
            xmlDocument = resource.PROPFIND(body);
            TestPropfind010.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"result is going to be compared to posted data");
        }
        catch (WDVTestJ_WdvException exc) {
            TestPropfind010.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestPropfind010.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature");
        }
        catch (Exception exc) {
            TestPropfind010.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
            TestPropfind010.addGlobalMessage((String)("PROPFIND http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Preparations failed due to some Java feature");
        }
        try {
            NodeList nl = xmlDocument.getElementsByTagName("s1:resourcetype");
            resourcetype_node = nl.item(0);
            TestPropfind010.addGlobalMessage((String)"retrieving the 'resourcetype'-element", (char)'I', (String)"element was found. Test was successful.");
        }
        catch (NullPointerException npexc) {
            TestPropfind010.addGlobalMessage((String)"retrieving the 'resourcetype'-element", (char)'E', (String)"the 'resourcetype'-element for the reource could not be retrieved");
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestPropfind010.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestPropfind010.addGlobalMessage((String)"4. clean up and DELETE the resource /TestPropfind010.txt at baseUrl", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestPropfind010.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

