/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.movetests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public class TestMove009
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static String dest_Url = null;

    public static void prepare() throws TestCaseException {
        TestMove009.createWebDAVSchema();
        TestMove009.addGlobalMessage((String)("prepare test " + TestMove009.getTestClassId()), (char)'I', (String)"Move a resource on a existing collection");
        host = new String(TestMove009.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestMove009.getPort();
        baseUrl = TestMove009.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestMove009.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestMove009.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestMove009.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestMove009.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestMove009.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestMove009.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestMove009");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove009.addGlobalMessage((String)"1. DELETE /TestMove009 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove009.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestMove009.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove009.addGlobalMessage((String)"1. DELETE /TestMove009.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMove009.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestMove009");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove009.addGlobalMessage((String)"2. create the folder /TestMove009 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestMove009.doMkCol(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestMove009.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove009.addGlobalMessage((String)"2. create resource /TestMove009.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        TestMove009.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        urlStr = new String("/TestMove009.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove009.addGlobalMessage((String)"3. MOVE /TestMove009.txt on /TestMove009", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        dest_Url = null;
        String body = null;
        locktoken = null;
        try {
            dest_Url = new URL("http", host, WDV_PORT, String.valueOf(baseUrl) + "/TestMove009").toString();
        }
        catch (MalformedURLException exc) {
            TestMove009.addGlobalMessage((String)"3. MOVE /TestMove009.txt on /TestMove009", (char)'E', (String)"Test failed due to some Java-URL feature");
        }
        try {
            resource.MOVE(dest_Url, "T", body, locktoken);
            if (resource.getStatus().getStatusCode() == 204) {
                TestMove009.addGlobalMessage((String)"3. MOVE /TestMove009.txt on /TestMove009", (char)'I', (String)("server returned the correct status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\nTest was successful!"));
            } else {
                TestMove009.addGlobalMessage((String)"3. MOVE /TestMove009.txt on /TestMove009", (char)'E', (String)("unexpected status code: " + resource.getStatus().getStatusCode()));
                TestMove009.addGlobalMessage((String)"3. MOVE /TestMove009.txt on /TestMove009", (char)'I', (String)"expected: 204 No Content");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestMove009.addGlobalMessage((String)("MOVE TO http://" + dest_Url), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestMove009.addGlobalMessage((String)"MOVE failed due to some WebDAV feature", (char)'I', (String)"Expected result: 204 No Content");
        }
        catch (Exception exc) {
            TestMove009.addGlobalMessage((String)("MOVE TO http://" + dest_Url), (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestMove009.addGlobalMessage((String)"MOVE failed due to some Java feature", (char)'I', (String)("Skipping test " + TestMove009.getTestClassId()));
        }
        urlStr = new String("/TestMove009.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove009.addGlobalMessage((String)"4. check, whether the source was deleted correctly", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        try {
            resource.HEAD(null);
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 404) {
                TestMove009.addGlobalMessage((String)"4. check, whether the source was deleted correctly", (char)'I', (String)"Test was successful!!");
            } else {
                TestMove009.addGlobalMessage((String)"4. check, whether the source was deleted correctly", (char)'E', (String)("WebDAV said: " + exc.getStatusCode() + " " + exc.getMessage()));
            }
        }
        catch (IOException exc) {
            this.handleExceptions(exc);
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestMove009");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove009.addGlobalMessage((String)"5. clean up and DELETE /TestMove009 as well as /TestMove009.txt", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestMove009.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestMove009.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMove009.addGlobalMessage((String)"5. clean up and DELETE /TestMove009 as well as /TestMove009.txt", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        TestMove009.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

