/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.mkcoltests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestMkcol005
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static boolean skipTest = false;

    public static void prepare() throws TestCaseException {
        TestMkcol005.createWebDAVSchema();
        TestMkcol005.addGlobalMessage((String)("prepare test " + TestMkcol005.getTestClassId()), (char)'I', (String)"************************************************************\n* MKCOL to create folders that have umlauts in their names *\n************************************************************");
        host = new String(TestMkcol005.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestMkcol005.getPort();
        baseUrl = TestMkcol005.getParameterString((String)"baseUrl", (String)"/webdav");
        start_server = TestMkcol005.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestMkcol005.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestMkcol005.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestMkcol005.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestMkcol005.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestMkcol005";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMkcol005.addGlobalMessage((String)"1. DELETE resource /TestMkcol005 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMkcol005.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        if (!TestMkcol005.doMkCol(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        urlStr = "/TestMkcol005/\u00e4\u00f6\u00fc";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMkcol005.addGlobalMessage((String)"3. create a sub-folder with umlauts", (char)'E', (String)"Test failed due to some Java feature.");
        }
        try {
            resource.MKCOL(null);
            if (resource.getStatus().getStatusCode() != 201) {
                TestMkcol005.addGlobalMessage((String)"3. create a sub-folder with umlauts", (char)'W', (String)("The sub-folder could not be created. The server returned: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "\n" + "refer to this PTS message: http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1122934"));
            }
        }
        catch (WDVTestJ_WdvException e) {
            if (!(e.getStatusCode() != 500 && e.getStatusCode() != 400 || OS_IS_WINDOWS)) {
                TestMkcol005.addGlobalMessage((String)"2. MKCOL to create the folder /TestMkcol005/\u00e4\u00f6\u00fc at baseUrl", (char)'W', (String)"Request is not possible on ressource with umlauts.\nSee PTS message: http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1122934");
                skipTest = true;
                return;
            }
            TestMkcol005.addGlobalMessage((String)"3. create a sub-folder with umlauts", (char)'E', (String)("The sub-folder could not be created. The server returned: " + e.getStatusCode() + " " + e.getMessage()));
            return;
        }
        catch (Exception e) {
            if (TestMkcol005.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T")) {
                TestMkcol005.addGlobalMessage((String)"2. MKCOL to create the folder /TestMkcol005/\u00e4\u00f6\u00fc at baseUrl", (char)'W', (String)"Request is not possible on ressource with umlauts.\nSee PTS message: http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1122934");
                skipTest = true;
                return;
            }
            TestMkcol005.addGlobalMessage((String)"IOException occurred", (char)'W', (String)e.getMessage());
            return;
        }
        if (skipTest) {
            return;
        }
        urlStr = "/TestMkcol005/\u00e4\u00f6\u00fc/test005.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMkcol005.addGlobalMessage((String)"4. create a resource to test the new collection", (char)'E', (String)"Test failed due to some Java feature.");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        locktoken = null;
        if (!TestMkcol005.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            return;
        }
        TestMkcol005.compareContent(resource, content, contentType, contentLength, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public static void cleanUp() throws TestCaseException {
        if (skipTest) {
            return;
        }
        urlStr = "/TestMkcol005";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestMkcol005.addGlobalMessage((String)"6. clean up and DELETE the folder /TestMkcol005", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestMkcol005.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

