/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.locktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestLock022
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestLock022.createWebDAVSchema();
        TestLock022.addGlobalMessage((String)("prepare test " + TestLock022.getTestClassId()), (char)'I', (String)"try to add member URIs to a locked collection without a locktoken");
        host = new String(TestLock022.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestLock022.getPort();
        baseUrl = TestLock022.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestLock022.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestLock022.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestLock022.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestLock022.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestLock022.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestLock022.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock022");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock022.addGlobalMessage((String)"1. DELETE all files and collections", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists() && !TestLock022.doDelete(resource, locktoken = TestLock022.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr), String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        if (!TestLock022.doMkCol(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        TestLock022.doLock(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        urlStr = new String("/TestLock022/test");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock022.addGlobalMessage((String)"4. try to create the collection /TestLock022/test", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        try {
            resource.MKCOL(locktoken);
            if (resource.getStatus().getStatusCode() != 403 && resource.getStatus().getStatusCode() != 423) {
                TestLock022.addGlobalMessage((String)"4. try to create the collection /TestLock022/test", (char)'E', (String)("WebDAV replied: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestLock022.addGlobalMessage((String)"4. try to create the collection /TestLock022/test", (char)'I', (String)("Skipping test " + TestLock022.getTestClassId()));
                return;
            }
            TestLock022.addGlobalMessage((String)"4. try to create the collection /TestLock022/test", (char)'I', (String)("Response: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + " ...Test was successful!"));
        }
        catch (WDVTestJ_WdvException exc) {
            if (TestLock022.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T")) {
                if (exc.getStatusCode() != 403) {
                    TestLock022.addGlobalMessage((String)"4. try to create the collection /TestLock022/test", (char)'E', (String)("WebDAV replied: " + exc.getStatusCode() + " " + exc.getMessage()));
                    TestLock022.addGlobalMessage((String)"4. try to create the collection /TestLock022/test", (char)'I', (String)"Test failed due to some WebDAV feature.");
                    return;
                }
                TestLock022.addGlobalMessage((String)"4. try to create the collection /TestLock022/test", (char)'I', (String)("Response: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + " ...Test was successful!"));
            } else {
                if (exc.getStatusCode() != 423) {
                    TestLock022.addGlobalMessage((String)"4. try to create the collection /TestLock022/test", (char)'E', (String)("WebDAV replied: " + exc.getStatusCode() + " " + exc.getMessage()));
                    TestLock022.addGlobalMessage((String)"4. try to create the collection /TestLock022/test", (char)'I', (String)"Test failed due to some WebDAV feature.");
                    return;
                }
                TestLock022.addGlobalMessage((String)"4. try to create the collection /TestLock022/test", (char)'I', (String)("Response: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + " ...Test was successful!"));
            }
        }
        catch (Exception exc) {
            TestLock022.addGlobalMessage((String)"4. try to create the collection /TestLock022/test", (char)'E', (String)("Java exception: " + exc));
            TestLock022.addGlobalMessage((String)"4. try to create the collection /TestLock022/test", (char)'I', (String)"Test failed due to some Java feature.");
            return;
        }
        urlStr = new String("/TestLock022/test.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock022.addGlobalMessage((String)"5. try to create the file /TestLock022/test.txt", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        try {
            resource.PUT(content, contentType, locktoken);
            if (resource.getStatus().getStatusCode() != 403 && resource.getStatus().getStatusCode() != 423) {
                TestLock022.addGlobalMessage((String)"5. try to create the file /TestLock022/test.txt", (char)'E', (String)("WebDAV replied: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestLock022.addGlobalMessage((String)"5. try to create the file /TestLock022/test.txt", (char)'I', (String)("Skipping test " + TestLock022.getTestClassId()));
                return;
            }
            TestLock022.addGlobalMessage((String)"5. try to create the file /TestLock022/test.txt", (char)'I', (String)("Response: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "Test was successful!"));
        }
        catch (WDVTestJ_WdvException exc) {
            if (TestLock022.getParameterString((String)"use_servlet", (String)"F").equalsIgnoreCase("T")) {
                if (exc.getStatusCode() != 403) {
                    TestLock022.addGlobalMessage((String)"5. try to create the file /TestLock022/test.txt", (char)'E', (String)("WebDAV replied: " + exc.getStatusCode() + " " + exc.getMessage()));
                    TestLock022.addGlobalMessage((String)"5. try to create the file /TestLock022/test.txt", (char)'I', (String)"Test failed due to some WebDAV feature.");
                    return;
                }
                TestLock022.addGlobalMessage((String)"5. try to create the file /TestLock022/test.txt", (char)'I', (String)("Response: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "Test was successful!"));
            } else {
                if (exc.getStatusCode() != 423) {
                    TestLock022.addGlobalMessage((String)"5. try to create the file /TestLock022/test.txt", (char)'E', (String)("WebDAV replied: " + exc.getStatusCode() + " " + exc.getMessage()));
                    TestLock022.addGlobalMessage((String)"5. try to create the file /TestLock022/test.txt", (char)'I', (String)"Test failed due to some WebDAV feature.");
                    return;
                }
                TestLock022.addGlobalMessage((String)"5. try to create the file /TestLock022/test.txt", (char)'I', (String)("Response: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + "Test was successful!"));
            }
        }
        catch (Exception exc) {
            TestLock022.addGlobalMessage((String)"5. try to create the file /TestLock022/test.txt", (char)'E', (String)("  Java exception: " + exc));
            TestLock022.addGlobalMessage((String)"5. try to create the file /TestLock022/test.txt", (char)'I', (String)"Test failed due to some Java feature.");
            return;
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestLock022");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock022.addGlobalMessage((String)"6. cleaning up", (char)'E', (String)"CleanUp failed due to some Java feature.");
        }
        if (resource.exists()) {
            locktoken = TestLock022.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock022.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

