/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.locktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestLock021
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestLock021.createWebDAVSchema();
        TestLock021.addGlobalMessage((String)("prepare test " + TestLock021.getTestClassId()), (char)'I', (String)"collection that contains locked members shall be locked.");
        host = new String(TestLock021.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestLock021.getPort();
        baseUrl = TestLock021.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestLock021.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestLock021.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestLock021.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestLock021.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestLock021.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestLock021.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock021/locked/locked.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock021.addGlobalMessage((String)"DELETE all files and collections", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists() && (locktoken = TestLock021.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) != null) {
            TestLock021.doUnlock(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if (resource.exists() && !TestLock021.doDelete(resource, locktoken = TestLock021.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr), String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock021");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock021.addGlobalMessage((String)"DELETE all files and collections", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists()) {
            locktoken = TestLock021.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock021.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if ((resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr = new String("/TestLock021"))) == null) {
            TestLock021.addGlobalMessage((String)"1. create the collection /TestLock021 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestLock021.doMkCol(resource, locktoken = null, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock021/unlocked");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock021.addGlobalMessage((String)"2. create the collection /TestLock021/unlocked at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        locktoken = null;
        TestLock021.doMkCol(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestLock021/unlocked/unlocked.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock021.addGlobalMessage((String)"3. create the file /TestLock021/unlocked/unlocked.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        TestLock021.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestLock021/locked");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock021.addGlobalMessage((String)"4. LOCK the file /TestLock021.txt/locked", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        locktoken = null;
        TestLock021.doMkCol(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestLock021/locked/locked.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock021.addGlobalMessage((String)"5. create the file /TestLock021/locked/locked.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        TestLock021.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        TestLock021.doLock(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public void run() {
        block12: {
            urlStr = new String("/TestLock021");
            resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
            if (resource == null) {
                TestLock021.addGlobalMessage((String)"7. try to lock the collection /TestLock021", (char)'E', (String)"Preparations failed due to some Java feature.");
            }
            String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
            body = String.valueOf(body) + "<D:lockinfo xmlns:D=\"DAV:\">\n";
            body = String.valueOf(body) + "<D:locktype>\n";
            body = String.valueOf(body) + "<D:write/>\n";
            body = String.valueOf(body) + "</D:locktype>\n";
            body = String.valueOf(body) + "<D:lockscope>\n";
            body = String.valueOf(body) + "<D:exclusive/>\n";
            body = String.valueOf(body) + "</D:lockscope>\n";
            body = String.valueOf(body) + "<D:owner>D041249</D:owner>\n";
            body = String.valueOf(body) + "</D:lockinfo>\n";
            try {
                Document xmlBody = resource.LOCK(body, null);
                if (resource.getStatus().getStatusCode() == 207) {
                    NodeList hrefNodeList;
                    TestLock021.addGlobalMessage((String)"7. try to lock the collection /TestLock021", (char)'I', (String)"XML response is going to be examined...");
                    Node startNode = null;
                    String hrefValue = null;
                    int i = 0;
                    int j = 0;
                    do {
                        if ((hrefNodeList = xmlBody.getElementsByTagName("D:href")).getLength() == 0) {
                            hrefNodeList = xmlBody.getElementsByTagName("href");
                        }
                        j = hrefNodeList.getLength();
                    } while (!(hrefValue = (startNode = hrefNodeList.item(i)).getFirstChild().getNodeValue()).equalsIgnoreCase("http://" + host + ":" + WDV_PORT + baseUrl + urlStr + "/locked/locked.txt") && ++i != j);
                    if (!hrefValue.equalsIgnoreCase("http://" + host + ":" + WDV_PORT + baseUrl + urlStr + "/locked/locked.txt")) {
                        TestLock021.addGlobalMessage((String)"Error on examining the XML response", (char)'E', (String)"The 'href'-element does not contain the correct value...Test failed.");
                        TestLock021.addGlobalMessage((String)"Wrong 'href'-value", (char)'I', (String)("Expected : http://" + host + ":" + WDV_PORT + baseUrl + urlStr + "/locked/locked.txt\n" + "received: " + hrefValue));
                        return;
                    }
                    String statusValue = startNode.getNextSibling().getFirstChild().getNodeValue();
                    if (statusValue.equalsIgnoreCase("HTTP/1.1 423 Locked")) {
                        TestLock021.addGlobalMessage((String)"7.1. the XML body must contain a 'HTTP/1.1 423 Locked' for the locked file /TestLock021/locked/locked.txt", (char)'I', (String)"The status of the file is 'HTTP/1.1 423 Locked'...Test was successful!");
                        TestLock021.addGlobalMessage((String)"7.2. the collection /TestLock021 MUST NOT be locked.", (char)'I', (String)"checking...");
                        if (TestLock021.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr) == null) {
                            TestLock021.addGlobalMessage((String)"7.2. the collection /TestLock021 MUST NOT be locked.", (char)'I', (String)"Test was successful!");
                        } else {
                            TestLock021.addGlobalMessage((String)"7.2. the collection /TestLock021 MUST NOT be locked.", (char)'W', (String)"Collection is locked...locktoken was found.\nPTS message:http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1124374");
                        }
                    } else {
                        TestLock021.addGlobalMessage((String)"7.1. the XML body must contain a 'HTTP/1.1 423 Locked' for the locked file /TestLock021/locked/locked.txt", (char)'E', (String)("The status of the file is " + statusValue + "...Test failed due to some WebDAV feature."));
                    }
                    break block12;
                }
                TestLock021.addGlobalMessage((String)"7. try to lock the collection /TestLock021", (char)'E', (String)("WebDAV response: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + " Expected result: 423 locked."));
                TestLock021.addGlobalMessage((String)"7. try to lock the collection /TestLock021", (char)'I', (String)"Test failed due to some WebDAV feature.");
                return;
            }
            catch (WDVTestJ_WdvException exc) {
                TestLock021.addGlobalMessage((String)"7. try to lock the collection /TestLock021", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
                TestLock021.addGlobalMessage((String)"7. try to lock the collection /TestLock021", (char)'I', (String)"Test failed due to some WebDAV feature.");
                return;
            }
            catch (Exception exc) {
                TestLock021.addGlobalMessage((String)"7. try to lock the collection /TestLock021", (char)'E', (String)("Java exception: " + exc));
                TestLock021.addGlobalMessage((String)"7. try to lock the collection /TestLock021", (char)'I', (String)"Test failed due to some Java feature.");
                return;
            }
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestLock021/locked/locked.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock021.addGlobalMessage((String)"8. DELETE all files and collections", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists()) {
            locktoken = TestLock021.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock021.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if ((resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr = new String("/TestLock021"))) == null) {
            TestLock021.addGlobalMessage((String)"8. DELETE all files and collections", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists()) {
            locktoken = TestLock021.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            TestLock021.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

