/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.locktests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public class TestLock014
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestLock014.createWebDAVSchema();
        TestLock014.addGlobalMessage((String)("prepare test " + TestLock014.getTestClassId()), (char)'I', (String)"*********************************************************************************\n* create a null resource and do a COPY with correct locktoken on it (must fail) *\n*********************************************************************************");
        host = new String(TestLock014.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestLock014.getPort();
        baseUrl = TestLock014.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestLock014.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestLock014.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestLock014.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestLock014.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestLock014.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestLock014.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestLock014.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestLock014.addGlobalMessage((String)"1. create the null resource", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (resource.exists() && (locktoken = TestLock014.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) != null) {
            TestLock014.doUnlock(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
        if (resource.exists() && !TestLock014.doDelete(resource, locktoken = TestLock014.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr), String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
        body = String.valueOf(body) + "<D:lockinfo xmlns:D=\"DAV:\">\n";
        body = String.valueOf(body) + "<D:locktype>\n";
        body = String.valueOf(body) + "<D:write/>\n";
        body = String.valueOf(body) + "</D:locktype>\n";
        body = String.valueOf(body) + "<D:lockscope>\n";
        body = String.valueOf(body) + "<D:exclusive/>\n";
        body = String.valueOf(body) + "</D:lockscope>\n";
        body = String.valueOf(body) + "<D:owner>D041249</D:owner>\n";
        body = String.valueOf(body) + "</D:lockinfo>\n";
        try {
            resource.LOCK(body, null);
            if (resource.getStatus().getStatusCode() == 200) {
                TestLock014.addGlobalMessage((String)"3. LOCK the null-resource /TestLock014.txt", (char)'I', (String)"LOCK was successful!");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestLock014.addGlobalMessage((String)"3. LOCK the null-resource /TestLock014.txt", (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage()));
            TestLock014.addGlobalMessage((String)"3. LOCK the null-resource /TestLock014.txt", (char)'I', (String)"Test failed due to some WebDAV feature. Expected: 200 OK");
            throw new TestCaseException(exc.getMessage());
        }
        catch (Exception exc) {
            TestLock014.addGlobalMessage((String)"3. LOCK the null-resource /TestLock014.txt", (char)'E', (String)("Java exception: " + exc.getMessage()));
            TestLock014.addGlobalMessage((String)"3. LOCK the null-resource /TestLock014.txt", (char)'I', (String)"Test failed due to some Java feature.");
            throw new TestCaseException(exc.getMessage());
        }
    }

    public void run() {
        try {
            String dest_Url = new URL("http", host, WDV_PORT, String.valueOf(baseUrl) + "/TestLock014_copy.txt").toString();
            String body = null;
            locktoken = TestLock014.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
            resource.COPY(dest_Url, "F", body, locktoken);
            if (resource.getStatus().getStatusCode() != 405) {
                TestLock014.addGlobalMessage((String)"2. do the COPY on the null resource", (char)'E', (String)("COPY could be executed!Response: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
                TestLock014.addGlobalMessage((String)"2. do the COPY on the null resource", (char)'I', (String)"Test failed due to some WebDAV feature. Expected: 405 Method Not Allowed.");
                return;
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() == 405) {
                TestLock014.addGlobalMessage((String)"2. do the COPY on the null resource", (char)'I', (String)("Test was successful! Response: " + exc.getStatusCode() + " " + exc.getMessage()));
            }
            TestLock014.addGlobalMessage((String)"2. do the COPY on the null resource", (char)'W', (String)("status: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage()));
            TestLock014.addGlobalMessage((String)"2. do the COPY on the null resource", (char)'I', (String)"Test failed due to some WebDAV feature. Expected: 405 Method Not Allowed.PTS messages:\nhttp://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1127815\nhttp://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1124258");
            return;
        }
        catch (MalformedURLException exc) {
            TestLock014.addGlobalMessage((String)"2. do the COPY on the null resource", (char)'E', (String)"Test failed due to some Java-URL feature");
            return;
        }
        catch (Exception exc) {
            TestLock014.addGlobalMessage((String)"2. do the COPY on the null resource", (char)'E', (String)("Java exception: " + exc));
            TestLock014.addGlobalMessage((String)"2. do the COPY on the null resource", (char)'I', (String)"Test failed due to some Java feature");
            return;
        }
    }

    public static void cleanUp() throws TestCaseException {
        locktoken = TestLock014.getLockToken(resource, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        if (locktoken != null) {
            TestLock014.doUnlock(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        }
    }
}

