/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.headtests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestHead002
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestHead002.createWebDAVSchema();
        TestHead002.addGlobalMessage((String)("prepare test " + TestHead002.getTestClassId()), (char)'I', (String)"head on a not existing resource");
        host = new String(TestHead002.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestHead002.getPort();
        baseUrl = TestHead002.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestHead002.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestHead002.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestHead002.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestHead002.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestHead002.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestHead002.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestHead002.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestHead002.addGlobalMessage((String)"1. DELETE resource /TestHead002.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestHead002.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        try {
            String contentLengthR;
            String contentTypeR;
            String contentR = new String(resource.HEAD(null));
            if (contentR != null) {
                TestHead002.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Content recieved. Content: " + contentR));
                TestHead002.addGlobalMessage((String)("PUT http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature");
            }
            if ((contentTypeR = resource.getResponseHeaders().get("Content-Type").toString()) != null) {
                TestHead002.addGlobalMessage((String)("HEAD http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Content type recieved. Content type: " + contentTypeR));
                TestHead002.addGlobalMessage((String)("HEAD http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature.");
            }
            if ((contentLengthR = resource.getResponseHeaders().get("Content-Length").toString()) != null) {
                TestHead002.addGlobalMessage((String)("HEAD http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)"Content length recieved");
                TestHead002.addGlobalMessage((String)("HEAD http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            if (exc.getStatusCode() != 404) {
                TestHead002.addGlobalMessage((String)("HEAD http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + " Expected result: 404 Not found"));
                TestHead002.addGlobalMessage((String)("HEAD http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature");
            } else {
                TestHead002.addGlobalMessage((String)("HEAD http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test ok");
            }
        }
        catch (Exception exc) {
            TestHead002.addGlobalMessage((String)("HEAD http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
            exc.printStackTrace();
            TestHead002.addGlobalMessage((String)("HEAD http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some Java feature");
        }
    }

    public static void cleanUp() throws TestCaseException {
    }
}

