/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.gettests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestGet001
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestGet001.createWebDAVSchema();
        TestGet001.addGlobalMessage((String)("prepare test " + TestGet001.getTestClassId()), (char)'I', (String)"get on an existing resource");
        host = new String(TestGet001.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestGet001.getPort();
        baseUrl = TestGet001.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestGet001.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestGet001.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestGet001.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestGet001.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestGet001.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestGet001.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestGet001.txt";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestGet001.addGlobalMessage((String)"2. DELETE the resource /TestGet001.txt to baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestGet001.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestGet001.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        TestGet001.compareContent(resource, content, contentType, contentLength, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public static void cleanUp() throws TestCaseException {
        TestGet001.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + "/" + baseUrl + urlStr);
    }
}

