/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.deletetests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.sql.SQLException;

public class TestDelete002
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;

    public static void prepare() throws TestCaseException {
        TestDelete002.createWebDAVSchema();
        TestDelete002.addGlobalMessage((String)("prepare test " + TestDelete002.getTestClassId()), (char)'I', (String)"delete an existing folder");
        host = new String(TestDelete002.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestDelete002.getPort();
        baseUrl = TestDelete002.getParameterString((String)"baseUrl", (String)"/webdav");
        start_server = TestDelete002.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestDelete002.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestDelete002.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestDelete002.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestDelete002.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestDelete002");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestDelete002.addGlobalMessage((String)"1. DELETE /TestDelete002 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestDelete002.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestDelete002";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestDelete002.addGlobalMessage((String)"1. MKCOL resource /TestDelete002 to baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestDelete002.doMkCol(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        try {
            resource.DELETE(locktoken);
            if (resource.getStatus().getStatusCode() == 204) {
                TestDelete002.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test was succesful.");
            } else {
                TestDelete002.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + resource.getStatus().getStatusCode() + " " + resource.getStatus().getStatusMessage() + " Expected result: 204 No Content"));
                TestDelete002.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature.");
            }
        }
        catch (WDVTestJ_WdvException exc) {
            TestDelete002.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("WebDAV exception: " + exc.getStatusCode() + " " + exc.getMessage() + " Expected result: 204 No Content"));
            TestDelete002.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some WebDAV feature");
        }
        catch (Exception exc) {
            TestDelete002.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'E', (String)("Java exception: " + exc));
            TestDelete002.addGlobalMessage((String)("DELETE http://" + host + ":" + WDV_PORT + baseUrl + urlStr), (char)'I', (String)"Test failed due to some Java feature");
        }
    }

    public static void cleanUp() throws TestCaseException {
        TestDelete002.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + "/" + baseUrl + urlStr);
    }
}

