/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.copytests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WdvException;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class TestCopy011
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static WDVTestJ_WebDAVCore resource_dest = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static long sleep_time = 5000L;

    public static void prepare() throws TestCaseException {
        TestCopy011.createWebDAVSchema();
        TestCopy011.addGlobalMessage((String)("prepare test " + TestCopy011.getTestClassId()), (char)'I', (String)"**********************************************************************************************************************************\n* copy an existing resource to a resource with a malformed resource uri *\n**********************************************************************************************************************************");
        host = new String(TestCopy011.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestCopy011.getPort();
        baseUrl = TestCopy011.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestCopy011.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestCopy011.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestCopy011.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestCopy011.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestCopy011.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestCopy011.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = "/TestCopy011";
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy011.addGlobalMessage((String)"1. DELETE resource /TestCopy011 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy011.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + "/" + baseUrl + urlStr);
        if (!TestCopy011.doMkCol(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestCopy011/TestCopy011.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy011.addGlobalMessage((String)"2. create the resource /TestCopy011/TestCopy011.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestCopy011.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
    }

    public void run() {
        Vector<String> restrictedSigns = new Vector<String>();
        restrictedSigns.add(new Character('<').toString());
        restrictedSigns.add(new Character('>').toString());
        restrictedSigns.add(new Character('\"').toString());
        restrictedSigns.add(new Character('[').toString());
        restrictedSigns.add(new Character(']').toString());
        restrictedSigns.add(new Character('{').toString());
        restrictedSigns.add(new Character('}').toString());
        restrictedSigns.add(new Character('|').toString());
        restrictedSigns.add(new Character('`').toString());
        restrictedSigns.add(new Character('^').toString());
        restrictedSigns.add(new Character('\u001e').toString());
        restrictedSigns.add(new Character('\u007f').toString());
        Vector<String> destUriVector = new Vector<String>(10, 5);
        Enumeration e = restrictedSigns.elements();
        while (e.hasMoreElements()) {
            String sign = (String)e.nextElement();
            destUriVector.add("/TestCopy011/TestCopy011_" + sign + "_1.txt");
            destUriVector.add("/TestCopy011/" + sign + "_TestCopy011_1.txt");
            destUriVector.add("/TestCopy011/TestCopy011_.txt" + sign);
        }
        Enumeration enum1 = destUriVector.elements();
        while (enum1.hasMoreElements()) {
            String destUri = (String)enum1.nextElement();
            urlStr = new String("/TestCopy011/TestCopy011.txt");
            resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
            if (resource == null) {
                TestCopy011.addGlobalMessage((String)("4. copy the resource /TestCopy011/TestCopy011.txt to " + destUri), (char)'E', (String)"Test failed due to some Java feature.");
            }
            try {
                String dest_Url = new URL("http", host, WDV_PORT, String.valueOf(baseUrl) + destUri).toString();
                String body = null;
                locktoken = null;
                TestCopy011.doCopyThrowingExceptions(resource, dest_Url, "T", body, locktoken);
            }
            catch (WDVTestJ_WdvException exc) {
                if (exc.getStatusCode() == 400) {
                    try {
                        resource_dest = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, destUri);
                        if (!resource_dest.exists()) continue;
                        TestCopy011.addGlobalMessage((String)"2.1. check if the file was not created", (char)'E', (String)"The file was created instead. Test Failed!");
                    }
                    catch (NullPointerException e2) {
                        this.handleExceptions(e2);
                    }
                    continue;
                }
                TestCopy011.addGlobalMessage((String)("2. create the resource " + destUri + ".txt at baseUrl"), (char)'E', (String)("The Server accepted a malformed request uri within the PUT-request.The test failed. server replied '" + exc.getStatusCode() + " " + exc.getMessage()));
                return;
            }
            catch (MalformedURLException exc) {
                TestCopy011.addGlobalMessage((String)("4. copy the resource /TestCopy011/TestCopy011.txt to " + destUri), (char)'E', (String)"Test failed due to some Java-URL feature");
            }
            catch (Exception e3) {
                this.handleExceptions(e3);
            }
        }
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestCopy011");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy011.addGlobalMessage((String)"8. clean up and DELETE the collection /TestCopy011", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy011.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

