/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.WebDAVTest.jtests.copytests;

import com.sap.sapdb.WebDAVTest.jtests.WDVTestJ_WebDAVTestHelper;
import com.sap.sapdb.WebDAVTest.protocol.WDVTestJ_WebDAVCore;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;

public class TestCopy002
extends WDVTestJ_WebDAVTestHelper {
    static String host = null;
    static String baseUrl = null;
    static String var_overwrite = null;
    static String urlStr = null;
    static WDVTestJ_WebDAVCore resource = null;
    static String content = null;
    static String contentType = null;
    static long contentLength = 4711L;
    static String locktoken = null;
    static long sleep_time = 5000L;

    public static void prepare() throws TestCaseException {
        TestCopy002.createWebDAVSchema();
        TestCopy002.addGlobalMessage((String)("prepare test " + TestCopy002.getTestClassId()), (char)'I', (String)"**********************************************************************************************************************************\n* copy an existing resource to a sub-folder where the same resource already exists (with overwrite = 'T' and 'F') (Status 201/204*\n**********************************************************************************************************************************");
        host = new String(TestCopy002.getParameterString((String)"host", (String)"localhost"));
        WDV_PORT = TestCopy002.getPort();
        baseUrl = TestCopy002.getParameterString((String)"baseUrl", (String)"/webdav");
        var_overwrite = TestCopy002.getParameterString((String)"var_overwrite", (String)"F");
        start_server = TestCopy002.getParameterBoolean((String)"start_server", (boolean)false);
        if (start_server) {
            TestCopy002.addGlobalMessage((String)"preparation for test-execution", (char)'I', (String)("starting WebDAV server version '" + WDV_VERSION + "' on port: " + WDV_PORT));
            TestCopy002.startWebDAV(WDV_PORT);
            try {
                Thread.sleep(WDV_STARTUP_TIME);
            }
            catch (InterruptedException iex) {
                TestCopy002.handleGlobalExceptions((Exception)iex);
            }
        }
        if (!TestCopy002.isServerRunning(WDV_PORT)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestCopy002.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy002.addGlobalMessage((String)"1. DELETE resource /TestCopy002.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        if (!TestCopy002.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestCopy002");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy002.addGlobalMessage((String)"1. DELETE folder /TestCopy002 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy002.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestCopy002.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy002.addGlobalMessage((String)"2. create the resource /TestCopy002.txt at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        content = "Sind des Schaefchens Loeckchen braun,lehnt es am Elektrozaun.Wenn es mit den Augen rollt,will es sagen: Zu viel Volt";
        contentType = "text/plain";
        contentLength = content.length();
        if (!TestCopy002.doPut(resource, content, contentType, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr)) {
            throw new TestCaseException("Maybe the webdav service is not running properly on '" + host + ":" + WDV_PORT + "'");
        }
        urlStr = new String("/TestCopy002");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy002.addGlobalMessage((String)"2. create the collection /TestCopy002 at baseUrl", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy002.doMkCol(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestCopy002.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy002.addGlobalMessage((String)"3. COPY /TestCopy002.txt to /TestCopy002/TestCopy002.txt", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        try {
            String dest_Url = new URL("http", host, WDV_PORT, String.valueOf(baseUrl) + "/TestCopy002/TestCopy002.txt").toString();
            String body = null;
            locktoken = null;
            TestCopy002.doCopy(resource, dest_Url, "T", body, locktoken, null);
        }
        catch (MalformedURLException exc) {
            TestCopy002.addGlobalMessage((String)"3. COPY /TestCopy002.txt to /TestCopy002/TestCopy002.txt", (char)'E', (String)"Preparations failed due to some Java-URL feature");
        }
    }

    public void run() {
        String body;
        String dest_Url;
        urlStr = new String("/TestCopy002.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy002.addGlobalMessage((String)"4. copy the resource TestCopy002.txt to /TestCopy002", (char)'E', (String)"Test failed due to some Java feature.");
        }
        try {
            dest_Url = new URL("http", host, WDV_PORT, String.valueOf(baseUrl) + "/TestCopy002/TestCopy002.txt").toString();
            body = null;
            locktoken = null;
            TestCopy002.doCopy(resource, dest_Url, "T", body, locktoken);
        }
        catch (MalformedURLException exc) {
            TestCopy002.addGlobalMessage((String)"4. copy the resource /TestCopy002.txt to /TestCopy002", (char)'E', (String)"Test failed due to some Java-URL feature");
        }
        urlStr = new String("/TestCopy002/TestCopy002.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy002.addGlobalMessage((String)"5. compare the source and the destination after COPY with overwrite = 'T'", (char)'E', (String)"Test failed due to some Java feature.");
        }
        TestCopy002.compareContent(resource, content, contentType, contentLength, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestCopy002.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy002.addGlobalMessage((String)"4. copy the resource TestCopy002.txt to /TestCopy002", (char)'E', (String)"Test failed due to some Java feature.");
        }
        try {
            dest_Url = new URL("http", host, WDV_PORT, String.valueOf(baseUrl) + "/TestCopy002/TestCopy002.txt").toString();
            body = null;
            locktoken = null;
            TestCopy002.doCopy(resource, dest_Url, "F", body, locktoken);
        }
        catch (MalformedURLException exc) {
            TestCopy002.addGlobalMessage((String)"4. copy the resource /TestCopy002.txt to /TestCopy002", (char)'E', (String)"Test failed due to some Java-URL feature");
        }
        urlStr = new String("/TestCopy002/TestCopy002.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy002.addGlobalMessage((String)"7. compare the source and the destination after COPY with overwrite = 'F'", (char)'E', (String)"Test failed due to some Java feature.");
        }
        TestCopy002.compareContent(resource, content, contentType, contentLength, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }

    public static void cleanUp() throws TestCaseException {
        urlStr = new String("/TestCopy002.txt");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy002.addGlobalMessage((String)"8. clean up and DELETE the resource TestCopy002.txt and the collection /TestCopy002", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy002.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
        urlStr = new String("/TestCopy002");
        resource = new WDVTestJ_WebDAVCore().createResource(host, WDV_PORT, baseUrl, urlStr);
        if (resource == null) {
            TestCopy002.addGlobalMessage((String)"8. clean up and DELETE the resource TestCopy002.txt and the collection /TestCopy002", (char)'E', (String)"Preparations failed due to some Java feature.");
        }
        TestCopy002.doDelete(resource, locktoken, String.valueOf(host) + ":" + WDV_PORT + baseUrl + urlStr);
    }
}

