/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.signers;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class PSSSigner
implements Signer {
    public static final byte TRAILER_IMPLICIT = -68;
    private Digest digest;
    private AsymmetricBlockCipher cipher;
    private SecureRandom random;
    private int hLen;
    private int sLen;
    private int emBits;
    private byte[] salt;
    private byte[] mDash;
    private byte[] block;

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, int n) {
        this.cipher = asymmetricBlockCipher;
        this.digest = digest;
        this.hLen = digest.getDigestSize();
        this.sLen = n;
        this.salt = new byte[n];
        this.mDash = new byte[8 + n + this.hLen];
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        RSAKeyParameters rSAKeyParameters = null;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            rSAKeyParameters = (RSAKeyParameters)parametersWithRandom.getParameters();
            this.random = parametersWithRandom.getRandom();
        } else {
            rSAKeyParameters = (RSAKeyParameters)cipherParameters;
            if (bl) {
                this.random = new SecureRandom();
            }
        }
        this.cipher.init(bl, rSAKeyParameters);
        this.emBits = rSAKeyParameters.getModulus().bitLength() - 1;
        this.block = new byte[(this.emBits + 7) / 8];
        this.reset();
    }

    private void clearBlock(byte[] byArray) {
        for (int i = 0; i != byArray.length; ++i) {
            byArray[i] = 0;
        }
    }

    public void update(byte by) {
        this.digest.update(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    public void reset() {
        this.digest.reset();
    }

    public byte[] generateSignature() throws CryptoException, DataLengthException {
        if (this.emBits < 8 * this.hLen + 8 * this.sLen + 9) {
            throw new DataLengthException("encoding error");
        }
        this.digest.doFinal(this.mDash, this.mDash.length - this.hLen - this.sLen);
        if (this.sLen != 0) {
            this.random.nextBytes(this.salt);
            System.arraycopy(this.salt, 0, this.mDash, this.mDash.length - this.sLen, this.sLen);
        }
        byte[] byArray = new byte[this.hLen];
        this.digest.update(this.mDash, 0, this.mDash.length);
        this.digest.doFinal(byArray, 0);
        this.block[this.block.length - this.sLen - 1 - this.hLen - 1] = 1;
        System.arraycopy(this.salt, 0, this.block, this.block.length - this.sLen - this.hLen - 1, this.sLen);
        byte[] byArray2 = this.maskGeneratorFunction1(byArray, 0, byArray.length, this.block.length - this.hLen - 1);
        for (int i = 0; i != byArray2.length; ++i) {
            int n = i;
            this.block[n] = (byte)(this.block[n] ^ byArray2[i]);
        }
        this.block[0] = (byte)(this.block[0] & 255 >> this.block.length * 8 - this.emBits);
        System.arraycopy(byArray, 0, this.block, this.block.length - this.hLen - 1, this.hLen);
        this.block[this.block.length - 1] = -68;
        byte[] byArray3 = this.cipher.processBlock(this.block, 0, this.block.length);
        this.clearBlock(this.block);
        return byArray3;
    }

    public boolean verifySignature(byte[] byArray) {
        int n;
        byte[] byArray2;
        if (this.emBits < 8 * this.hLen + 8 * this.sLen + 9) {
            return false;
        }
        this.digest.doFinal(this.mDash, this.mDash.length - this.hLen - this.sLen);
        try {
            byArray2 = this.cipher.processBlock(byArray, 0, byArray.length);
            System.arraycopy(byArray2, 0, this.block, this.block.length - byArray2.length, byArray2.length);
        }
        catch (Exception exception) {
            return false;
        }
        if (this.block[this.block.length - 1] != -68) {
            this.clearBlock(this.block);
            return false;
        }
        byArray2 = this.maskGeneratorFunction1(this.block, this.block.length - this.hLen - 1, this.hLen, this.block.length - this.hLen - 1);
        for (n = 0; n != byArray2.length; ++n) {
            int n2 = n;
            this.block[n2] = (byte)(this.block[n2] ^ byArray2[n]);
        }
        this.block[0] = (byte)(this.block[0] & 255 >> this.block.length * 8 - this.emBits);
        for (n = 0; n != this.block.length - this.hLen - this.sLen - 2; ++n) {
            if (this.block[n] == 0) continue;
            this.clearBlock(this.block);
            return false;
        }
        if (this.block[this.block.length - this.hLen - this.sLen - 2] != 1) {
            this.clearBlock(this.block);
            return false;
        }
        System.arraycopy(this.block, this.block.length - this.sLen - this.hLen - 1, this.mDash, this.mDash.length - this.sLen, this.sLen);
        this.digest.update(this.mDash, 0, this.mDash.length);
        this.digest.doFinal(this.mDash, this.mDash.length - this.hLen);
        n = this.block.length - this.hLen - 1;
        for (int i = this.mDash.length - this.hLen; i != this.mDash.length; ++i) {
            if ((this.block[n] ^ this.mDash[i]) != 0) {
                this.clearBlock(this.mDash);
                this.clearBlock(this.block);
                return false;
            }
            ++n;
        }
        this.clearBlock(this.mDash);
        this.clearBlock(this.block);
        return true;
    }

    private void ItoOSP(int n, byte[] byArray) {
        byArray[0] = (byte)(n >>> 24);
        byArray[1] = (byte)(n >>> 16);
        byArray[2] = (byte)(n >>> 8);
        byArray[3] = (byte)(n >>> 0);
    }

    private byte[] maskGeneratorFunction1(byte[] byArray, int n, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[this.hLen];
        byte[] byArray4 = new byte[4];
        int n4 = 0;
        this.digest.reset();
        do {
            this.ItoOSP(n4, byArray4);
            this.digest.update(byArray, n, n2);
            this.digest.update(byArray4, 0, byArray4.length);
            this.digest.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n4 * this.hLen, this.hLen);
        } while (++n4 < n3 / this.hLen);
        if (n4 * this.hLen < n3) {
            this.ItoOSP(n4, byArray4);
            this.digest.update(byArray, n, n2);
            this.digest.update(byArray4, 0, byArray4.length);
            this.digest.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n4 * this.hLen, byArray2.length - n4 * this.hLen);
        }
        return byArray2;
    }
}

