/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StreamTest
extends Test {
    private static final String help = "Test for stream handling.";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public StreamTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public StreamTest(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = this.getUnicodeIdentifier("TEST_STREAM");
        this.dropTable(string);
        this.stmt.execute("CREATE TABLE " + string + " (A VARCHAR(20))");
        PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + string + " VALUES (?)");
        preparedStatement.setCharacterStream(1, (Reader)new StringReader("AAAAAAAAAAAAAAAAAAAA"), 5);
        preparedStatement.executeUpdate();
        ResultSet resultSet = this.stmt.executeQuery("SELECT A FROM " + string);
        resultSet.next();
        if (!resultSet.getString(1).equals("AAAAA")) {
            this.log.addFailure(new Failure("Data from stream set incorrectly - found " + resultSet.getString(1)));
        }
        this.dropTable(string);
        this.stmt.execute("CREATE TABLE " + string + " (A VARCHAR(16) BYTE)");
        PreparedStatement preparedStatement2 = this.connection.prepareStatement("SELECT * FROM " + string + " WHERE A=?");
        byte[] byArray = new byte[1];
        preparedStatement2.setBinaryStream(1, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
        preparedStatement2.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        StreamTest streamTest = new StreamTest(stringArray);
        try {
            streamTest.runInner();
        }
        finally {
            streamTest.connection.close();
        }
        if (streamTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

