/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtech.util.Tracer;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LostInLongs
extends Test {
    private static final String help = "help for LostInLongs";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public LostInLongs(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public LostInLongs(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "LostInLongs";
        String string2 = this.getUnicodeIdentifier(string);
        int n = 100000;
        this.dropTable(string2);
        if (this.environment.hasFeature("UnicodeDB")) {
            this.stmt.execute("CREATE TABLE " + string2 + " (a long byte, b long unicode)");
        } else {
            this.stmt.execute("CREATE TABLE " + string2 + " (a long byte, b long ascii)");
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[]{'S', 'A', 'P', ' ', 'D', 'B', ' ', 'F', 'O', 'R', 'E', 'V', 'E', 'R', ' '};
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("SAP DB FOREVER ");
            byArray[i] = (byte)cArray[i % cArray.length];
        }
        PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + string2 + " VALUES (?,?)");
        preparedStatement.setBinaryStream(1, (InputStream)new ByteArrayInputStream(byArray), n);
        preparedStatement.setCharacterStream(2, (Reader)new StringReader(stringBuffer.toString()), n);
        preparedStatement.executeUpdate();
        this.connection.commit();
        ResultSet resultSet = this.stmt.executeQuery("SELECT A,B FROM " + string2);
        resultSet.next();
        this.log.addDifference(string, "Check Resultset Blob", new Long(n), new Long(resultSet.getBlob("a").length()));
        byte[] byArray2 = resultSet.getBytes("a");
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] == (byte)cArray[i % cArray.length]) continue;
            this.log.addFailure(new Failure("WRONG ARRAY:", Tracer.Hex2String((byte[])byArray2)));
            this.log.addFailure(new Failure(string, "Invalid ByteArray at Byte Pos:" + i + " value is: " + byArray2[i] + " instead of " + (byte)cArray[i % cArray.length]));
        }
        String string3 = resultSet.getString("b");
        String string4 = stringBuffer.toString();
        int n2 = -1;
        this.log.addDifference(string, "Check Resultset Clob", new Long(n), new Long(string3.length()));
        for (int i = 0; i < n; ++i) {
            if (string3.charAt(i) == string4.charAt(i)) continue;
            n2 = i;
            break;
        }
        if (n2 > -1) {
            this.log.addFailure(new Failure(string, "Invalid Character at String Pos:" + n2 + " value is: " + string3.charAt(n2) + " instead of " + string4.charAt(n2)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        LostInLongs lostInLongs = new LostInLongs(stringArray);
        try {
            lostInLongs.runInner();
        }
        finally {
            lostInLongs.connection.close();
        }
        if (lostInLongs.log.hasErrors()) {
            System.exit(5);
        }
    }
}

