/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class FileEncodingTest
extends Test {
    private static final String help = "Test that the big decimal scale is correctly set.";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public FileEncodingTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public FileEncodingTest(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        System.setProperty("file.encoding", "ascii");
        String string = this.getUnicodeIdentifier("TEST_ENCODING");
        this.dropTable(string);
        this.stmt.execute("CREATE TABLE " + string + "(C VARCHAR(200))");
        String string2 = "\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df";
        this.stmt.execute("INSERT INTO " + string + " VALUES ('" + string2 + "')");
        PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + string + " VALUES ('" + string2 + "')");
        PreparedStatement preparedStatement2 = this.connection.prepareStatement("INSERT INTO " + string + " VALUES (?)");
        preparedStatement2.setString(1, string2);
        preparedStatement.executeUpdate();
        preparedStatement2.executeUpdate();
        ResultSet resultSet = this.stmt.executeQuery("SELECT C FROM " + string);
        int n = 1;
        while (resultSet.next()) {
            if (!string2.equals(resultSet.getString(1))) {
                this.log.addFailure(new Failure("Mangled string in result no. " + n));
            }
            ++n;
        }
        this.dropTable(string);
        this.stmt.execute("CREATE TABLE " + string + "(C LONG ASCII)");
        this.stmt.execute("INSERT INTO " + string + " VALUES ('" + string2 + "')");
        PreparedStatement preparedStatement3 = this.connection.prepareStatement("INSERT INTO " + string + " VALUES ('" + string2 + "')");
        PreparedStatement preparedStatement4 = this.connection.prepareStatement("INSERT INTO " + string + " VALUES (?)");
        preparedStatement4.setString(1, string2);
        preparedStatement3.executeUpdate();
        preparedStatement4.executeUpdate();
        resultSet = this.stmt.executeQuery("SELECT C FROM " + string);
        n = 1;
        while (resultSet.next()) {
            String string3 = resultSet.getString(1);
            if (!string2.equals(string3)) {
                this.log.addFailure(new Failure("LONG ASCII: Mangled string in result no. " + n + " found " + string3));
            }
            ++n;
        }
        this.connection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        FileEncodingTest fileEncodingTest = new FileEncodingTest(stringArray);
        try {
            fileEncodingTest.runInner();
        }
        finally {
            fileEncodingTest.connection.close();
        }
        if (fileEncodingTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

