/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.resultset;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StandardConformance
extends Test {
    private static final String help = "help for ApiTests";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public StandardConformance(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public StandardConformance(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "StandardConformance";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (a int, b int)");
        ResultSet resultSet = null;
        string = "setFetchSize(-1)";
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT * FROM  " + string2, 1005, 1007);
            resultSet = preparedStatement.executeQuery();
            resultSet.setFetchSize(-1);
            this.log.addFailure(new Failure("excepted SQLException is not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        string = "ResultSet.last() on empty resultset";
        this.log.addDifference(string, "ResultSet.last()", new Boolean(false), new Boolean(resultSet.last()));
        string = "ResultSet.isLast() on empty resultset";
        this.log.addDifference(string, "ResultSet.isLast()", new Boolean(false), new Boolean(resultSet.isLast()));
        string = "Resultset.getType()";
        this.log.addDifference(string, "ResultSet.getType()", new Integer(1005), new Integer(resultSet.getType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        StandardConformance standardConformance = new StandardConformance(stringArray);
        try {
            standardConformance.runInner();
        }
        finally {
            standardConformance.connection.close();
        }
        if (standardConformance.log.hasErrors()) {
            System.exit(5);
        }
    }
}

