/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.prepared;

import com.sap.dbtech.jdbc.CallableStatementSapDB;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class DefaultValues
extends Test {
    private static final String help = "help for DefaultValues";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public DefaultValues(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public DefaultValues(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        CallableStatementSapDB callableStatementSapDB;
        String string = "DefaultValues";
        if (!this.environment.testRunsWithMaxDB()) {
            return;
        }
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        String string3 = this.makeRandomString(10);
        int n = 42;
        String string4 = "2005-10-05 12:12:12.999999";
        Timestamp timestamp = new Timestamp(105, 9, 5, 12, 12, 12, 999999000);
        this.stmt.execute("CREATE TABLE " + string2 + " (homer varchar(10) default '" + string3 + "', " + "bart integer default " + String.valueOf(n) + ", " + "liza timestamp default '" + string4 + "', " + "marge varchar (10) byte default x'" + Tracer.Hex2String((byte[])string3.getBytes()).toUpperCase() + "', " + "apu long byte)");
        PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + string2 + " (homer,bart,liza,marge) VALUES (?,?,?,?)");
        if (preparedStatement instanceof CallableStatementSapDB) {
            callableStatementSapDB = (CallableStatementSapDB)preparedStatement;
        } else if (preparedStatement instanceof com.sap.dbtech.jdbc.trace.PreparedStatement) {
            callableStatementSapDB = (CallableStatementSapDB)((com.sap.dbtech.jdbc.trace.PreparedStatement)preparedStatement).getInner();
        } else {
            return;
        }
        for (int i = 1; i <= callableStatementSapDB.getParameterMetaData().getParameterCount(); ++i) {
            callableStatementSapDB.setDefault(i);
        }
        callableStatementSapDB.executeUpdate();
        ResultSet resultSet = this.stmt.executeQuery("SELECT * FROM " + string2);
        int n2 = 1;
        while (resultSet.next()) {
            this.log.addDifference(string, "Check updated values for row " + n2, string3, resultSet.getString(1));
            this.log.addDifference(string, "Check updated values for row " + n2, new Integer(n), new Integer(resultSet.getInt(2)));
            this.log.addDifference(string, "Check updated values for row " + n2, timestamp, resultSet.getTimestamp(3));
            this.log.addDifference(string, "Check updated values for row " + n2, string3.getBytes(), resultSet.getBytes(4));
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        DefaultValues defaultValues = new DefaultValues(stringArray);
        try {
            defaultValues.runInner();
        }
        finally {
            defaultValues.connection.close();
        }
        if (defaultValues.log.hasErrors()) {
            System.exit(5);
        }
    }
}

