/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.connection;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class TempSpaceLeak
extends Test {
    private static final String help = "help for TempSpaceLeak";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public TempSpaceLeak(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public TempSpaceLeak(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "TempSpaceLeak";
        this.dropTable("TempSpaceLeak");
        this.stmt.execute("CREATE TABLE TempSpaceLeak (a int, b varchar(100))");
        PreparedStatement preparedStatement = this.connection.prepareStatement("Insert into TempSpaceLeak values (?,?)");
        for (int i = 1; i <= 1000; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setString(2, String.valueOf(i));
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        this.connection.commit();
        long l = this.checkTempSpace(this.stmt, "BEFORE");
        for (int i = 0; i < 100; ++i) {
            Connection connection = this.connect();
            PreparedStatement preparedStatement2 = connection.prepareStatement("select * from TempSpaceLeak");
            PreparedStatement preparedStatement3 = connection.prepareStatement("select * from TempSpaceLeak");
            PreparedStatement preparedStatement4 = connection.prepareStatement("select * from TempSpaceLeak");
            ResultSet resultSet = preparedStatement2.executeQuery();
            while (resultSet.next()) {
            }
            resultSet.close();
            preparedStatement2.close();
            preparedStatement3.close();
            preparedStatement4.close();
            connection.close();
            if (i % 100 != 0) continue;
            this.checkTempSpace(this.stmt, "AFTER");
        }
        this.log.addDifference(string, "Check Temp Space", new Long(l), new Long(this.checkTempSpace(this.stmt, "AFTER")));
    }

    private long checkTempSpace(Statement statement, String string) throws SQLException {
        ResultSet resultSet = statement.executeQuery("select USEDTMP, PCTUSEDTMP  from serverdbstatistics");
        resultSet.next();
        long l = resultSet.getLong(1);
        resultSet.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        TempSpaceLeak tempSpaceLeak = new TempSpaceLeak(stringArray);
        try {
            tempSpaceLeak.runInner();
        }
        finally {
            tempSpaceLeak.connection.close();
        }
        if (tempSpaceLeak.log.hasErrors()) {
            System.exit(5);
        }
    }
}

