/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.upgradetest2.util;

import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.utilities.Zipper;
import com.sap.sapdb.upgradetest2.UpgradeTest;
import com.sap.sapdb.upgradetest2.config.ConfigurationException;
import com.sap.sapdb.upgradetest2.config.SettingNotFoundException;
import com.sap.sapdb.upgradetest2.config.xmlConfiguration;
import com.sap.sapdb.upgradetest2.util.Executor;
import com.sap.sapdb.upgradetest2.util.Logger;
import com.stevesoft.pat.Regex;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Vector;

public class InstallationHelper {
    private xmlConfiguration config;
    private File outputBaseDir;
    private Vector tempfiles;

    public InstallationHelper(xmlConfiguration xmlConfiguration2, File file) {
        this.config = xmlConfiguration2;
        this.outputBaseDir = file;
        this.tempfiles = new Vector();
    }

    public int getPackage(int n, String string) throws ConfigurationException, IOException {
        int n2;
        File file = this.getUnpackDir(n, string);
        if (file.exists() && file.isDirectory()) {
            Logger.log(Logger.VERBOSE, "InstallationHelper: Found a directory fitting the requested version (" + file.getName() + "), using that one");
            return 0;
        }
        Vector<String> vector = new Vector<String>();
        vector.add("perl");
        vector.add(this.config.getSetting("/settings/packdistrib/@path"));
        vector.add("-profile");
        vector.add(this.config.getSetting("/test[" + n + "]/instprofile"));
        vector.add("-os");
        vector.add((this.config.getSetting("/environment/os") + this.config.getSetting("/environment/bit")).toUpperCase());
        vector.add("-version");
        StringBuffer stringBuffer = new StringBuffer(this.config.getSetting("/test[" + n + "]/version[@role=\"" + string + "\"]/versionnumber"));
        boolean bl = false;
        String string2 = null;
        if (stringBuffer.length() == 9) {
            bl = false;
        } else if (stringBuffer.length() == 6) {
            bl = true;
            string2 = this.config.getSetting("/test[" + n + "]/version[@role=\"" + string + "\"]/versionnumber/@state");
            this.addTempFile(file);
        } else {
            throw new ConfigurationException("versionnumber has wrong length, must be #.#.##.## (for RAMP states) or #.#.## (for DEV states)");
        }
        int n3 = 0;
        while (n3 < stringBuffer.length()) {
            if (stringBuffer.charAt(n3) == '.') {
                stringBuffer.deleteCharAt(n3);
            }
            ++n3;
        }
        try {
            n2 = Integer.parseInt(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationException("versionnumber can't be parsed into an int. versionnumber mustn't contain other characters than numbers and '.'");
        }
        if (!bl && stringBuffer.substring(6).equals("13")) {
            Logger.log(Logger.VERBOSE, "Requested packet has buildnumber 13 and probably won't exist. Skipping.");
            return -1337;
        }
        vector.add(Integer.toString(n2));
        if (bl) {
            vector.add("-state");
            vector.add(string2);
        }
        vector.add("-build_cd");
        vector.add("-dir");
        if (!file.exists()) {
            Logger.log(Logger.DEBUG, "InstallationHelper: Trying to make directory with path " + file.getAbsolutePath());
            if (!file.mkdirs()) {
                throw new ConfigurationException("Couldn't create directory to store installation files in");
            }
        } else if (!file.isDirectory()) {
            Logger.error("Please remove the file " + file.getAbsolutePath() + " it's in the way!");
            throw new ConfigurationException("Creation of directory for the installation files failed because " + file.getAbsolutePath() + " is in the way");
        }
        vector.add(file.getAbsolutePath());
        if (this.config.getSetting("/test[" + n + "]/instprofile").equals("APO LiveCache")) {
            Logger.log(Logger.VERBOSE, "Fetching LC Apps version from QADB...");
            vector.add("-lca_version");
            try {
                int n4 = bl ? xmlConfiguration.lcaVersion(stringBuffer.toString(), (this.config.getSetting("/environment/os") + this.config.getSetting("/environment/bit")).toUpperCase(), string2) : xmlConfiguration.lcaVersion(stringBuffer.toString(), (this.config.getSetting("/environment/os") + this.config.getSetting("/environment/bit")).toUpperCase());
                if (n4 == 0) {
                    Logger.warning("No LC Apps of RAMP state recorded in QADB for this liveCache version - cannot fetch packets");
                    Logger.log(Logger.DEBUG, "An error occured while fetching the packet, removing directory.");
                    if (!file.delete()) {
                        Logger.warning("Couldn't remove the target directory for the installation files - this might lead to errors");
                    }
                    return 5;
                }
                vector.add(String.valueOf(n4));
            }
            catch (SQLException sQLException) {
                throw new ConfigurationException("Caught SQL exception when trying to fetch LC Apps version from QADB - cannot fetch package\nMessage is:\n" + sQLException.getMessage());
            }
        }
        Executor executor = new Executor(vector.toArray(new String[0]));
        executor.setLogfile(this.createLogFileName(n, "packdistrib_" + string + ".log"));
        int n5 = executor.run();
        if (n5 != 0) {
            Logger.log(Logger.DEBUG, "An error occured while fetching the packet, removing directory.");
            if (!file.delete()) {
                Logger.log(Logger.VERBOSE, "Couldn't remove the target directory for the installation files - this might lead to errors");
            }
        }
        return n5;
    }

    public File getUnpackDir(int n, String string) throws SettingNotFoundException {
        String string2;
        String string3 = "version[@role=\"" + string + "\"]";
        Regex regex = Regex.perlCode((String)"s/\\.0?/_/");
        try {
            string2 = this.config.getSetting("/test[" + n + "]/" + string3 + "/versionnumber/@state");
        }
        catch (SettingNotFoundException settingNotFoundException) {
            string2 = "";
        }
        return new File(this.config.getSetting("/settings/directories/temp") + "/sapdb-" + this.config.getSetting("/test[" + n + "]/instprofile").toLowerCase().replace(' ', '_') + "-" + this.config.getSetting("/environment/os") + "-" + this.config.getSetting("/environment/bit") + "bit-" + this.config.getSetting("/environment/platform") + "-" + regex.replaceAll(this.config.getSetting("/test[" + n + "]/" + string3 + "/versionnumber")) + string2);
    }

    public int installDB(int n, String string) throws SettingNotFoundException, IOException {
        Object object;
        File file = this.getUnpackDir(n, string);
        Vector<String> vector = new Vector<String>();
        String string2 = file.getCanonicalPath();
        vector.add(string2 + File.separator + "SDBINST");
        vector.add("-b");
        vector.add("-profile");
        vector.add(this.config.getSetting("/test[" + n + "]/instprofile"));
        vector.add("-indep_prog");
        vector.add(new File(this.config.getSetting("/settings/directories/indep_prog")).getCanonicalPath());
        vector.add("-indep_data");
        vector.add(new File(this.config.getSetting("/settings/directories/indep_data")).getCanonicalPath());
        vector.add("-depend");
        vector.add(new File(this.config.getSetting("/settings/directories/depend")).getCanonicalPath() + "_" + this.config.getSetting("/test[" + n + "]/version[@role=\"" + string + "\"]/versionnumber"));
        if (System.getProperty("os.name").indexOf("Windows") == -1) {
            object = this.config.getSetting("/test[" + n + "]/version[@role=\"" + string + "\"]/versionnumber");
            float f = Float.parseFloat(((String)object).substring(0, 3));
            String string3 = (double)f >= 7.5 ? "new" : "old";
            vector.add("-o");
            vector.add(this.config.getSetting("/settings/unix[@concept=\"" + string3 + "\"]/user"));
            vector.add("-g");
            vector.add(this.config.getSetting("/settings/unix[@concept=\"" + string3 + "\"]/group"));
            Logger.log(Logger.DEBUG, "Detected version that needs " + string3 + " security concept.");
        }
        object = new Executor(vector.toArray(new String[0]), null, file, null);
        ((Executor)object).setLogfile(this.createLogFileName(n, "installDB-" + string + ".log"));
        int n2 = ((Executor)object).run();
        this.saveLogs(n);
        return n2;
    }

    private File createLogFileName(int n, String string) throws IOException {
        DecimalFormat decimalFormat = new DecimalFormat("000");
        File file = new File(this.outputBaseDir.getAbsolutePath() + File.separator + "testrun" + decimalFormat.format(n) + File.separator);
        if (!file.exists()) {
            file.mkdirs();
        }
        return new File(file.getAbsolutePath() + File.separator + string);
    }

    public boolean removeLogFiles(int n) {
        DecimalFormat decimalFormat = new DecimalFormat("000");
        File file = new File(this.outputBaseDir.getAbsolutePath() + File.separator + "testrun" + decimalFormat.format(n));
        if (file.exists()) {
            return this.deltree(file);
        }
        return false;
    }

    public int startXServer() throws SettingNotFoundException, IOException {
        String[] stringArray = System.getProperty("os.name").indexOf("Windows") == -1 ? new String[]{this.config.getSetting("/settings/directories/indep_prog") + "/bin/x_server", "start"} : new String[]{this.config.getSetting("/settings/directories/indep_prog") + "/bin/x_server", "start"};
        Executor executor = new Executor(stringArray);
        return executor.run();
    }

    public int stopXServer() throws SettingNotFoundException, IOException {
        String[] stringArray = System.getProperty("os.name").indexOf("Windows") == -1 ? new String[]{this.config.getSetting("/settings/directories/indep_prog") + "/bin/x_server", "stop"} : new String[]{this.config.getSetting("/settings/directories/indep_prog") + "/bin/x_server", "stop"};
        Executor executor = new Executor(stringArray);
        return executor.run();
    }

    public int updateDB(int n, String string) throws SettingNotFoundException, IOException {
        int n2;
        File file = this.getUnpackDir(n, string);
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        String string3 = file.getCanonicalPath();
        vector.add(string3 + File.separator + "SDBUPD");
        vector.add("-b");
        vector.add("-d");
        vector.add("TESTDB");
        vector.add("-u");
        vector.add("dbm,dbm");
        if (System.getProperty("os.name").indexOf("Windows") == -1) {
            boolean bl = true;
            try {
                this.config.getSetting("/test[" + n + "]/updateNewSecurityConcept");
            }
            catch (SettingNotFoundException settingNotFoundException) {
                bl = false;
            }
            if (bl) {
                vector.add("-o");
                vector.add(this.config.getSetting("/settings/unix[@concept=\"new\"]/user"));
                vector.add("-g");
                vector.add(this.config.getSetting("/settings/unix[@concept=\"new\"]/group"));
            }
            n2 = 1;
            try {
                this.config.getSetting("/test[" + n + "]/updateNewSecurityConceptBackup");
            }
            catch (SettingNotFoundException settingNotFoundException) {
                n2 = 0;
            }
            if (n2 != 0) {
                string2 = this.config.getSetting("/settings/unix[@concept=\"new\"]/group") + "\n" + this.config.getSetting("/settings/unix[@concept=\"new\"]/user") + "\n";
                vector.remove("-b");
            }
        }
        Executor executor = new Executor(vector.toArray(new String[0]), null, file, string2);
        executor.setLogfile(this.createLogFileName(n, "updateDB.log"));
        n2 = executor.run();
        this.saveLogs(n);
        return n2;
    }

    public void saveLogs(int n) throws SettingNotFoundException, IOException {
        File file = new File(this.config.getSetting("/settings/directories/indep_data") + File.separator + "wrk");
        SAPDBLogsFilter sAPDBLogsFilter = new SAPDBLogsFilter();
        File[] fileArray = file.listFiles(sAPDBLogsFilter);
        int n2 = 0;
        if (fileArray != null) {
            int n3 = 0;
            while (n3 < fileArray.length) {
                int n4;
                String string;
                char[] cArray = new char[1024];
                FileReader fileReader = new FileReader(fileArray[n3]);
                if (fileArray[n3].getName().indexOf("Update_install") != -1) {
                    string = "updateDB-internal.log";
                } else if (fileArray[n3].getName().indexOf("Server_install") != -1) {
                    string = "installDB-" + (n2 < 1 ? "source" : "brick" + n2) + "-internal.log";
                    ++n2;
                } else {
                    string = fileArray[n3].getName().indexOf("Uninstall_install") != -1 ? "uninstallDB-internal.log" : fileArray[n3].getName();
                }
                File file2 = this.createLogFileName(n, string);
                FileWriter fileWriter = new FileWriter(file2);
                while ((n4 = fileReader.read(cArray)) != -1) {
                    fileWriter.write(cArray, 0, n4);
                }
                fileReader.close();
                fileWriter.close();
                fileArray[n3].delete();
                ++n3;
            }
        }
    }

    public int uninstallDB(int n) throws SettingNotFoundException, IOException {
        this.saveLogs(n);
        Vector<String> vector = new Vector<String>();
        String string = new String("y\n");
        vector.add(new File(this.config.getSetting("/settings/directories/indep_prog") + File.separator + "bin" + File.separator + "sdbuninst").getCanonicalPath());
        vector.add("-all");
        Executor executor = new Executor(vector.toArray(new String[0]), null, null, string);
        executor.setLogfile(this.createLogFileName(n, "uninstallDB.log"));
        int n2 = executor.run();
        return n2;
    }

    public boolean deltree(File file) {
        boolean bl = false;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                bl = this.deltree(fileArray[n]);
                ++n;
            }
            return file.delete() && bl;
        }
        return file.delete();
    }

    public void addTempFile(File file) {
        this.tempfiles.add(file);
    }

    public boolean forgetTempFile(File file) {
        int n = 0;
        while (n < this.tempfiles.size()) {
            if (((File)this.tempfiles.get(n)).equals(file)) {
                this.tempfiles.remove(n);
                return true;
            }
            ++n;
        }
        return false;
    }

    public void deleteTempFiles() {
        int n = 0;
        while (n < this.tempfiles.size()) {
            this.deltree((File)this.tempfiles.get(n));
            ++n;
        }
    }

    public String createLogfileZip(Vector vector, String string) throws IOException {
        if (Logger.out != System.out) {
            Logger.log(Logger.VERBOSE, "Logfile will be closed now and reset to System.out.");
            UpgradeTest.resetStartDateTime();
            Logger.log(Logger.STANDARD, "========================================");
            Logger.log(Logger.STANDARD, "== Logfile finished on " + UpgradeTest.getStartDateTime() + " ==");
            Logger.log(Logger.STANDARD, "========================================");
            Logger.out.close();
            Logger.out = System.out;
            Logger.log(Logger.STANDARD, "Logfile has been closed, logstream reset to standard out again.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + File.separator + "UpgradeTest_");
        stringBuffer.append(UpgradeTest.getStartDateTime() + "_");
        if (!TestCase.getParameterString((String)"autocreatefor", (String)"").equals("")) {
            stringBuffer.append(TestCase.getParameterString((String)"autocreatefor", (String)"") + "_");
        } else {
            stringBuffer.append("manual_");
        }
        stringBuffer.append(TestCase.getParameterString((String)"os", (String)"") + TestCase.getParameterString((String)"bit", (String)"") + ".zip");
        File file = new File(stringBuffer.toString());
        Zipper zipper = new Zipper(file);
        zipper.setRootDirectory(new File(string));
        zipper.setDeleteSourceFiles(true);
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return !file.getName().endsWith(".zip");
            }
        };
        File[] fileArray = this.outputBaseDir.listFiles(fileFilter);
        zipper.addFiles(fileArray);
        fileArray = new File(System.getProperty("user.dir")).listFiles(new SAPDBLogsFilter());
        zipper.addFiles(fileArray);
        try {
            zipper.zip();
        }
        catch (Exception exception) {
            Logger.error("Failed to create a zipfile with the logs " + exception.getMessage());
            return null;
        }
        this.deltree(this.outputBaseDir);
        return file.getAbsolutePath();
    }

    private String createReport(Vector vector, File file) throws SettingNotFoundException {
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.getName().startsWith("testrun") && !file.getName().endsWith(".zip");
            }
        };
        File[] fileArray = file.listFiles(fileFilter);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html xmlns='http://www.w3.org/1999/xhtml'>\n<head><title>UpgradeTest at " + UpgradeTest.getStartDateTime());
        stringBuffer.append("</title></head>\n");
        stringBuffer.append("<body>\n");
        stringBuffer.append("<h1>UpgradeTest at " + UpgradeTest.getStartDateTime() + "</h1>\n");
        stringBuffer.append("On: <ul>\n");
        stringBuffer.append("<li>OS: " + this.config.getSetting("/environment/os") + "</li>\n");
        stringBuffer.append("<li>Bit: " + this.config.getSetting("/environment/bit") + "</li>\n");
        stringBuffer.append("<li>uname: " + this.config.getSetting("/environment/platform") + "</li>\n");
        stringBuffer.append("</ul>\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("<ul>\n");
        stringBuffer.append("<li><a href='#internal'>Internal Log</a></li>\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            int n2 = Integer.parseInt(file2.getName().substring(7));
            String string = (String)vector.get(n2);
            if (!string.endsWith("- skipped")) {
                stringBuffer.append("<li>\n");
                stringBuffer.append("<h3>[");
                stringBuffer.append(this.config.getSetting("/test[" + n2 + "]/version[@role=\"source\"]/versionnumber"));
                if (this.config.getSetting("/test[" + n2 + "]/version[@role=\"source\"]/versionnumber/@state") != null) {
                    stringBuffer.append(this.config.getSetting("/test[" + n2 + "]/version[@role=\"source\"]/versionnumber/@state"));
                }
                stringBuffer.append("] --&gt; [");
                stringBuffer.append(this.config.getSetting("/test[" + n2 + "]/version[@role=\"target\"]/versionnumber"));
                if (this.config.getSetting("/test[" + n2 + "]/version[@role=\"target\"]/versionnumber/@state") != null) {
                    stringBuffer.append(this.config.getSetting("/test[" + n2 + "]/version[@role=\"target\"]/versionnumber/@state"));
                }
                stringBuffer.append("]</h3>\n");
                stringBuffer.append("<ul>\n");
                stringBuffer.append("<li>");
                stringBuffer.append("</li>\n");
                stringBuffer.append("<li></li>\n");
                stringBuffer.append("<li></li>\n");
                stringBuffer.append("<li></li>\n");
                stringBuffer.append("<li></li>\n");
                stringBuffer.append("<li></li>\n");
                stringBuffer.append("</ul>\n");
            }
            ++n;
        }
        stringBuffer.append("\n");
        stringBuffer.append("</body>");
        return null;
    }

    private class SAPDBLogsFilter
    implements FilenameFilter {
        private SAPDBLogsFilter() {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(".log") || string.equals("xserver.prt") || string.equals("knldiag") || string.equals("dbmsrv.prt");
        }
    }
}

