/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaNamespaceSupport;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarResolver;
import org.apache.xerces.impl.xs.XSMessageFormatter;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAttributeGroupTraverser;
import org.apache.xerces.impl.xs.traversers.XSDAttributeTraverser;
import org.apache.xerces.impl.xs.traversers.XSDComplexTypeTraverser;
import org.apache.xerces.impl.xs.traversers.XSDElementTraverser;
import org.apache.xerces.impl.xs.traversers.XSDGroupTraverser;
import org.apache.xerces.impl.xs.traversers.XSDKeyrefTraverser;
import org.apache.xerces.impl.xs.traversers.XSDNotationTraverser;
import org.apache.xerces.impl.xs.traversers.XSDSimpleTypeTraverser;
import org.apache.xerces.impl.xs.traversers.XSDUniqueOrKeyTraverser;
import org.apache.xerces.impl.xs.traversers.XSDWildcardTraverser;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.util.EntityResolverWrapper;
import org.apache.xerces.util.SymbolHash;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XSDHandler {
    static final int ATTRIBUTE_TYPE = 1;
    static final int ATTRIBUTEGROUP_TYPE = 2;
    static final int ELEMENT_TYPE = 3;
    static final int GROUP_TYPE = 4;
    static final int IDENTITYCONSTRAINT_TYPE = 5;
    static final int NOTATION_TYPE = 6;
    static final int TYPEDECL_TYPE = 7;
    public static final String REDEF_IDENTIFIER = "_fn3dktizrknc9pi";
    public String EMPTY_STRING;
    protected Hashtable fNotationRegistry = new Hashtable();
    private Hashtable fUnparsedAttributeRegistry = new Hashtable();
    private Hashtable fUnparsedAttributeGroupRegistry = new Hashtable();
    private Hashtable fUnparsedElementRegistry = new Hashtable();
    private Hashtable fUnparsedGroupRegistry = new Hashtable();
    private Hashtable fUnparsedIdentityConstraintRegistry = new Hashtable();
    private Hashtable fUnparsedNotationRegistry = new Hashtable();
    private Hashtable fUnparsedTypeRegistry = new Hashtable();
    private Hashtable fXSDocumentInfoRegistry = new Hashtable();
    private Hashtable fDependencyMap = new Hashtable();
    private SymbolHash fTraversed = new SymbolHash();
    private XSDocumentInfo fRoot = null;
    private Hashtable fDoc2XSDocumentMap = new Hashtable();
    private Hashtable fRedefine2XSDMap = new Hashtable();
    private Hashtable fRedefinedRestrictedAttributeGroupRegistry = new Hashtable();
    private Hashtable fRedefinedRestrictedGroupRegistry = new Hashtable();
    private boolean fLastSchemaWasDuplicate;
    private XMLErrorReporter fErrorReporter;
    private XSAttributeChecker fAttributeChecker;
    private SubstitutionGroupHandler fSubGroupHandler;
    private XMLEntityResolver fEntityResolver;
    private SymbolTable fSymbolTable;
    private XSGrammarResolver fGrammarResolver;
    XSDAttributeGroupTraverser fAttributeGroupTraverser;
    XSDAttributeTraverser fAttributeTraverser;
    XSDComplexTypeTraverser fComplexTypeTraverser;
    XSDElementTraverser fElementTraverser;
    XSDGroupTraverser fGroupTraverser;
    XSDKeyrefTraverser fKeyrefTraverser;
    XSDNotationTraverser fNotationTraverser;
    XSDSimpleTypeTraverser fSimpleTypeTraverser;
    XSDUniqueOrKeyTraverser fUniqueOrKeyTraverser;
    XSDWildcardTraverser fWildCardTraverser;
    DOMParser fSchemaParser;
    private static final int INIT_STACK_SIZE = 30;
    private static final int INC_STACK_SIZE = 10;
    private int fLocalElemStackPos;
    private XSParticleDecl[] fParticle;
    private Element[] fLocalElementDecl;
    private int[] fAllContext;
    private String[][] fLocalElemNamespaceContext;
    private static final int INIT_KEYREF_STACK = 2;
    private static final int INC_KEYREF_STACK_AMOUNT = 2;
    private int fKeyrefStackPos;
    private Element[] fKeyrefs;
    private XSElementDecl[] fKeyrefElems;
    private String[][] fKeyrefNamespaceContext;
    private static final String[] COMP_TYPE = new String[]{null, "attribute declaration", "attribute group", "elment declaration", "group", "identity constraint", "notation", "type definition"};

    public XSDHandler(XSGrammarResolver gResolver, SubstitutionGroupHandler subGroupHandler) {
        this.fGrammarResolver = gResolver;
        this.fSubGroupHandler = subGroupHandler;
        this.fSchemaParser = new DOMParser(new StandardParserConfiguration(new SchemaSymbols.SchemaSymbolTable()));
        try {
            this.fSchemaParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.createTraversers();
    }

    public SchemaGrammar parseSchema(String schemaNamespace, String schemaHint) {
        Document schemaRoot = this.getSchema(schemaNamespace, schemaHint);
        if (schemaRoot == null) {
            this.reportGenericSchemaError("Could not locate a schema document corresponding to grammar " + schemaNamespace);
            return null;
        }
        if (schemaNamespace != null) {
            schemaNamespace = this.fSymbolTable.addSymbol(schemaNamespace);
        }
        this.fRoot = this.constructTrees(schemaRoot, schemaNamespace);
        if (this.fRoot == null) {
            this.reportGenericSchemaError("Could not locate a schema document");
            return null;
        }
        this.buildGlobalNameRegistries();
        this.traverseSchemas();
        this.traverseLocalElements();
        this.resolveKeyRefs();
        return this.fGrammarResolver.getGrammar(this.fRoot.fTargetNamespace);
    }

    protected XSDocumentInfo constructTrees(Document schemaRoot, String callerTNS) {
        if (schemaRoot == null) {
            return null;
        }
        XSDocumentInfo currSchemaInfo = new XSDocumentInfo(schemaRoot, this.fAttributeChecker, this.fSymbolTable);
        this.fDoc2XSDocumentMap.put(schemaRoot, currSchemaInfo);
        if (callerTNS != null) {
            if (currSchemaInfo.fTargetNamespace == null) {
                currSchemaInfo.fTargetNamespace = callerTNS;
                currSchemaInfo.fIsChameleonSchema = true;
            } else if (callerTNS != currSchemaInfo.fTargetNamespace) {
                this.reportSchemaError("src-include.2", new Object[]{callerTNS, currSchemaInfo.fTargetNamespace});
            }
        }
        SchemaGrammar sg = null;
        sg = this.fGrammarResolver.getGrammar(currSchemaInfo.fTargetNamespace);
        if (sg == null) {
            sg = new SchemaGrammar(this.fSymbolTable, currSchemaInfo.fTargetNamespace);
            this.fGrammarResolver.putGrammar(sg);
        }
        Vector<XSDocumentInfo> dependencies = new Vector<XSDocumentInfo>();
        Element rootNode = DOMUtil.getRoot(schemaRoot);
        Document newSchemaRoot = null;
        Element child = DOMUtil.getFirstChildElement(rootNode);
        while (child != null) {
            String schemaNamespace = null;
            String schemaHint = null;
            String localName = DOMUtil.getLocalName(child);
            if (!localName.equals(SchemaSymbols.ELT_ANNOTATION)) {
                Object[] includeAttrs;
                if (localName.equals(SchemaSymbols.ELT_IMPORT)) {
                    includeAttrs = this.fAttributeChecker.checkAttributes(child, true, currSchemaInfo);
                    schemaHint = (String)includeAttrs[XSAttributeChecker.ATTIDX_SCHEMALOCATION];
                    schemaNamespace = (String)includeAttrs[XSAttributeChecker.ATTIDX_NAMESPACE];
                    if (schemaNamespace != null) {
                        schemaNamespace = this.fSymbolTable.addSymbol(schemaNamespace);
                    }
                    if (schemaNamespace == currSchemaInfo.fTargetNamespace) {
                        this.reportSchemaError("src-import.1.1", new Object[]{schemaNamespace});
                    }
                    this.fAttributeChecker.returnAttrArray(includeAttrs, currSchemaInfo);
                    newSchemaRoot = this.getSchema(schemaNamespace, schemaHint);
                } else {
                    if (!localName.equals(SchemaSymbols.ELT_INCLUDE) && !localName.equals(SchemaSymbols.ELT_REDEFINE)) break;
                    includeAttrs = this.fAttributeChecker.checkAttributes(child, true, currSchemaInfo);
                    schemaHint = (String)includeAttrs[XSAttributeChecker.ATTIDX_SCHEMALOCATION];
                    this.fAttributeChecker.returnAttrArray(includeAttrs, currSchemaInfo);
                    if (schemaHint == null) {
                        this.reportGenericSchemaError("schemaLocation attribute must appear in <include> and <redefine>");
                    }
                    newSchemaRoot = this.getSchema(null, schemaHint);
                    schemaNamespace = currSchemaInfo.fTargetNamespace;
                }
                XSDocumentInfo newSchemaInfo = null;
                newSchemaInfo = this.fLastSchemaWasDuplicate ? (XSDocumentInfo)this.fDoc2XSDocumentMap.get(newSchemaRoot) : this.constructTrees(newSchemaRoot, schemaNamespace);
                if (localName.equals(SchemaSymbols.ELT_REDEFINE) && newSchemaInfo != null) {
                    this.fRedefine2XSDMap.put(child, newSchemaInfo);
                }
                if (newSchemaRoot != null) {
                    dependencies.addElement(newSchemaInfo);
                    newSchemaRoot = null;
                }
            }
            child = DOMUtil.getNextSiblingElement(child);
        }
        this.fDependencyMap.put(currSchemaInfo, dependencies);
        return currSchemaInfo;
    }

    protected void buildGlobalNameRegistries() {
        Stack<XSDocumentInfo> schemasToProcess = new Stack<XSDocumentInfo>();
        schemasToProcess.push(this.fRoot);
        while (!schemasToProcess.empty()) {
            XSDocumentInfo currSchemaDoc = (XSDocumentInfo)schemasToProcess.pop();
            Document currDoc = currSchemaDoc.fSchemaDoc;
            if (DOMUtil.isHidden(currDoc)) continue;
            Element currRoot = DOMUtil.getRoot(currDoc);
            boolean dependenciesCanOccur = true;
            Element globalComp = DOMUtil.getFirstChildElement(currRoot);
            while (globalComp != null) {
                if (!DOMUtil.getLocalName(globalComp).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    if (DOMUtil.getLocalName(globalComp).equals(SchemaSymbols.ELT_INCLUDE) || DOMUtil.getLocalName(globalComp).equals(SchemaSymbols.ELT_IMPORT)) {
                        if (!dependenciesCanOccur) {
                            this.reportSchemaError("sch-props-correct.1", new Object[]{DOMUtil.getLocalName(globalComp)});
                        }
                        DOMUtil.setHidden(globalComp);
                    } else if (DOMUtil.getLocalName(globalComp).equals(SchemaSymbols.ELT_REDEFINE)) {
                        if (!dependenciesCanOccur) {
                            this.reportSchemaError("sch-props-correct.1", new Object[]{DOMUtil.getLocalName(globalComp)});
                        }
                        Element redefineComp = DOMUtil.getFirstChildElement(globalComp);
                        while (redefineComp != null) {
                            String lName = DOMUtil.getAttrValue(redefineComp, SchemaSymbols.ATT_NAME);
                            if (lName.length() != 0) {
                                String targetLName;
                                String qName = currSchemaDoc.fTargetNamespace == null ? "," + lName : currSchemaDoc.fTargetNamespace + "," + lName;
                                String componentType = DOMUtil.getLocalName(redefineComp);
                                if (componentType.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP)) {
                                    this.checkForDuplicateNames(qName, this.fUnparsedAttributeGroupRegistry, redefineComp, currSchemaDoc);
                                    targetLName = DOMUtil.getAttrValue(redefineComp, SchemaSymbols.ATT_NAME) + REDEF_IDENTIFIER;
                                    this.renameRedefiningComponents(currSchemaDoc, redefineComp, SchemaSymbols.ELT_ATTRIBUTEGROUP, lName, targetLName);
                                } else if (componentType.equals(SchemaSymbols.ELT_COMPLEXTYPE) || componentType.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                                    this.checkForDuplicateNames(qName, this.fUnparsedTypeRegistry, redefineComp, currSchemaDoc);
                                    targetLName = DOMUtil.getAttrValue(redefineComp, SchemaSymbols.ATT_NAME) + REDEF_IDENTIFIER;
                                    if (componentType.equals(SchemaSymbols.ELT_COMPLEXTYPE)) {
                                        this.renameRedefiningComponents(currSchemaDoc, redefineComp, SchemaSymbols.ELT_COMPLEXTYPE, lName, targetLName);
                                    } else {
                                        this.renameRedefiningComponents(currSchemaDoc, redefineComp, SchemaSymbols.ELT_SIMPLETYPE, lName, targetLName);
                                    }
                                } else if (componentType.equals(SchemaSymbols.ELT_GROUP)) {
                                    this.checkForDuplicateNames(qName, this.fUnparsedGroupRegistry, redefineComp, currSchemaDoc);
                                    targetLName = DOMUtil.getAttrValue(redefineComp, SchemaSymbols.ATT_NAME) + REDEF_IDENTIFIER;
                                    this.renameRedefiningComponents(currSchemaDoc, redefineComp, SchemaSymbols.ELT_GROUP, lName, targetLName);
                                }
                            }
                            redefineComp = DOMUtil.getNextSiblingElement(redefineComp);
                        }
                    } else {
                        dependenciesCanOccur = false;
                        String lName = DOMUtil.getAttrValue(globalComp, SchemaSymbols.ATT_NAME);
                        if (lName.length() != 0) {
                            String qName = currSchemaDoc.fTargetNamespace == null ? "," + lName : currSchemaDoc.fTargetNamespace + "," + lName;
                            String componentType = DOMUtil.getLocalName(globalComp);
                            if (componentType.equals(SchemaSymbols.ELT_ATTRIBUTE)) {
                                this.checkForDuplicateNames(qName, this.fUnparsedAttributeRegistry, globalComp, currSchemaDoc);
                            } else if (componentType.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP)) {
                                this.checkForDuplicateNames(qName, this.fUnparsedAttributeGroupRegistry, globalComp, currSchemaDoc);
                            } else if (componentType.equals(SchemaSymbols.ELT_COMPLEXTYPE) || componentType.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                                this.checkForDuplicateNames(qName, this.fUnparsedTypeRegistry, globalComp, currSchemaDoc);
                            } else if (componentType.equals(SchemaSymbols.ELT_ELEMENT)) {
                                this.checkForDuplicateNames(qName, this.fUnparsedElementRegistry, globalComp, currSchemaDoc);
                            } else if (componentType.equals(SchemaSymbols.ELT_GROUP)) {
                                this.checkForDuplicateNames(qName, this.fUnparsedGroupRegistry, globalComp, currSchemaDoc);
                            } else if (componentType.equals(SchemaSymbols.ELT_NOTATION)) {
                                this.checkForDuplicateNames(qName, this.fUnparsedNotationRegistry, globalComp, currSchemaDoc);
                            }
                        }
                    }
                }
                globalComp = DOMUtil.getNextSiblingElement(globalComp);
            }
            DOMUtil.setHidden(currDoc);
            Vector currSchemaDepends = (Vector)this.fDependencyMap.get(currSchemaDoc);
            int i = 0;
            while (i < currSchemaDepends.size()) {
                schemasToProcess.push((XSDocumentInfo)currSchemaDepends.elementAt(i));
                ++i;
            }
        }
    }

    protected void traverseSchemas() {
        this.setSchemasVisible(this.fRoot);
        Stack<XSDocumentInfo> schemasToProcess = new Stack<XSDocumentInfo>();
        schemasToProcess.push(this.fRoot);
        while (!schemasToProcess.empty()) {
            XSDocumentInfo currSchemaDoc = (XSDocumentInfo)schemasToProcess.pop();
            Document currDoc = currSchemaDoc.fSchemaDoc;
            SchemaGrammar currSG = this.fGrammarResolver.getGrammar(currSchemaDoc.fTargetNamespace);
            if (DOMUtil.isHidden(currDoc)) continue;
            Element currRoot = DOMUtil.getRoot(currDoc);
            Element globalComp = DOMUtil.getFirstVisibleChildElement(currRoot);
            while (globalComp != null) {
                DOMUtil.setHidden(globalComp);
                String componentType = DOMUtil.getLocalName(globalComp);
                if (DOMUtil.getLocalName(globalComp).equals(SchemaSymbols.ELT_REDEFINE)) {
                    Element redefinedComp = DOMUtil.getFirstVisibleChildElement(globalComp);
                    while (redefinedComp != null) {
                        String redefinedComponentType = DOMUtil.getLocalName(redefinedComp);
                        DOMUtil.setHidden(redefinedComp);
                        if (redefinedComponentType.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP)) {
                            this.fAttributeGroupTraverser.traverseGlobal(redefinedComp, currSchemaDoc, currSG);
                        } else if (redefinedComponentType.equals(SchemaSymbols.ELT_COMPLEXTYPE)) {
                            this.fComplexTypeTraverser.traverseGlobal(redefinedComp, currSchemaDoc, currSG);
                        } else if (redefinedComponentType.equals(SchemaSymbols.ELT_GROUP)) {
                            this.fGroupTraverser.traverseGlobal(redefinedComp, currSchemaDoc, currSG);
                        } else if (redefinedComponentType.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                            this.fSimpleTypeTraverser.traverseGlobal(redefinedComp, currSchemaDoc, currSG);
                        } else if (redefinedComponentType.equals(SchemaSymbols.ELT_ANNOTATION)) {
                            this.fElementTraverser.traverseAnnotationDecl(redefinedComp, null, true, currSchemaDoc);
                        } else {
                            this.reportSchemaError("src-redefine", new Object[]{componentType});
                        }
                        redefinedComp = DOMUtil.getNextVisibleSiblingElement(redefinedComp);
                    }
                } else if (componentType.equals(SchemaSymbols.ELT_ATTRIBUTE)) {
                    this.fAttributeTraverser.traverseGlobal(globalComp, currSchemaDoc, currSG);
                } else if (componentType.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP)) {
                    this.fAttributeGroupTraverser.traverseGlobal(globalComp, currSchemaDoc, currSG);
                } else if (componentType.equals(SchemaSymbols.ELT_COMPLEXTYPE)) {
                    this.fComplexTypeTraverser.traverseGlobal(globalComp, currSchemaDoc, currSG);
                } else if (componentType.equals(SchemaSymbols.ELT_ELEMENT)) {
                    this.fElementTraverser.traverseGlobal(globalComp, currSchemaDoc, currSG);
                } else if (componentType.equals(SchemaSymbols.ELT_GROUP)) {
                    this.fGroupTraverser.traverseGlobal(globalComp, currSchemaDoc, currSG);
                } else if (componentType.equals(SchemaSymbols.ELT_NOTATION)) {
                    this.fNotationTraverser.traverse(globalComp, currSchemaDoc, currSG);
                } else if (componentType.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                    this.fSimpleTypeTraverser.traverseGlobal(globalComp, currSchemaDoc, currSG);
                } else if (componentType.equals(SchemaSymbols.ELT_ANNOTATION)) {
                    this.fElementTraverser.traverseAnnotationDecl(globalComp, null, true, currSchemaDoc);
                } else {
                    this.reportSchemaError("sch-props-correct.1", new Object[]{DOMUtil.getLocalName(globalComp)});
                }
                globalComp = DOMUtil.getNextVisibleSiblingElement(globalComp);
            }
            DOMUtil.setHidden(currDoc);
            Vector currSchemaDepends = (Vector)this.fDependencyMap.get(currSchemaDoc);
            int i = 0;
            while (i < currSchemaDepends.size()) {
                schemasToProcess.push((XSDocumentInfo)currSchemaDepends.elementAt(i));
                ++i;
            }
        }
    }

    protected Object getGlobalDecl(XSDocumentInfo currSchema, int declType, QName declToTraverse) {
        XSTypeDecl retObj;
        if (declToTraverse.uri != null && declToTraverse.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && declType == 7 && (retObj = SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl(declToTraverse.localpart)) != null) {
            return retObj;
        }
        XSDocumentInfo schemaWithDecl = null;
        Element decl = null;
        String declKey = declToTraverse.uri == null ? "," + declToTraverse.localpart : declToTraverse.uri + "," + declToTraverse.localpart;
        switch (declType) {
            case 1: {
                decl = (Element)this.fUnparsedAttributeRegistry.get(declKey);
                break;
            }
            case 2: {
                decl = (Element)this.fUnparsedAttributeGroupRegistry.get(declKey);
                break;
            }
            case 3: {
                decl = (Element)this.fUnparsedElementRegistry.get(declKey);
                break;
            }
            case 4: {
                decl = (Element)this.fUnparsedGroupRegistry.get(declKey);
                break;
            }
            case 5: {
                decl = (Element)this.fUnparsedIdentityConstraintRegistry.get(declKey);
                break;
            }
            case 6: {
                decl = (Element)this.fUnparsedNotationRegistry.get(declKey);
                break;
            }
            case 7: {
                decl = (Element)this.fUnparsedTypeRegistry.get(declKey);
                break;
            }
            default: {
                this.reportGenericSchemaError("XSDHandler asked to locate component of type " + declType + "; it does not recognize this type (internal error!)");
            }
        }
        if (decl == null) {
            this.reportSchemaError("src-resolve", new Object[]{declToTraverse.rawname, COMP_TYPE[declType]});
            return null;
        }
        schemaWithDecl = this.findXSDocumentForDecl(currSchema, decl);
        if (schemaWithDecl == null) {
            this.reportSchemaError("src-resolve.4", new Object[]{currSchema, declToTraverse.uri});
            return null;
        }
        SchemaGrammar sGrammar = this.fGrammarResolver.getGrammar(schemaWithDecl.fTargetNamespace);
        Object retObj2 = null;
        switch (declType) {
            case 1: {
                retObj2 = sGrammar.getGlobalAttributeDecl(declToTraverse.localpart);
                break;
            }
            case 2: {
                retObj2 = sGrammar.getGlobalAttributeGroupDecl(declToTraverse.localpart);
                break;
            }
            case 3: {
                retObj2 = sGrammar.getGlobalElementDecl(declToTraverse.localpart);
                break;
            }
            case 4: {
                retObj2 = sGrammar.getGlobalGroupDecl(declToTraverse.localpart);
                break;
            }
            case 5: {
                retObj2 = sGrammar.getIDConstraintDecl(declToTraverse.localpart);
                break;
            }
            case 6: {
                retObj2 = sGrammar.getNotationDecl(declToTraverse.localpart);
                break;
            }
            case 7: {
                retObj2 = sGrammar.getGlobalTypeDecl(declToTraverse.localpart);
            }
        }
        if (retObj2 != null) {
            return retObj2;
        }
        if (DOMUtil.isHidden(decl)) {
            this.reportGenericSchemaError("Circular reference detected in schema component named " + declToTraverse.prefix + ":" + declToTraverse.localpart);
            return null;
        }
        DOMUtil.setHidden(decl);
        schemaWithDecl.backupNSSupport();
        switch (declType) {
            case 1: {
                retObj2 = this.fAttributeTraverser.traverseGlobal(decl, schemaWithDecl, sGrammar);
                break;
            }
            case 2: {
                retObj2 = this.fAttributeGroupTraverser.traverseGlobal(decl, schemaWithDecl, sGrammar);
                break;
            }
            case 3: {
                retObj2 = this.fElementTraverser.traverseGlobal(decl, schemaWithDecl, sGrammar);
                break;
            }
            case 4: {
                retObj2 = this.fGroupTraverser.traverseGlobal(decl, schemaWithDecl, sGrammar);
                break;
            }
            case 5: {
                retObj2 = null;
                break;
            }
            case 6: {
                retObj2 = this.fNotationTraverser.traverse(decl, schemaWithDecl, sGrammar);
                break;
            }
            case 7: {
                retObj2 = DOMUtil.getLocalName(decl).equals(SchemaSymbols.ELT_COMPLEXTYPE) ? this.fComplexTypeTraverser.traverseGlobal(decl, schemaWithDecl, sGrammar) : this.fSimpleTypeTraverser.traverseGlobal(decl, schemaWithDecl, sGrammar);
            }
        }
        schemaWithDecl.restoreNSSupport();
        return retObj2;
    }

    protected void resolveKeyRefs() {
        int i = 0;
        while (i < this.fKeyrefStackPos) {
            Document keyrefDoc = DOMUtil.getDocument(this.fKeyrefs[i]);
            XSDocumentInfo keyrefSchemaDoc = (XSDocumentInfo)this.fDoc2XSDocumentMap.get(keyrefDoc);
            keyrefSchemaDoc.fNamespaceSupport.makeGlobal();
            keyrefSchemaDoc.fNamespaceSupport.setEffectiveContext(this.fKeyrefNamespaceContext[i]);
            SchemaGrammar keyrefGrammar = this.fGrammarResolver.getGrammar(keyrefSchemaDoc.fTargetNamespace);
            this.fKeyrefTraverser.traverse(this.fKeyrefs[i], this.fKeyrefElems[i], keyrefSchemaDoc, keyrefGrammar);
            ++i;
        }
    }

    protected Hashtable getIDRegistry() {
        return this.fUnparsedIdentityConstraintRegistry;
    }

    protected void storeKeyRef(Element keyrefToStore, XSDocumentInfo schemaDoc, XSElementDecl currElemDecl) {
        String keyrefName = DOMUtil.getAttrValue(keyrefToStore, SchemaSymbols.ATT_NAME);
        if (keyrefName.length() != 0) {
            String keyrefQName = schemaDoc.fTargetNamespace == null ? "," + keyrefName : schemaDoc.fTargetNamespace + "," + keyrefName;
            this.checkForDuplicateNames(keyrefQName, this.fUnparsedIdentityConstraintRegistry, keyrefToStore, schemaDoc);
        }
        if (this.fKeyrefStackPos == this.fKeyrefs.length) {
            Element[] elemArray = new Element[this.fKeyrefStackPos + 2];
            System.arraycopy(this.fKeyrefs, 0, elemArray, 0, this.fKeyrefStackPos);
            this.fKeyrefs = elemArray;
            XSElementDecl[] declArray = new XSElementDecl[this.fKeyrefStackPos + 2];
            System.arraycopy(this.fKeyrefElems, 0, declArray, 0, this.fKeyrefStackPos);
            this.fKeyrefElems = declArray;
            String[][] stringArray = new String[this.fKeyrefStackPos + 2][];
            System.arraycopy(this.fKeyrefNamespaceContext, 0, stringArray, 0, this.fKeyrefStackPos);
            this.fKeyrefNamespaceContext = stringArray;
        }
        this.fKeyrefs[this.fKeyrefStackPos] = keyrefToStore;
        this.fKeyrefElems[this.fKeyrefStackPos] = currElemDecl;
        this.fKeyrefNamespaceContext[this.fKeyrefStackPos++] = schemaDoc.fNamespaceSupport.getEffectiveLocalContext();
    }

    private Document getSchema(String schemaNamespace, String schemaHint) {
        XMLInputSource schemaSource = null;
        Document schemaDoc = null;
        try {
            schemaSource = this.fEntityResolver.resolveEntity(schemaNamespace, schemaHint, null);
            if (schemaSource != null && schemaSource.getSystemId() != null) {
                String schemaId;
                StringBuffer schemaIdBuf = new StringBuffer();
                if (schemaSource.getPublicId() != null) {
                    schemaIdBuf.append(schemaSource.getPublicId());
                }
                if (schemaSource.getSystemId() != null) {
                    schemaIdBuf.append(schemaSource.getSystemId());
                }
                if (schemaIdBuf.length() == 0) {
                    schemaIdBuf.append(schemaSource.getBaseSystemId());
                }
                if (this.fTraversed.get(schemaId = this.fSymbolTable.addSymbol(schemaIdBuf.toString())) != null) {
                    this.fLastSchemaWasDuplicate = true;
                    return (Document)this.fTraversed.get(schemaId);
                }
                this.fSchemaParser.reset();
                this.fSchemaParser.parse(schemaSource);
                schemaDoc = this.fSchemaParser.getDocument();
                this.fTraversed.put(schemaId, (Object)schemaDoc);
                this.fLastSchemaWasDuplicate = false;
                return schemaDoc;
            }
        }
        catch (FileNotFoundException ex) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "General", new Object[]{"file not found: " + schemaHint}, (short)0);
        }
        catch (IOException ex) {
            this.reportGenericSchemaError("error reading schema document: " + schemaHint);
        }
        schemaDoc = null;
        this.fLastSchemaWasDuplicate = false;
        return null;
    }

    private void createTraversers() {
        this.fAttributeChecker = new XSAttributeChecker(this);
        this.fAttributeGroupTraverser = new XSDAttributeGroupTraverser(this, this.fAttributeChecker);
        this.fAttributeTraverser = new XSDAttributeTraverser(this, this.fAttributeChecker);
        this.fComplexTypeTraverser = new XSDComplexTypeTraverser(this, this.fAttributeChecker);
        this.fElementTraverser = new XSDElementTraverser(this, this.fAttributeChecker, this.fSubGroupHandler);
        this.fGroupTraverser = new XSDGroupTraverser(this, this.fAttributeChecker);
        this.fKeyrefTraverser = new XSDKeyrefTraverser(this, this.fAttributeChecker);
        this.fNotationTraverser = new XSDNotationTraverser(this, this.fAttributeChecker);
        this.fSimpleTypeTraverser = new XSDSimpleTypeTraverser(this, this.fAttributeChecker);
        this.fUniqueOrKeyTraverser = new XSDUniqueOrKeyTraverser(this, this.fAttributeChecker);
        this.fWildCardTraverser = new XSDWildcardTraverser(this, this.fAttributeChecker);
    }

    public void reset(XMLErrorReporter errorReporter, XMLEntityResolver entityResolver, SymbolTable symbolTable) {
        this.fEntityResolver = entityResolver;
        this.fErrorReporter = errorReporter;
        this.fSymbolTable = symbolTable;
        this.EMPTY_STRING = this.fSymbolTable.addSymbol("");
        try {
            this.fSchemaParser.setProperty("http://apache.org/xml/properties/internal/error-reporter", this.fErrorReporter);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.fUnparsedAttributeRegistry.clear();
        this.fUnparsedAttributeGroupRegistry.clear();
        this.fUnparsedElementRegistry.clear();
        this.fUnparsedGroupRegistry.clear();
        this.fUnparsedIdentityConstraintRegistry.clear();
        this.fUnparsedNotationRegistry.clear();
        this.fUnparsedTypeRegistry.clear();
        this.fXSDocumentInfoRegistry.clear();
        this.fDependencyMap.clear();
        this.fTraversed.clear();
        this.fDoc2XSDocumentMap.clear();
        this.fRedefine2XSDMap.clear();
        this.fRoot = null;
        this.fLastSchemaWasDuplicate = false;
        this.fLocalElemStackPos = 0;
        this.fParticle = new XSParticleDecl[30];
        this.fLocalElementDecl = new Element[30];
        this.fAllContext = new int[30];
        this.fLocalElemNamespaceContext = new String[30][1];
        this.fKeyrefStackPos = 0;
        this.fKeyrefs = new Element[2];
        this.fKeyrefElems = new XSElementDecl[2];
        this.fKeyrefNamespaceContext = new String[2][1];
        this.fAttributeChecker.reset(this.fErrorReporter, this.fSymbolTable);
        this.fAttributeGroupTraverser.reset(this.fErrorReporter, this.fSymbolTable);
        this.fAttributeTraverser.reset(this.fErrorReporter, this.fSymbolTable);
        this.fComplexTypeTraverser.reset(this.fErrorReporter, this.fSymbolTable);
        this.fElementTraverser.reset(this.fErrorReporter, this.fSymbolTable);
        this.fGroupTraverser.reset(this.fErrorReporter, this.fSymbolTable);
        this.fKeyrefTraverser.reset(this.fErrorReporter, this.fSymbolTable);
        this.fNotationTraverser.reset(this.fErrorReporter, this.fSymbolTable);
        this.fSimpleTypeTraverser.reset(this.fErrorReporter, this.fSymbolTable);
        this.fUniqueOrKeyTraverser.reset(this.fErrorReporter, this.fSymbolTable);
        this.fWildCardTraverser.reset(this.fErrorReporter, this.fSymbolTable);
        this.fRedefinedRestrictedAttributeGroupRegistry.clear();
        this.fRedefinedRestrictedGroupRegistry.clear();
    }

    void traverseLocalElements() {
        this.fElementTraverser.fDeferTraversingLocalElements = false;
        int i = 0;
        while (i < this.fLocalElemStackPos) {
            Element currElem = this.fLocalElementDecl[i];
            XSDocumentInfo currSchema = (XSDocumentInfo)this.fDoc2XSDocumentMap.get(DOMUtil.getDocument(currElem));
            SchemaGrammar currGrammar = this.fGrammarResolver.getGrammar(currSchema.fTargetNamespace);
            this.fElementTraverser.traverseLocal(this.fParticle[i], currElem, currSchema, currGrammar, this.fAllContext[i]);
            ++i;
        }
    }

    void fillInLocalElemInfo(Element elmDecl, XSDocumentInfo schemaDoc, int allContextFlags, XSParticleDecl particle) {
        if (this.fParticle.length == this.fLocalElemStackPos) {
            XSParticleDecl[] newStackP = new XSParticleDecl[this.fLocalElemStackPos + 10];
            System.arraycopy(this.fParticle, 0, newStackP, 0, this.fLocalElemStackPos);
            this.fParticle = newStackP;
            Element[] newStackE = new Element[this.fLocalElemStackPos + 10];
            System.arraycopy(this.fLocalElementDecl, 0, newStackE, 0, this.fLocalElemStackPos);
            this.fLocalElementDecl = newStackE;
            int[] newStackI = new int[this.fLocalElemStackPos + 10];
            System.arraycopy(this.fAllContext, 0, newStackI, 0, this.fLocalElemStackPos);
            this.fAllContext = newStackI;
            String[][] newStackN = new String[this.fLocalElemStackPos + 10][];
            System.arraycopy(this.fLocalElemNamespaceContext, 0, newStackN, 0, this.fLocalElemStackPos);
            this.fLocalElemNamespaceContext = newStackN;
        }
        this.fParticle[this.fLocalElemStackPos] = particle;
        this.fLocalElementDecl[this.fLocalElemStackPos] = elmDecl;
        this.fAllContext[this.fLocalElemStackPos] = allContextFlags;
        this.fLocalElemNamespaceContext[this.fLocalElemStackPos++] = schemaDoc.fNamespaceSupport.getEffectiveLocalContext();
    }

    void checkForDuplicateNames(String qName, Hashtable registry, Element currComp, XSDocumentInfo currSchema) {
        Object objElem = null;
        Object v = registry.get(qName);
        objElem = v;
        if (v == null) {
            registry.put(qName, currComp);
        } else {
            Element collidingElem = objElem;
            if (collidingElem == currComp) {
                return;
            }
            Element elemParent = null;
            XSDocumentInfo redefinedSchema = null;
            boolean collidedWithRedefine = true;
            elemParent = DOMUtil.getParent(collidingElem);
            if (DOMUtil.getLocalName(elemParent).equals(SchemaSymbols.ELT_REDEFINE)) {
                redefinedSchema = (XSDocumentInfo)this.fRedefine2XSDMap.get(elemParent);
            } else if (DOMUtil.getLocalName(DOMUtil.getParent(currComp)).equals(SchemaSymbols.ELT_REDEFINE)) {
                redefinedSchema = (XSDocumentInfo)this.fDoc2XSDocumentMap.get(DOMUtil.getDocument(collidingElem));
                collidedWithRedefine = false;
            }
            if (redefinedSchema != null) {
                String newName = qName.substring(qName.lastIndexOf(44) + 1) + REDEF_IDENTIFIER;
                if (redefinedSchema == currSchema) {
                    currComp.setAttribute(SchemaSymbols.ATT_NAME, newName);
                    if (currSchema.fTargetNamespace == null) {
                        registry.put("," + newName, currComp);
                    } else {
                        registry.put(currSchema.fTargetNamespace + "," + newName, currComp);
                    }
                    if (currSchema.fTargetNamespace == null) {
                        this.checkForDuplicateNames("," + newName, registry, currComp, currSchema);
                    } else {
                        this.checkForDuplicateNames(currSchema.fTargetNamespace + "," + newName, registry, currComp, currSchema);
                    }
                } else if (collidedWithRedefine) {
                    if (currSchema.fTargetNamespace == null) {
                        this.checkForDuplicateNames("," + newName, registry, currComp, currSchema);
                    } else {
                        this.checkForDuplicateNames(currSchema.fTargetNamespace + "," + newName, registry, currComp, currSchema);
                    }
                } else {
                    this.reportSchemaError("src-redefine.1", new Object[]{qName});
                }
            } else {
                this.reportSchemaError("sch-props-correct.2", new Object[]{qName});
            }
        }
    }

    protected String resolvePrefixToURI(String prefix) {
        return null;
    }

    private void renameRedefiningComponents(XSDocumentInfo currSchema, Element child, String componentType, String oldName, String newName) {
        SchemaNamespaceSupport currNSMap = currSchema.fNamespaceSupport;
        if (componentType.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
            String processedTypeName = currSchema.fTargetNamespace == null ? "," + oldName : currSchema.fTargetNamespace + "," + oldName;
            Element grandKid = DOMUtil.getFirstChildElement(child);
            if (grandKid == null) {
                this.reportSchemaError("src-redefine.5", null);
            } else {
                String grandKidName = grandKid.getLocalName();
                if (grandKidName.equals(SchemaSymbols.ELT_ANNOTATION)) {
                    grandKid = DOMUtil.getNextSiblingElement(grandKid);
                    grandKidName = grandKid.getLocalName();
                }
                if (grandKid == null) {
                    this.reportSchemaError("src-redefine.5", null);
                } else if (!grandKidName.equals(SchemaSymbols.ELT_RESTRICTION)) {
                    this.reportSchemaError("src-redefine.5", null);
                } else {
                    String derivedBase = grandKid.getAttribute(SchemaSymbols.ATT_BASE);
                    String processedDerivedBase = this.findQName(derivedBase, currSchema);
                    if (!processedTypeName.equals(processedDerivedBase)) {
                        this.reportSchemaError("src-redefine.5", null);
                    } else {
                        int colonptr = derivedBase.indexOf(":");
                        if (colonptr > 0) {
                            grandKid.setAttribute(SchemaSymbols.ATT_BASE, derivedBase.substring(0, colonptr) + ":" + newName);
                        } else {
                            grandKid.setAttribute(SchemaSymbols.ATT_BASE, newName);
                        }
                    }
                }
            }
        } else if (componentType.equals(SchemaSymbols.ELT_COMPLEXTYPE)) {
            String processedTypeName = currSchema.fTargetNamespace == null ? "," + oldName : currSchema.fTargetNamespace + "," + oldName;
            Element grandKid = DOMUtil.getFirstChildElement(child);
            if (grandKid == null) {
                this.reportSchemaError("src-redefine.5", null);
            } else {
                if (grandKid.getLocalName().equals(SchemaSymbols.ELT_ANNOTATION)) {
                    grandKid = DOMUtil.getNextSiblingElement(grandKid);
                }
                if (grandKid == null) {
                    this.reportSchemaError("src-redefine.5", null);
                } else {
                    Element greatGrandKid = DOMUtil.getFirstChildElement(grandKid);
                    if (greatGrandKid == null) {
                        this.reportSchemaError("src-redefine.5", null);
                    } else {
                        String greatGrandKidName = greatGrandKid.getLocalName();
                        if (greatGrandKidName.equals(SchemaSymbols.ELT_ANNOTATION)) {
                            greatGrandKid = DOMUtil.getNextSiblingElement(greatGrandKid);
                            greatGrandKidName = greatGrandKid.getLocalName();
                        }
                        if (greatGrandKid == null) {
                            this.reportSchemaError("src-redefine.5", null);
                        } else if (!greatGrandKidName.equals(SchemaSymbols.ELT_RESTRICTION) && !greatGrandKidName.equals(SchemaSymbols.ELT_EXTENSION)) {
                            this.reportSchemaError("src-redefine.5", null);
                        } else {
                            String derivedBase = greatGrandKid.getAttribute(SchemaSymbols.ATT_BASE);
                            String processedDerivedBase = this.findQName(derivedBase, currSchema);
                            if (!processedTypeName.equals(processedDerivedBase)) {
                                this.reportSchemaError("src-redefine.5", null);
                            } else {
                                int colonptr = derivedBase.indexOf(":");
                                if (colonptr > 0) {
                                    greatGrandKid.setAttribute(SchemaSymbols.ATT_BASE, derivedBase.substring(0, colonptr) + ":" + newName);
                                } else {
                                    greatGrandKid.setAttribute(SchemaSymbols.ATT_BASE, newName);
                                }
                            }
                        }
                    }
                }
            }
        } else if (componentType.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP)) {
            String processedBaseName = currSchema.fTargetNamespace == null ? "," + oldName : currSchema.fTargetNamespace + "," + oldName;
            int attGroupRefsCount = this.changeRedefineGroup(processedBaseName, componentType, newName, child, currSchema);
            if (attGroupRefsCount > 1) {
                this.reportSchemaError("src-redefine.7.1", new Object[]{new Integer(attGroupRefsCount)});
            } else if (attGroupRefsCount != 1) {
                if (currSchema.fTargetNamespace == null) {
                    this.fRedefinedRestrictedAttributeGroupRegistry.put(processedBaseName, "," + newName);
                } else {
                    this.fRedefinedRestrictedAttributeGroupRegistry.put(processedBaseName, currSchema.fTargetNamespace + "," + newName);
                }
            }
        } else if (componentType.equals(SchemaSymbols.ELT_GROUP)) {
            String processedBaseName = currSchema.fTargetNamespace == null ? "," + oldName : currSchema.fTargetNamespace + "," + oldName;
            int groupRefsCount = this.changeRedefineGroup(processedBaseName, componentType, newName, child, currSchema);
            if (groupRefsCount > 1) {
                this.reportSchemaError("src-redefine.6.1.1", new Object[]{new Integer(groupRefsCount)});
            } else if (groupRefsCount != 1) {
                if (currSchema.fTargetNamespace == null) {
                    this.fRedefinedRestrictedGroupRegistry.put(processedBaseName, "," + newName);
                } else {
                    this.fRedefinedRestrictedGroupRegistry.put(processedBaseName, currSchema.fTargetNamespace + "," + newName);
                }
            }
        } else {
            this.reportGenericSchemaError("internal Xerces error; please submit a bug with schema as testcase");
        }
    }

    private String findQName(String name, XSDocumentInfo schemaDoc) {
        String localpart;
        SchemaNamespaceSupport currNSMap = schemaDoc.fNamespaceSupport;
        int colonPtr = name.indexOf(58);
        String prefix = this.EMPTY_STRING;
        if (colonPtr > 0) {
            prefix = name.substring(0, colonPtr);
        }
        String uri = currNSMap.getURI(this.fSymbolTable.addSymbol(prefix));
        String string = localpart = colonPtr == 0 ? name : name.substring(colonPtr + 1);
        if (prefix == this.EMPTY_STRING && uri == null && schemaDoc.fIsChameleonSchema) {
            uri = schemaDoc.fTargetNamespace;
        }
        if (uri == null) {
            return "," + localpart;
        }
        return uri + "," + localpart;
    }

    private int changeRedefineGroup(String originalQName, String elementSought, String newName, Element curr, XSDocumentInfo schemaDoc) {
        SchemaNamespaceSupport currNSMap = schemaDoc.fNamespaceSupport;
        int result = 0;
        Element child = DOMUtil.getFirstChildElement(curr);
        while (child != null) {
            String name = child.getLocalName();
            if (!name.equals(elementSought)) {
                result += this.changeRedefineGroup(originalQName, elementSought, newName, child, schemaDoc);
            } else {
                String processedRef;
                String ref = child.getAttribute(SchemaSymbols.ATT_REF);
                if (ref.length() != 0 && originalQName.equals(processedRef = this.findQName(ref, schemaDoc))) {
                    String prefix = this.EMPTY_STRING;
                    String localpart = ref;
                    int colonptr = ref.indexOf(":");
                    if (colonptr > 0) {
                        prefix = ref.substring(0, colonptr);
                        child.setAttribute(SchemaSymbols.ATT_REF, prefix + ":" + newName);
                    } else {
                        child.setAttribute(SchemaSymbols.ATT_REF, newName);
                    }
                    ++result;
                    if (elementSought.equals(SchemaSymbols.ELT_GROUP)) {
                        String minOccurs = child.getAttribute(SchemaSymbols.ATT_MINOCCURS);
                        String maxOccurs = child.getAttribute(SchemaSymbols.ATT_MAXOCCURS);
                        if (maxOccurs.length() != 0 && !maxOccurs.equals("1") || minOccurs.length() != 0 && !minOccurs.equals("1")) {
                            this.reportSchemaError("src-redefine.6.1.2", new Object[]{ref});
                        }
                    }
                }
            }
            child = DOMUtil.getNextSiblingElement(child);
        }
        return result;
    }

    private XSDocumentInfo findXSDocumentForDecl(XSDocumentInfo currSchema, Element decl) {
        Document declDoc = DOMUtil.getDocument(decl);
        Object temp = this.fDoc2XSDocumentMap.get(declDoc);
        if (temp == null) {
            return null;
        }
        XSDocumentInfo declDocInfo = (XSDocumentInfo)temp;
        return declDocInfo;
    }

    private void setSchemasVisible(XSDocumentInfo startSchema) {
        if (DOMUtil.isHidden(startSchema.fSchemaDoc)) {
            DOMUtil.setVisible(startSchema.fSchemaDoc);
            Vector dependingSchemas = (Vector)this.fDependencyMap.get(startSchema);
            int i = 0;
            while (i < dependingSchemas.size()) {
                this.setSchemasVisible((XSDocumentInfo)dependingSchemas.elementAt(i));
                ++i;
            }
        }
    }

    void reportSchemaError(String key, Object[] args) {
        this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", key, args, (short)1);
    }

    void reportGenericSchemaError(String error) {
        this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "General", new Object[]{error}, (short)1);
    }

    public static void main(String[] args) throws Exception {
        DefaultHandler handler = new DefaultHandler();
        XSGrammarResolver xsg = new XSGrammarResolver();
        XSDHandler me = new XSDHandler(xsg, new SubstitutionGroupHandler(xsg));
        XMLErrorReporter rep = new XMLErrorReporter();
        rep.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", new XSMessageFormatter());
        me.reset(rep, new EntityResolverWrapper(new DummyResolver()), new SymbolTable());
        me.parseSchema(args[0], args[1]);
        Enumeration types = me.fUnparsedTypeRegistry.keys();
        String name = null;
        while (types.hasMoreElements()) {
            name = (String)types.nextElement();
        }
    }

    public static class DummyResolver
    implements EntityResolver {
        public InputSource resolveEntity(String pubId, String sysId) throws SAXException, IOException {
            InputSource toReturn = new InputSource(sysId);
            toReturn.setPublicId(pubId);
            toReturn.setCharacterStream(new FileReader(sysId));
            return toReturn;
        }
    }
}

