/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;

class XSDAttributeGroupTraverser
extends XSDAbstractTraverser {
    XSDAttributeGroupTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    XSAttributeGroupDecl traverseLocal(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, false, schemaDoc);
        QName refAttr = (QName)attrValues[XSAttributeChecker.ATTIDX_REF];
        XSAttributeGroupDecl attrGrp = null;
        if (refAttr == null) {
            this.reportGenericSchemaError("Local attributeGroup declaration should have ref.");
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
            return null;
        }
        attrGrp = (XSAttributeGroupDecl)this.fSchemaHandler.getGlobalDecl(schemaDoc, 2, refAttr);
        Element child = DOMUtil.getFirstChildElement(elmNode);
        if (child != null) {
            String childName = DOMUtil.getLocalName(child);
            if (childName.equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.traverseAnnotationDecl(child, attrValues, false, schemaDoc);
                child = DOMUtil.getNextSiblingElement(child);
            }
            if (child != null) {
                Object[] args = new Object[]{refAttr};
                this.reportSchemaError("src-attribute_group", args);
            }
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return attrGrp;
    }

    XSAttributeGroupDecl traverseGlobal(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Element nextNode;
        String childName;
        XSAttributeGroupDecl attrGrp = new XSAttributeGroupDecl();
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, true, schemaDoc);
        String nameAttr = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        if (nameAttr == null) {
            this.reportGenericSchemaError("Global attributeGroup declaration must have a name.");
            nameAttr = "no name";
        }
        attrGrp.fName = nameAttr;
        attrGrp.fTargetNamespace = schemaDoc.fTargetNamespace;
        Element child = DOMUtil.getFirstChildElement(elmNode);
        if (child != null && (childName = DOMUtil.getLocalName(child)).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(child, attrValues, false, schemaDoc);
            child = DOMUtil.getNextSiblingElement(child);
        }
        if ((nextNode = this.traverseAttrsAndAttrGrps(child, attrGrp, schemaDoc, grammar)) != null) {
            Object[] args = new Object[]{nameAttr, DOMUtil.getLocalName(nextNode)};
            this.reportSchemaError("src-attribute_group", args);
        }
        attrGrp.removeProhibitedAttrs();
        grammar.addGlobalAttributeGroupDecl(attrGrp);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return attrGrp;
    }
}

