/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.identity;

import org.apache.xerces.impl.xpath.XPath;
import org.apache.xerces.impl.xpath.XPathException;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.identity.Field;
import org.apache.xerces.impl.xs.identity.FieldActivator;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.identity.XPathMatcher;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;

public class Selector {
    protected XPath fXPath;
    protected IdentityConstraint fIdentityConstraint;

    public Selector(XPath xpath, IdentityConstraint identityConstraint) {
        this.fXPath = xpath;
        this.fIdentityConstraint = identityConstraint;
    }

    public org.apache.xerces.impl.xpath.XPath getXPath() {
        return this.fXPath;
    }

    public IdentityConstraint getIdentityConstraint() {
        return this.fIdentityConstraint;
    }

    public XPathMatcher createMatcher(FieldActivator activator) {
        return new Matcher(this.fXPath, activator);
    }

    public String toString() {
        return this.fXPath.toString();
    }

    protected class Matcher
    extends XPathMatcher {
        protected FieldActivator fFieldActivator;
        protected int fElementDepth;
        protected int fMatchedDepth;

        public Matcher(XPath xpath, FieldActivator activator) {
            super(xpath, false, Selector.this.fIdentityConstraint);
            this.fFieldActivator = activator;
        }

        public void startDocumentFragment(SymbolTable symbolTable) throws XNIException {
            super.startDocumentFragment(symbolTable);
            this.fElementDepth = 0;
            this.fMatchedDepth = -1;
        }

        public void startElement(QName element, XMLAttributes attributes, XSElementDecl elementDecl) throws XNIException {
            super.startElement(element, attributes, elementDecl);
            ++this.fElementDepth;
            if (this.fMatchedDepth == -1 && this.isMatched()) {
                this.fMatchedDepth = this.fElementDepth;
                this.fFieldActivator.startValueScopeFor(Selector.this.fIdentityConstraint);
                int count = Selector.this.fIdentityConstraint.getFieldCount();
                int i = 0;
                while (i < count) {
                    Field field = Selector.this.fIdentityConstraint.getFieldAt(i);
                    XPathMatcher matcher = this.fFieldActivator.activateField(field);
                    matcher.startElement(element, attributes, elementDecl);
                    ++i;
                }
            }
        }

        public void endElement(QName element, XSElementDecl eDecl) {
            super.endElement(element, eDecl);
            if (this.fElementDepth-- == this.fMatchedDepth) {
                this.fMatchedDepth = -1;
                this.fFieldActivator.endValueScopeFor(Selector.this.fIdentityConstraint);
            }
        }
    }

    public static class XPath
    extends org.apache.xerces.impl.xpath.XPath {
        public XPath(String xpath, SymbolTable symbolTable, NamespaceContext context) throws XPathException {
            super(xpath.trim().startsWith("/") || xpath.trim().startsWith(".") ? xpath : "./" + xpath, symbolTable, context);
            int i = 0;
            while (i < this.fLocationPaths.length) {
                XPath.Axis axis = this.fLocationPaths[i].steps[this.fLocationPaths[i].steps.length - 1].axis;
                if (axis.type == 2) {
                    throw new XPathException("selectors cannot select attributes");
                }
                ++i;
            }
        }
    }
}

