/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.text.Collator;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.xs.AbstractStringValidator;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeFacetException;
import org.apache.xerces.impl.xs.SchemaSymbols;

public class StringDatatypeValidator
extends AbstractStringValidator {
    private short fWhiteSpace;

    public StringDatatypeValidator() {
        this(null, null, false, null);
    }

    public StringDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList, XMLErrorReporter reporter) {
        super(base, facets, derivedByList, reporter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void assignAdditionalFacets(String key, Hashtable facets) throws InvalidDatatypeFacetException {
        this.fWhiteSpace = 0;
        if (key.equals(SchemaSymbols.ELT_WHITESPACE)) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x4000);
            String ws = (String)facets.get(key);
            if (ws.equals("preserve")) {
                this.fWhiteSpace = 0;
                return;
            } else if (ws.equals("replace")) {
                this.fWhiteSpace = 1;
                return;
            } else {
                if (!ws.equals("collapse")) throw new InvalidDatatypeFacetException("whiteSpace value '" + ws + "' must be one of 'preserve', 'replace', 'collapse'.");
                this.fWhiteSpace = (short)2;
            }
            return;
        } else {
            String msg = "string datatype, facet " + key + " with value " + (String)facets.get(key);
            throw new InvalidDatatypeFacetException(msg);
        }
    }

    protected void inheritAdditionalFacets() {
        if ((this.fFacetsDefined & 0x4000) == 0 && (((StringDatatypeValidator)this.fBaseValidator).fFacetsDefined & 0x4000) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x4000);
            this.fWhiteSpace = ((StringDatatypeValidator)this.fBaseValidator).fWhiteSpace;
        }
    }

    protected void checkBaseFacetConstraints() throws InvalidDatatypeFacetException {
        if ((this.fFacetsDefined & 0x4000) != 0 && (((StringDatatypeValidator)this.fBaseValidator).fFacetsDefined & 0x4000) != 0) {
            if ((((StringDatatypeValidator)this.fBaseValidator).fFlags & 0x4000) != 0 && this.fWhiteSpace != ((StringDatatypeValidator)this.fBaseValidator).fWhiteSpace) {
                throw new InvalidDatatypeFacetException("whiteSpace value = '" + this.whiteSpaceValue(this.fWhiteSpace) + "' must be equal to base.whiteSpace value = '" + this.whiteSpaceValue(((StringDatatypeValidator)this.fBaseValidator).fWhiteSpace) + "' with attribute {fixed} = true");
            }
            if ((this.fWhiteSpace == 0 || this.fWhiteSpace == 1) && ((StringDatatypeValidator)this.fBaseValidator).fWhiteSpace == 2) {
                throw new InvalidDatatypeFacetException("It is an error if whiteSpace = 'preserve' or 'replace' and base.whiteSpace = 'collapse'.");
            }
            if (this.fWhiteSpace == 0 && ((StringDatatypeValidator)this.fBaseValidator).fWhiteSpace == 1) {
                throw new InvalidDatatypeFacetException("It is an error if whiteSpace = 'preserve' and base.whiteSpace = 'replace'.");
            }
        }
    }

    public short getWSFacet() {
        return this.fWhiteSpace;
    }

    public int compare(String value1, String value2) {
        Locale loc = Locale.getDefault();
        Collator collator = Collator.getInstance(loc);
        return collator.compare(value1, value2);
    }

    private String whiteSpaceValue(short ws) {
        return ws != 0 ? (ws == 1 ? "replace" : "collapse") : "preserve";
    }

    public Object clone() throws CloneNotSupportedException {
        StringDatatypeValidator newObj = null;
        newObj = new StringDatatypeValidator();
        newObj.fLocale = this.fLocale;
        newObj.fBaseValidator = this.fBaseValidator;
        newObj.fLength = this.fLength;
        newObj.fMaxLength = this.fMaxLength;
        newObj.fMinLength = this.fMinLength;
        newObj.fPattern = this.fPattern;
        newObj.fWhiteSpace = this.fWhiteSpace;
        newObj.fEnumeration = this.fEnumeration;
        newObj.fFacetsDefined = this.fFacetsDefined;
        return newObj;
    }
}

