/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.gui.jface_viewer;

import com.sap.sdb.syncMan.design.Column;
import com.sap.sdb.syncMan.gui.jface_dialog.ReplicationTablePropertiesDialog;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

public class ColumnsCellModifier
implements ICellModifier {
    ReplicationTablePropertiesDialog myParent;
    boolean mReadOnly = false;

    public ColumnsCellModifier(ReplicationTablePropertiesDialog parent, boolean readOnly) {
        this.myParent = parent;
        this.mReadOnly = readOnly;
    }

    public boolean canModify(Object element, String property) {
        if (this.mReadOnly) {
            return false;
        }
        int columnIndex = this.myParent.getColumnNames().indexOf(property);
        Column col = (Column)element;
        switch (columnIndex) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return col.possibleColumnConstraints().length >= 1;
            }
            case 3: {
                return col.constraintType() != 0;
            }
            case 4: {
                if (col.constraintType() == 0) {
                    return false;
                }
                return col.constraintType() == 7;
            }
        }
        return false;
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.myParent.getColumnNames().indexOf(property);
        Object result = null;
        Column col = (Column)element;
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                result = col.columnName();
                break;
            }
            case 2: {
                result = new Integer(col.constraintType());
                break;
            }
            case 3: {
                result = col.constraintValue1();
                break;
            }
            case 4: {
                result = col.constraintValue2();
                break;
            }
        }
        return result;
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.myParent.getColumnNames().indexOf(property);
        TableItem item = (TableItem)element;
        Column col = (Column)item.getData();
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                col.setColumnName(value.toString());
                break;
            }
            case 2: {
                col.setConstraintType(Integer.parseInt(value.toString()));
                break;
            }
            case 3: {
                col.setConstraintValue1(value.toString());
                break;
            }
            case 4: {
                col.setConstraintValue2(value.toString());
                break;
            }
        }
        this.myParent.refresh();
    }
}

