/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.gui.jface_dialog;

import com.sap.sdb.syncMan.design.Column;
import com.sap.sdb.syncMan.design.DesignSQLLayer;
import com.sap.sdb.syncMan.design.UnitTable;
import com.sap.sdb.syncMan.gui.jface_viewer.ColumnsCellModifier;
import com.sap.sdb.syncMan.gui.jface_viewer.ColumnsContentProvider;
import com.sap.sdb.syncMan.gui.jface_viewer.ColumnsLabelProvider;
import com.sap.sdb.syncMan.tool.ConDataBase;
import com.sap.sdb.syncMan.tool.Resources;
import com.sap.sdb.syncMan.util.ColumnDesc;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ReplicationTablePropertiesDialog
extends Dialog {
    private Table _columnsTable;
    private TableViewer _columnsViewer;
    private Text _tableName;
    private Text _tableOwner;
    private ConDataBase _con;
    private UnitTable _table;
    private Vector _cols;
    private boolean _readOnly;
    private String[] columnNames = new String[]{Resources.getString("ReplicationTablePropertiesDialog.Master_Column_Name"), Resources.getString("ReplicationTablePropertiesDialog.Column_Name"), Resources.getString("ReplicationTablePropertiesDialog.Constraint_Type"), Resources.getString("ReplicationTablePropertiesDialog.Constraint_Value1"), Resources.getString("ReplicationTablePropertiesDialog.Constraint_Value2"), Resources.getString("ReplicationTablePropertiesDialog.SQL_Type_Name"), Resources.getString("ReplicationTablePropertiesDialog.Key_Pos")};

    public ReplicationTablePropertiesDialog(Shell parentShell, ConDataBase con, UnitTable table, boolean readOnly) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this._con = con;
        this._table = table;
        this._readOnly = readOnly;
    }

    public void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Resources.getString("ReplicationTablePropertiesDialog.Columns"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite controls = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        controls.setLayout((Layout)gridLayout);
        GridData controlData = new GridData(1808);
        controls.setLayoutData((Object)controlData);
        Group main = new Group(controls, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 2;
        main.setLayout((Layout)mainLayout);
        main.setLayoutData((Object)new GridData(768));
        Label lblTableOwner = new Label((Composite)main, 0);
        lblTableOwner.setText(Resources.getString("General.TableSchema") + ":");
        GridData gridData = new GridData(1040);
        gridData.widthHint = 100;
        lblTableOwner.setLayoutData((Object)gridData);
        this._tableOwner = new Text((Composite)main, 2048);
        gridData = new GridData(1808);
        this._tableOwner.setLayoutData((Object)gridData);
        this._tableOwner.setText(this._table.getSchema());
        this._tableOwner.setEnabled(!this._readOnly);
        Label lblTableName = new Label((Composite)main, 0);
        lblTableName.setText(Resources.getString("General.TableName") + ":");
        gridData = new GridData(1040);
        gridData.widthHint = 100;
        lblTableName.setLayoutData((Object)gridData);
        this._tableName = new Text((Composite)main, 2048);
        this._tableName.setText(this._table.getName());
        this._tableName.setEnabled(!this._readOnly);
        gridData = new GridData(1808);
        this._tableName.setLayoutData((Object)gridData);
        this.createColumnsViewer(controls);
        this.refresh();
        return controls;
    }

    public void refresh() {
        this._columnsViewer.setInput((Object)new Column(-1L, "", 0, "", 0, 0, 0, 0, -1, "", ""));
    }

    protected void okPressed() {
        if (this._tableOwner.getText().length() < 1) {
            MessageDialog.openError((Shell)this.getShell(), (String)Resources.getString("ReplicationTablePropertiesDialog.Error"), (String)Resources.getString("General.Valid_Data"));
            this._tableOwner.setFocus();
            return;
        }
        if (this._tableName.getText().length() < 1) {
            MessageDialog.openError((Shell)this.getShell(), (String)Resources.getString("ReplicationTablePropertiesDialog.Error"), (String)Resources.getString("General.Valid_Data"));
            this._tableName.setFocus();
            return;
        }
        if (!this._readOnly) {
            if (!this.applyTableChanges()) {
                return;
            }
            if (!this.applyColumns()) {
                return;
            }
        }
        super.okPressed();
    }

    private void createColumnsViewer(Composite parent) {
        this.createTableForColumns(parent);
        this._columnsViewer = new TableViewer(this._columnsTable);
        this._columnsViewer.setUseHashlookup(true);
        this._columnsViewer.setColumnProperties(this.columnNames);
        CellEditor[] editors = new CellEditor[]{null, new TextCellEditor((Composite)this._columnsTable), new ComboBoxCellEditor((Composite)this._columnsTable, ColumnDesc.constraints, 4), new TextCellEditor((Composite)this._columnsTable), new TextCellEditor((Composite)this._columnsTable), null, null};
        this._columnsViewer.setCellEditors(editors);
        this._columnsViewer.setCellModifier((ICellModifier)new ColumnsCellModifier(this, this._readOnly));
        this._columnsViewer.setContentProvider((IContentProvider)new ColumnsContentProvider(this));
        this._columnsViewer.setLabelProvider((IBaseLabelProvider)new ColumnsLabelProvider());
    }

    private void createTableForColumns(Composite parent) {
        int style = 101124;
        this._columnsTable = new Table(parent, style);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = this._columnsTable.getItemHeight() * 5;
        this._columnsTable.setLayoutData((Object)gridData);
        this._columnsTable.setLinesVisible(true);
        this._columnsTable.setHeaderVisible(true);
        TableColumn column = new TableColumn(this._columnsTable, 16384, 0);
        column.setText(this.columnNames[0]);
        if (this._table.getIsMasterTable()) {
            column.setWidth(0);
        } else {
            column.setWidth(100);
        }
        column = new TableColumn(this._columnsTable, 16384, 1);
        column.setText(this.columnNames[1]);
        column.setWidth(100);
        column = new TableColumn(this._columnsTable, 16384, 2);
        column.setText(this.columnNames[2]);
        column.setWidth(150);
        column = new TableColumn(this._columnsTable, 16384, 3);
        column.setText(this.columnNames[3]);
        column.setWidth(150);
        column = new TableColumn(this._columnsTable, 16384, 4);
        column.setText(this.columnNames[4]);
        column.setWidth(150);
        column = new TableColumn(this._columnsTable, 16384, 5);
        column.setText(this.columnNames[5]);
        column.setWidth(100);
        column = new TableColumn(this._columnsTable, 16384, 6);
        column.setText(this.columnNames[6]);
        column.setWidth(0);
        this._columnsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReplicationTablePropertiesDialog.this._columnsTable.getSelectionIndex() > -1) {
                    TableItem row = ReplicationTablePropertiesDialog.this._columnsTable.getItem(ReplicationTablePropertiesDialog.this._columnsTable.getSelectionIndex());
                    Column col = (Column)row.getData();
                    ((ComboBoxCellEditor)ReplicationTablePropertiesDialog.this._columnsViewer.getCellEditors()[2]).setItems(col.possibleColumnConstraints());
                }
            }
        });
    }

    public List getColumnNames() {
        return Arrays.asList(this.columnNames);
    }

    public Vector getColumns() {
        if (this._cols == null) {
            try {
                this._table.loadColumns(this._con);
                this._cols = new Vector();
                for (int i = 0; i < this._table.getColumns().size(); ++i) {
                    Column col = (Column)this._table.getColumns().get(i);
                    this._cols.add(col);
                }
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)this.getShell(), (String)Resources.getString("ReplicationTablePropertiesDialog.Error"), (String)ex.toString());
            }
        }
        return this._cols;
    }

    private boolean applyColumns() {
        try {
            for (int i = 0; i < this._cols.size(); ++i) {
                Column col = (Column)this._cols.get(i);
                if (col.constraintType() > 0 && col.constraintValue1().length() < 1) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Resources.getString("ReplicationTablePropertiesDialog.Error"), (String)"Please enter a constraint value");
                    return false;
                }
                if (col.constraintType() == 7 && col.constraintValue2().length() < 1) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Resources.getString("ReplicationTablePropertiesDialog.Error"), (String)Resources.getString("ReplicationTablePropertiesDialog.Please_enter_a_constraint_value"));
                    return false;
                }
                DesignSQLLayer.alterColumn(this._con, this._table.getParticipantID(), this._table.getTableID(), col);
            }
            this._con.getConnection().commit();
        }
        catch (Exception ex) {
            try {
                this._con.getConnection().rollback();
                MessageDialog.openError((Shell)this.getShell(), (String)Resources.getString("ReplicationTablePropertiesDialog.Error"), (String)ex.toString());
                return false;
            }
            catch (Exception ex2) {
                MessageDialog.openError((Shell)this.getShell(), (String)Resources.getString("ReplicationTablePropertiesDialog.Error"), (String)ex.toString());
                return false;
            }
        }
        return true;
    }

    private boolean applyTableChanges() {
        try {
            this._table.setSchema(this._tableOwner.getText());
            this._table.setName(this._tableName.getText());
            DesignSQLLayer.alterUnitTable(this._con, this._table);
            this._con.getConnection().commit();
        }
        catch (Exception ex) {
            try {
                this._con.getConnection().rollback();
                MessageDialog.openError((Shell)this.getShell(), (String)Resources.getString("ReplicationTablePropertiesDialog.Error"), (String)ex.toString());
                return false;
            }
            catch (Exception ex2) {
                MessageDialog.openError((Shell)this.getShell(), (String)Resources.getString("ReplicationTablePropertiesDialog.Error"), (String)ex.toString());
                return false;
            }
        }
        return true;
    }
}

