/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.packettest;

import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.sapdb.packettest.PacketTest;
import com.sap.sapdb.packettest.core.PacketTestException;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;

public class PacketTestRTEHeader
extends PacketTest {
    public String testcase;
    public Vector RTEHeaderFieldList = new Vector();
    private StructuredBytes requestPacket = null;
    private StructuredBytes replyPacket = null;

    public PacketTestRTEHeader() throws SQLException, TestDatabaseException, Exception {
        this.RTEHeaderFieldList.add(new RTEHeaderField("Header_ActSendLen_O", 0, 4));
        this.RTEHeaderFieldList.add(new RTEHeaderField("Header_ProtocolID_O", 4, 1));
        this.RTEHeaderFieldList.add(new RTEHeaderField("Header_MessClass_O", 5, 1));
        this.RTEHeaderFieldList.add(new RTEHeaderField("Header_RTEFlags_O ", 6, 1));
        this.RTEHeaderFieldList.add(new RTEHeaderField("Header_ResidualPackets_O", 7, 1));
        this.RTEHeaderFieldList.add(new RTEHeaderField("Header_SenderRef_O", 8, 4));
        this.RTEHeaderFieldList.add(new RTEHeaderField("Header_ReceiverRef_O", 12, 4));
        this.RTEHeaderFieldList.add(new RTEHeaderField("Header_RTEReturnCode_O", 16, 2));
        this.RTEHeaderFieldList.add(new RTEHeaderField("Header_Filler_O", 18, 2));
    }

    public void run() {
        System.out.println("Starting rteHeaderTest...");
        try {
            if (!this.DATABASE.isWarm()) {
                this.DATABASE.start();
            }
        }
        catch (TestDatabaseException e) {
            e.printStackTrace();
        }
        try {
            this.RTEHeaderInfoRequestTest();
            this.RTEHeaderInfoReleaseTest();
            this.RTEHeaderDBConnectTest();
            this.RTEHeaderSQLConnectTest();
            this.RTEHeaderSQLExecuteTest();
            this.RTEHeaderSQLReleaseTest();
            this.RTEHeaderDBReleaseTest();
            this.RTEHeaderAllTest();
        }
        catch (TestDatabaseException e1) {
            e1.printStackTrace();
        }
    }

    private void RTEHeaderActSendLengthTest() throws TestDatabaseException {
        int[] packetlist = new int[]{1};
        this.testcase = "RTEHeaderActSendLength";
        System.out.println("Test: RTEHeaderActSendLength");
        long i = 1000L;
        while (i < 100000L) {
            System.out.println(i);
            try {
                this.execute(packetlist, 0, 4, i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            --i;
        }
    }

    private void RTEHeaderInfoRequestTest() throws TestDatabaseException {
        Iterator it = this.RTEHeaderFieldList.iterator();
        RTEHeaderField field = null;
        byte[] randomBytes = null;
        Random ran = new Random();
        int[] packetlist = new int[]{1};
        this.testcase = "RTEHeaderInfoRequest";
        while (it.hasNext()) {
            field = (RTEHeaderField)it.next();
            System.out.println("Test: " + field.getName());
            int i = 0;
            while (i < 10) {
                long changevalue = ran.nextLong() % new Double(Math.pow(256.0, field.getLength())).longValue();
                try {
                    this.execute(packetlist, field.getOffset(), field.getLength(), changevalue);
                }
                catch (IndexOutOfBoundsException ioobe) {
                    System.out.println(ioobe);
                }
                ++i;
            }
        }
    }

    private void RTEHeaderInfoReleaseTest() throws TestDatabaseException {
        Iterator it = this.RTEHeaderFieldList.iterator();
        RTEHeaderField field = null;
        byte[] randomBytes = null;
        Random ran = new Random();
        int[] packetlist = new int[]{2};
        this.testcase = "RTEHeaderInfoRelease";
        while (it.hasNext()) {
            field = (RTEHeaderField)it.next();
            System.out.println("Test: " + field.getName());
            int i = 0;
            while (i < 10) {
                long changevalue = ran.nextLong() % new Double(Math.pow(256.0, field.getLength())).longValue();
                this.execute(packetlist, field.getOffset(), field.getLength(), changevalue);
                ++i;
            }
        }
    }

    private void RTEHeaderDBConnectTest() throws TestDatabaseException {
        Iterator it = this.RTEHeaderFieldList.iterator();
        RTEHeaderField field = null;
        byte[] randomBytes = null;
        Random ran = new Random();
        int[] packetlist = new int[]{3};
        this.testcase = "RTEHeaderDBConnect";
        while (it.hasNext()) {
            field = (RTEHeaderField)it.next();
            System.out.println("Test: " + field.getName());
            int i = 0;
            while (i < 10) {
                long changevalue = ran.nextLong() % new Double(Math.pow(256.0, field.getLength())).longValue();
                this.execute(packetlist, field.getOffset(), field.getLength(), changevalue);
                ++i;
            }
        }
    }

    private void RTEHeaderSQLConnectTest() throws TestDatabaseException {
        Iterator it = this.RTEHeaderFieldList.iterator();
        RTEHeaderField field = null;
        byte[] randomBytes = null;
        Random ran = new Random();
        int[] packetlist = new int[]{4};
        this.testcase = "RTEHeaderSQLConnect";
        while (it.hasNext()) {
            field = (RTEHeaderField)it.next();
            System.out.println("Test: " + field.getName());
            int i = 0;
            while (i < 10) {
                long changevalue = ran.nextLong() % new Double(Math.pow(256.0, field.getLength())).longValue();
                this.execute(packetlist, field.getOffset(), field.getLength(), changevalue);
                ++i;
            }
        }
    }

    private void RTEHeaderSQLExecuteTest() throws TestDatabaseException {
        Iterator it = this.RTEHeaderFieldList.iterator();
        RTEHeaderField field = null;
        byte[] randomBytes = null;
        Random ran = new Random();
        int[] packetlist = new int[]{5};
        this.testcase = "RTEHeaderSQLExecute";
        while (it.hasNext()) {
            field = (RTEHeaderField)it.next();
            System.out.println("Test: " + field.getName());
            int i = 0;
            while (i < 10) {
                long changevalue = ran.nextLong() % new Double(Math.pow(256.0, field.getLength())).longValue();
                this.execute(packetlist, field.getOffset(), field.getLength(), changevalue);
                ++i;
            }
        }
    }

    private void RTEHeaderSQLReleaseTest() throws TestDatabaseException {
        Iterator it = this.RTEHeaderFieldList.iterator();
        RTEHeaderField field = null;
        byte[] randomBytes = null;
        Random ran = new Random();
        int[] packetlist = new int[]{6};
        this.testcase = "RTEHeaderSQLRelease";
        while (it.hasNext()) {
            field = (RTEHeaderField)it.next();
            System.out.println("Test: " + field.getName());
            int i = 0;
            while (i < 10) {
                long changevalue = ran.nextLong() % new Double(Math.pow(256.0, field.getLength())).longValue();
                this.execute(packetlist, field.getOffset(), field.getLength(), changevalue);
                ++i;
            }
        }
    }

    private void RTEHeaderDBReleaseTest() throws TestDatabaseException {
        Iterator it = this.RTEHeaderFieldList.iterator();
        RTEHeaderField field = null;
        byte[] randomBytes = null;
        Random ran = new Random();
        int[] packetlist = new int[]{7};
        this.testcase = "RTEHeaderDBRelease";
        while (it.hasNext()) {
            field = (RTEHeaderField)it.next();
            System.out.println("Test: " + field.getName());
            int i = 0;
            while (i < 10) {
                long changevalue = ran.nextLong() % new Double(Math.pow(256.0, field.getLength())).longValue();
                this.execute(packetlist, field.getOffset(), field.getLength(), changevalue);
                ++i;
            }
        }
    }

    private void RTEHeaderAllTest() throws TestDatabaseException {
        Iterator it = this.RTEHeaderFieldList.iterator();
        RTEHeaderField field = null;
        byte[] randomBytes = null;
        Random ran = new Random();
        int[] packetlist = new int[]{1, 2, 3, 4, 5, 6, 7};
        this.testcase = "RTEHeaderDBRelease";
        while (it.hasNext()) {
            field = (RTEHeaderField)it.next();
            System.out.println("Test: " + field.getName());
            int i = 0;
            while (i < 10) {
                long changevalue = ran.nextLong() % new Double(Math.pow(256.0, field.getLength())).longValue();
                this.execute(packetlist, field.getOffset(), field.getLength(), changevalue);
                ++i;
            }
        }
    }

    private void RTEHeaderRefs() {
        int packetnumber = 1;
        try {
            this.connect();
            StructuredBytes requestPacket = this.createInfoRequestPacket();
            this.out.write(requestPacket.bytes());
            System.out.println("Info Request:");
            System.out.println("Sender Ref: " + requestPacket.getInt4(8));
            System.out.println("Receiver Ref: " + requestPacket.getInt4(12));
            StructuredBytes replyPacket = this.receiveConnect();
            this.packetLayout = PacketTest.getPacketLayoutFromReply(replyPacket, true);
            System.out.println("Info Reply:");
            System.out.println("Sender Ref: " + replyPacket.getInt4(8));
            System.out.println("Receiver Ref: " + replyPacket.getInt4(12));
            ++packetnumber;
            requestPacket = this.createReleasePacket();
            this.out.write(requestPacket.bytes());
            this.sock.close();
            System.out.println("Release:");
            System.out.println("Sender Ref: " + requestPacket.getInt4(8));
            System.out.println("Receiver Ref: " + requestPacket.getInt4(12));
            this.connect();
            ++packetnumber;
            requestPacket = this.createDbConnectPacket(this.DBNAME);
            this.out.write(requestPacket.bytes());
            System.out.println("DB Connect:");
            System.out.println("Sender Ref: " + requestPacket.getInt4(8));
            System.out.println("Receiver Ref: " + requestPacket.getInt4(12));
            replyPacket = this.receiveConnect();
            System.out.println("DB Connect Reply:");
            System.out.println("Sender Ref: " + replyPacket.getInt4(8));
            System.out.println("Receiver Ref: " + replyPacket.getInt4(12));
            ++packetnumber;
            requestPacket = this.createSqlConnectPacket();
            this.out.write(requestPacket.bytes());
            System.out.println("SQL Connect:");
            System.out.println("Sender Ref: " + requestPacket.getInt4(8));
            System.out.println("Receiver Ref: " + requestPacket.getInt4(12));
            replyPacket = this.receiveData();
            System.out.println("SQL Connect Reply:");
            System.out.println("Sender Ref: " + replyPacket.getInt4(8));
            System.out.println("Receiver Ref: " + replyPacket.getInt4(12));
            ++packetnumber;
            requestPacket = this.createSqlStatementPacket("select * from users");
            this.out.write(requestPacket.bytes());
            System.out.println("SQL Statement Connect:");
            System.out.println("Sender Ref: " + requestPacket.getInt4(8));
            System.out.println("Receiver Ref: " + requestPacket.getInt4(12));
            replyPacket = this.receiveData();
            System.out.println("SQL Statement Reply:");
            System.out.println("Sender Ref: " + replyPacket.getInt4(8));
            System.out.println("Receiver Ref: " + replyPacket.getInt4(12));
            ++packetnumber;
            requestPacket = this.createSqlReleasePacket();
            this.out.write(requestPacket.bytes());
            System.out.println("SQL Disconnect:");
            System.out.println("Sender Ref: " + requestPacket.getInt4(8));
            System.out.println("Receiver Ref: " + requestPacket.getInt4(12));
            replyPacket = this.receiveData();
            System.out.println("SQL Disconnect Reply:");
            System.out.println("Sender Ref: " + replyPacket.getInt4(8));
            System.out.println("Receiver Ref: " + replyPacket.getInt4(12));
            ++packetnumber;
            requestPacket = this.createReleasePacket();
            this.out.write(requestPacket.bytes());
            this.sock.close();
            System.out.println("DB Disconnect:");
            System.out.println("Sender Ref: " + requestPacket.getInt4(8));
            System.out.println("Receiver Ref: " + requestPacket.getInt4(12));
        }
        catch (PacketTestException ptex) {
            System.out.println(ptex);
        }
        catch (RTEException rteex) {
            System.out.println((Object)rteex);
        }
        catch (IOException ioex) {
            System.out.println(ioex);
        }
        catch (SQLException sqlex) {
            System.out.println(sqlex);
        }
    }

    protected void execute(int[] packets, int pos, int len, long value) throws TestDatabaseException {
        int packetnumber = 1;
        if (!this.DATABASE.isWarm()) {
            if (PacketTest.DEBUG) {
                System.out.println("Starting Database");
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.DATABASE.start();
        }
        try {
            this.connect();
            this.requestPacket = this.createInfoRequestPacket();
            if (this.contains(packets, packetnumber)) {
                this.alterPacket(this.requestPacket, pos, len, value);
            }
            this.out.write(this.requestPacket.bytes());
            this.printDebug(true, packetnumber, this.requestPacket);
            this.replyPacket = this.receiveConnect();
            this.printDebug(false, packetnumber, this.replyPacket);
            this.packetLayout = PacketTest.getPacketLayoutFromReply(this.replyPacket, true);
            this.requestPacket = this.createReleasePacket();
            if (this.contains(packets, ++packetnumber)) {
                this.alterPacket(this.requestPacket, pos, len, value);
            }
            this.printDebug(true, packetnumber, this.requestPacket);
            this.out.write(this.requestPacket.bytes());
            this.sock.close();
            this.connect();
            this.requestPacket = this.createDbConnectPacket(this.DBNAME);
            if (this.contains(packets, ++packetnumber)) {
                this.alterPacket(this.requestPacket, pos, len, value);
            }
            this.printDebug(true, packetnumber, this.requestPacket);
            this.out.write(this.requestPacket.bytes());
            this.replyPacket = this.receiveConnect();
            this.printDebug(false, packetnumber, this.replyPacket);
            this.requestPacket = this.createSqlConnectPacket();
            if (this.contains(packets, ++packetnumber)) {
                this.alterPacket(this.requestPacket, pos, len, value);
            }
            this.printDebug(true, packetnumber, this.requestPacket);
            this.out.write(this.requestPacket.bytes());
            this.replyPacket = this.receiveData();
            this.printDebug(false, packetnumber, this.replyPacket);
            this.requestPacket = this.createSqlStatementPacket("select * from users");
            if (this.contains(packets, ++packetnumber)) {
                this.alterPacket(this.requestPacket, pos, len, value);
            }
            this.printDebug(true, packetnumber, this.requestPacket);
            this.out.write(this.requestPacket.bytes());
            this.replyPacket = this.receiveData();
            this.printDebug(false, packetnumber, this.replyPacket);
            this.requestPacket = this.createSqlReleasePacket();
            if (this.contains(packets, ++packetnumber)) {
                this.alterPacket(this.requestPacket, pos, len, value);
            }
            this.printDebug(true, packetnumber, this.requestPacket);
            this.out.write(this.requestPacket.bytes());
            this.replyPacket = this.receiveData();
            this.printDebug(false, packetnumber, this.replyPacket);
            this.requestPacket = this.createReleasePacket();
            if (this.contains(packets, ++packetnumber)) {
                this.alterPacket(this.requestPacket, pos, len, value);
            }
            this.printDebug(true, packetnumber, this.requestPacket);
            this.out.write(this.requestPacket.bytes());
            this.sock.close();
        }
        catch (PacketTestException ptex) {
            this.handleError(ptex, packetnumber, pos, len, value, this.requestPacket);
        }
        catch (RTEException rteex) {
            this.handleError((Exception)((Object)rteex), packetnumber, pos, len, value, this.requestPacket);
        }
        catch (IOException ioex) {
            this.handleError(ioex, packetnumber, pos, len, value, this.requestPacket);
        }
        catch (SQLException sqlex) {
            this.handleError(sqlex, packetnumber, pos, len, value, this.requestPacket);
        }
    }

    public boolean contains(int[] array, int value) {
        if (array == null) {
            return false;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void alterPacket(StructuredBytes packet, int pos, int len, long value) {
        switch (len) {
            case 1: {
                packet.putInt1((int)value, pos);
                break;
            }
            case 2: {
                packet.putInt2((int)value, pos);
                break;
            }
            case 4: {
                packet.putInt4((int)value, pos);
                break;
            }
            case 8: {
                packet.putInt8(value, pos);
                break;
            }
            default: {
                packet.putBytes(this.makeBytes(value, len), pos);
            }
        }
    }

    private void handleError(Exception ex, int packetnumber, int pos, int len, long value, StructuredBytes packet) throws TestDatabaseException {
        boolean dbIsWarm = this.DATABASE.isWarm();
        if (PacketTest.DEBUG) {
            String state = dbIsWarm ? "warm" : "not warm";
            byte[] b = this.makeBytes(value, len);
            String bytes = "";
            int i = 0;
            while (i < b.length) {
                bytes = String.valueOf(bytes) + "[" + b[i] + "]";
                ++i;
            }
            String message = "Exception in test case '" + this.testcase + "', db is " + state + "\n" + ex.getMessage() + "\n" + "Packet " + packetnumber + ":\n" + "Change " + len + " bytes at position " + pos + " to " + bytes + "\n" + new String(packet.bytes());
            System.err.println(message);
        }
        if (!dbIsWarm) {
            byte[] b = this.makeBytes(value, len);
            String bytes = "";
            int i = 0;
            while (i < b.length) {
                bytes = String.valueOf(bytes) + "[" + b[i] + "]";
                ++i;
            }
            String message = "Exception in test case '" + this.testcase + "', database IS DOWN\n" + ex.getMessage() + "\n" + "Packet " + packetnumber + ":\n" + "Change " + len + " bytes at position " + pos + " to " + bytes + "\n" + new String(packet.bytes());
            this.addMessage("DB shot down", 'E', message);
        }
    }

    private byte[] makeBytes(long value, int len) {
        byte[] b = new byte[len];
        int i = 0;
        while (i < len) {
            b[len - i - 1] = (byte)(value % 256L);
            value = (long)Math.floor(value / 256L);
            ++i;
        }
        return b;
    }

    private long chartoint(char[] array) {
        long result = 0L;
        int i = 0;
        while (i < array.length) {
            result = (long)((double)result + (double)array[array.length - i - 1] * Math.pow(256.0, i));
            ++i;
        }
        return result;
    }

    private void printDebug(boolean request, int packetnumber, StructuredBytes packet) {
        if (PacketTest.DEBUG) {
            String kind = request ? "Request" : "Reply";
            System.out.println(String.valueOf(kind) + " " + packetnumber + ": " + new String(packet.bytes()));
        }
    }

    protected class RTEHeaderField {
        private String name = null;
        private int offset;
        private int length;

        public int getLength() {
            return this.length;
        }

        public String getName() {
            return this.name;
        }

        public int getOffset() {
            return this.offset;
        }

        public RTEHeaderField(String name, int offset, int length) {
            this.name = name;
            this.offset = offset;
            this.length = length;
        }
    }
}

